/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OilLampBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    protected static final VoxelShape[] SHAPES;

    public OilLampBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED, LIT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean waterlogged = fluid.func_206884_a((ITag)FluidTags.field_206959_a);
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!waterlogged))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
                worldIn.func_180501_a(currentPos, (BlockState)stateIn.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return stateIn;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (heldItem.func_190926_b() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            playerIn.func_184185_a(SoundEvents.field_187646_bt, 0.4f, 1.0f);
        } else if (heldItem.func_77973_b() == Items.field_151033_d && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            playerIn.func_184185_a(SoundEvents.field_187649_bu, 0.4f, 1.0f);
            heldItem.func_222118_a(1, (LivingEntity)playerIn, i -> i.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return ActionResultType.SUCCESS;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        int horizIndex = ((Direction)state.func_177229_b((Property)field_185512_D)).func_176736_b();
        return horizIndex < 0 ? VoxelShapes.func_197868_b() : SHAPES[horizIndex];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            Direction d = ((Direction)stateIn.func_177229_b((Property)field_185512_D)).func_176735_f();
            double addX = 0.32 * (double)d.func_82601_c();
            double addY = 0.4;
            double addZ = 0.32 * (double)d.func_82599_e();
            Vector3d vec = Vector3d.func_237492_c_((Vector3i)pos).func_72441_c(addX, addY, addZ);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    static {
        VoxelShape bodyX = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape bodyZ = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape handleN = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)12.0, (double)0.0, (double)7.0, (double)14.0, (double)4.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)1.0, (double)7.0, (double)13.0, (double)3.0, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape handleS = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)7.0, (double)4.0, (double)4.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)1.0, (double)7.0, (double)4.0, (double)3.0, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape handleW = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)2.0, (double)9.0, (double)4.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)3.0, (double)9.0, (double)3.0, (double)4.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape handleE = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)12.0, (double)9.0, (double)4.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)12.0, (double)9.0, (double)3.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape shapeN = VoxelShapes.func_216384_a((VoxelShape)bodyX, (VoxelShape[])new VoxelShape[]{handleN, Block.func_208617_a((double)1.0, (double)2.0, (double)6.0, (double)4.0, (double)4.0, (double)10.0)});
        VoxelShape shapeS = VoxelShapes.func_216384_a((VoxelShape)bodyX, (VoxelShape[])new VoxelShape[]{handleS, Block.func_208617_a((double)12.0, (double)2.0, (double)6.0, (double)15.0, (double)4.0, (double)10.0)});
        VoxelShape shapeW = VoxelShapes.func_216384_a((VoxelShape)bodyZ, (VoxelShape[])new VoxelShape[]{handleW, Block.func_208617_a((double)6.0, (double)2.0, (double)12.0, (double)10.0, (double)4.0, (double)15.0)});
        VoxelShape shapeE = VoxelShapes.func_216384_a((VoxelShape)bodyZ, (VoxelShape[])new VoxelShape[]{handleE, Block.func_208617_a((double)6.0, (double)2.0, (double)1.0, (double)10.0, (double)4.0, (double)4.0)});
        SHAPES = new VoxelShape[]{shapeS, shapeW, shapeN, shapeE};
    }
}

