/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.GFRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class ReedsBlock
extends DoublePlantBlock
implements IWaterLoggable,
IGrowable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public ReedsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF}).func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluid = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = super.func_196258_a(context);
        return blockstate != null ? (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206884_a((ITag)FluidTags.field_206959_a))) : null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return stateDown.func_203425_a((Block)this) && stateDown.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        }
        boolean nearWater = ReedsBlock.isInWater((IBlockReader)world, pos) || ReedsBlock.isNextToWater((IBlockReader)world, pos.func_177977_b());
        boolean belowAir = world.func_204610_c(pos.func_177984_a()).func_206888_e();
        boolean aboveSoil = stateDown.func_200132_m() && (stateDown.canSustainPlant((IBlockReader)world, pos.func_177977_b(), Direction.UP, (IPlantable)this) || this.func_200014_a_(stateDown, (IBlockReader)world, pos.func_177977_b()));
        return nearWater && belowAir && aboveSoil;
    }

    public void func_196390_a(IWorld worldIn, BlockPos pos, int flags) {
        boolean water = worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water)), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150351_n) || state.func_203425_a(Blocks.field_150354_m) || super.func_200014_a_(state, worldIn, pos);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)GFRegistry.REEDS);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.WATER;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return false;
    }

    public boolean func_176473_a(IBlockReader reader, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        ReedsBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
    }

    public static boolean isInWater(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_185778_de);
    }

    public static boolean isNextToWater(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!ReedsBlock.isInWater(worldIn, pos.func_177972_a(direction))) continue;
            return true;
        }
        return false;
    }
}

