/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.block;

import greekfantasy.GFRegistry;
import greekfantasy.GFWorldSavedData;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.FavorManager;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.gui.StatueContainer;
import greekfantasy.network.SSimpleParticlesPacket;
import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.StatuePose;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class StatueBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB_STATUE_BOTTOM = VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    protected static final VoxelShape AABB_STATUE_TOP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)24.0, (double)14.0);
    protected final StatueMaterial statueMaterial;
    private final ResourceLocation deity;
    private final Consumer<StatueTileEntity> tileEntityInit;

    public StatueBlock(StatueMaterial material) {
        this(material, te -> te.setStatueFemale(Math.random() < 0.5));
    }

    public StatueBlock(StatueMaterial material, Consumer<StatueTileEntity> teInit) {
        this(material, teInit, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_().func_235838_a_(b -> material.getLightLevel()));
    }

    public StatueBlock(StatueMaterial material, Consumer<StatueTileEntity> teInit, AbstractBlock.Properties properties) {
        this(material, teInit, properties, Deity.EMPTY.getName());
    }

    public StatueBlock(StatueMaterial material, Consumer<StatueTileEntity> teInit, AbstractBlock.Properties properties, ResourceLocation deityName) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
        this.statueMaterial = material;
        this.tileEntityInit = teInit;
        this.deity = deityName;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, field_185512_D, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206884_a((ITag)FluidTags.field_206959_a)))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (this.statueMaterial == StatueMaterial.WOOD && worldIn instanceof ServerWorld) {
            GFWorldSavedData data = GFWorldSavedData.getOrCreate((ServerWorld)worldIn);
            data.addPalladium(new ChunkPos(pos), pos);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
        FluidState fluid = worldIn.func_204610_c(pos.func_177984_a());
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206884_a((ITag)FluidTags.field_206959_a)))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)field_185512_D, (Comparable)facing), 3);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean isUpper = half == DoubleBlockHalf.UPPER;
        BlockPos tePos = isUpper ? pos.func_177977_b() : pos;
        TileEntity tileentity = worldIn.func_175625_s(tePos);
        if (this.canDropItems(state, (IBlockReader)worldIn) && !worldIn.func_201670_d() && tileentity instanceof StatueTileEntity) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((StatueTileEntity)tileentity).getInventory());
        }
        BlockPos otherHalf = isUpper ? pos.func_177977_b() : pos.func_177984_a();
        worldIn.func_225521_a_(otherHalf, true, (Entity)player);
        worldIn.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
            boolean isUpper = half == DoubleBlockHalf.UPPER;
            BlockPos tePos = isUpper ? pos.func_177977_b() : pos;
            TileEntity tileentity = worldIn.func_175625_s(tePos);
            if (this.canDropItems(state, (IBlockReader)worldIn) && !worldIn.func_201670_d() && tileentity instanceof StatueTileEntity) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((StatueTileEntity)tileentity).getInventory());
            }
            BlockPos otherHalf = isUpper ? pos.func_177977_b() : pos.func_177984_a();
            worldIn.func_175655_b(otherHalf, true);
            if (this.statueMaterial == StatueMaterial.WOOD && worldIn instanceof ServerWorld) {
                GFWorldSavedData data = GFWorldSavedData.getOrCreate((ServerWorld)worldIn);
                data.removePalladium(new ChunkPos(pos), pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        if (!this.statueMaterial.hasGui()) {
            return ActionResultType.PASS;
        }
        BlockPos tePos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos;
        TileEntity te = worldIn.func_175625_s(tePos);
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn instanceof ServerPlayerEntity && te instanceof StatueTileEntity) {
            StatueTileEntity teStatue = (StatueTileEntity)te;
            if (teStatue.hasDeity() && teStatue.getDeityName().equals(this.deity.toString()) && teStatue.getDeity().isEnabled()) {
                IDeity ideity = teStatue.getDeity();
                playerIn.getCapability(GreekFantasy.FAVOR).ifPresent(f -> {
                    if (f.isEnabled()) {
                        FavorLevel level = f.getFavor(ideity);
                        ItemStack copy = stack.func_77946_l();
                        if (FavorManager.onGiveItem(teStatue, ideity, playerIn, f, level, stack)) {
                            boolean happy = ideity.getItemFavorModifier(copy.func_77973_b()) > 0;
                            GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(happy, pos, 10));
                        } else {
                            playerIn.func_184611_a(handIn, teStatue.handleItemInteraction(playerIn, ideity, (IFavor)f, stack));
                        }
                        level.sendStatusMessage(playerIn, ideity);
                    }
                });
                return ActionResultType.SUCCESS;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb && stack.func_82837_s()) {
                teStatue.setTextureName(stack.func_200301_q().func_150261_e(), true);
                if (!playerIn.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.CONSUME;
            }
            StatuePose currentPose = teStatue.getStatuePose();
            boolean isFemale = teStatue.isStatueFemale();
            String name = teStatue.getTextureName();
            Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, player) -> new StatueContainer(id, inventory, teStatue, currentPose, isFemale, name, tePos, facing), StringTextComponent.field_240750_d_), buf -> {
                buf.writeBoolean(isFemale);
                buf.func_179255_a(tePos);
                buf.func_150786_a(currentPose.serializeNBT());
                buf.func_180714_a(name);
                buf.writeByte(facing.func_176736_b());
            });
        }
        return ActionResultType.SUCCESS;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? AABB_STATUE_TOP : AABB_STATUE_BOTTOM;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        StatueTileEntity te = (StatueTileEntity)GFRegistry.STATUE_TE.func_200968_a();
        te.setUpper(state.func_177229_b(HALF) == DoubleBlockHalf.UPPER);
        this.tileEntityInit.accept(te);
        return te;
    }

    public StatueMaterial getStatueMaterial() {
        return this.statueMaterial;
    }

    public boolean canDropItems(BlockState state, IBlockReader world) {
        return this.statueMaterial.dropsItems() && !this.hasDeity();
    }

    public boolean hasDeity() {
        return !this.deity.equals((Object)Deity.EMPTY.getName());
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        BlockPos tePos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos;
        TileEntity te = worldIn.func_175625_s(tePos);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public static enum StatueMaterial implements IStringSerializable
    {
        LIMESTONE("limestone", true, 0, () -> GFRegistry.POLISHED_LIMESTONE_SLAB.func_176223_P()),
        MARBLE("marble", true, 0, () -> GFRegistry.POLISHED_MARBLE_SLAB.func_176223_P()),
        WOOD("wood", false, 11, () -> Blocks.field_196624_br.func_176223_P());

        private final ResourceLocation stoneTexture;
        private final String name;
        private final boolean hasGui;
        private final boolean dropsItems;
        private final int light;
        private final Supplier<BlockState> base;

        private StatueMaterial(String nameIn, boolean hasGuiIn, int lightIn, Supplier<BlockState> baseIn) {
            this(nameIn, nameIn, hasGuiIn, hasGuiIn, lightIn, baseIn);
        }

        private StatueMaterial(String nameIn, String textureNameIn, boolean hasGuiIn, boolean dropsItemsIn, int lightIn, Supplier<BlockState> baseIn) {
            this.name = nameIn;
            this.hasGui = hasGuiIn;
            this.dropsItems = dropsItemsIn;
            this.light = lightIn;
            this.base = baseIn;
            this.stoneTexture = new ResourceLocation("greekfantasy", "textures/entity/statue/" + textureNameIn + ".png");
        }

        public boolean hasGui() {
            return this.hasGui;
        }

        public boolean dropsItems() {
            return this.dropsItems;
        }

        public boolean hasSkin() {
            return this != WOOD;
        }

        public BlockState getBase() {
            return this.base.get();
        }

        public ResourceLocation getStoneTexture() {
            return this.stoneTexture;
        }

        public int getLightLevel() {
            return this.light;
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        public static StatueMaterial getById(byte id) {
            return StatueMaterial.values()[id];
        }

        public static StatueMaterial getByName(String id) {
            for (StatueMaterial s : StatueMaterial.values()) {
                if (!s.func_176610_l().equals(id)) continue;
                return s;
            }
            return LIMESTONE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

