/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.client.gui.ScrollButton;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.FavorRange;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredFavorRange;
import greekfantasy.deity.favor_effect.FavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.gui.DeityContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class DeityScreen
extends ContainerScreen<DeityContainer> {
    private static final ResourceLocation SCREEN_TEXTURE = new ResourceLocation("greekfantasy", "textures/gui/deity.png");
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("greekfantasy", "textures/gui/deity_tabs.png");
    private static final int SCREEN_WIDTH = 196;
    private static final int SCREEN_HEIGHT = 160;
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 32;
    private static final int TAB_COUNT = 7;
    private static final int ARROW_WIDTH = 14;
    private static final int ARROW_HEIGHT = 18;
    private static final int FAVOR_LEFT = 9;
    private static final int FAVOR_TOP = 16;
    private static final int BTN_LEFT = 7;
    private static final int BTN_TOP = 89;
    private static final int BTN_WIDTH = 70;
    private static final int BTN_HEIGHT = 16;
    private static final int ITEM_LEFT = 80;
    private static final int ITEM_TOP = 25;
    private static final int ITEM_WIDTH = 48;
    private static final int ITEM_HEIGHT = 18;
    private static final int ITEM_COUNT_X = 2;
    private static final int ITEM_COUNT_Y = 7;
    private static final int ENTITY_LEFT = 80;
    private static final int ENTITY_TOP = 32;
    private static final int ENTITY_COUNT_Y = 13;
    private static final int ENTITY_WIDTH = 90;
    private static final int BLESSING_LEFT = 80;
    private static final int BLESSING_TOP = 32;
    private static final int BLESSING_COUNT_Y = 6;
    private static final int BLESSING_WIDTH = 90;
    private static final int HOSTILE_LEFT = 89;
    private static final int HOSTILE_TOP = 32;
    private static final int HOSTILE_COUNT_Y = 6;
    private static final int HOSTILE_WIDTH = 81;
    private static final int SCROLL_LEFT = 174;
    private static final int SCROLL_TOP = 22;
    private static final int SCROLL_WIDTH = 14;
    private static final int SCROLL_HEIGHT = 124;
    private final List<IDeity> deityList = new ArrayList<IDeity>();
    private final TabButton[] tabButtons = new TabButton[7];
    private final List<List<ItemButton>> itemButtons = new ArrayList<List<ItemButton>>();
    private final List<List<EntityButton>> entityButtons = new ArrayList<List<EntityButton>>();
    private final List<List<BlessingButton>> blessingButtons = new ArrayList<List<BlessingButton>>();
    private final List<List<HostileButton>> hostileButtons = new ArrayList<List<HostileButton>>();
    private TabArrowButton tabLeftButton;
    private TabArrowButton tabRightButton;
    private ScrollButton<DeityScreen> scrollButton;
    private int tabGroup;
    private int selected;
    private Mode mode;
    private int guiLeft;
    private int guiTop;
    private boolean scrollEnabled;
    private IFavor favor;

    public DeityScreen(DeityContainer screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.favor = screenContainer.getFavor();
        if (this.deityList.isEmpty()) {
            this.deityList.addAll(GreekFantasy.PROXY.getDeityCollection(true));
            this.deityList.sort((d1, d2) -> this.favor.getFavor((IDeity)d2).compareToAbs(this.favor.getFavor((IDeity)d1)));
            int deityL = this.deityList.size();
            for (int deityNum = 0; deityNum < deityL; ++deityNum) {
                Button button;
                IDeity d = this.deityList.get(deityNum);
                ArrayList<ItemButton> itemButtonList = new ArrayList<ItemButton>();
                for (Map.Entry<ResourceLocation, Integer> e : d.getItemFavorModifiers().entrySet()) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(e.getKey());
                    itemButtonList.add(new ItemButton(this, item, e.getValue(), 0, 0));
                }
                itemButtonList.sort(ItemButton::compareTo);
                int l2 = itemButtonList.size();
                for (int i = 0; i < l2; ++i) {
                    ((ItemButton)itemButtonList.get(i)).setIndex(i);
                }
                this.itemButtons.add(itemButtonList);
                ArrayList<EntityButton> entityButtonList = new ArrayList<EntityButton>();
                for (Map.Entry<ResourceLocation, Integer> e : d.getKillFavorModifiers().entrySet()) {
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(e.getKey());
                    button = new EntityButton(this, entityType, e.getValue(), 0, 0);
                    entityButtonList.add((EntityButton)button);
                }
                entityButtonList.sort(EntityButton::compareTo);
                int l3 = entityButtonList.size();
                for (int i = 0; i < l3; ++i) {
                    ((EntityButton)entityButtonList.get(i)).setIndex(i);
                }
                this.entityButtons.add(entityButtonList);
                ArrayList<EntityButton> blessingButtonList = new ArrayList<EntityButton>();
                for (SpecialFavorEffect specialFavorEffect : d.getSpecialFavorEffects()) {
                    button = new BlessingButton(this, specialFavorEffect.getType(), specialFavorEffect.getMinLevel(), specialFavorEffect.getMaxLevel(), 0, 0);
                    blessingButtonList.add((EntityButton)button);
                }
                for (FavorEffect favorEffect : d.getFavorEffects()) {
                    button = new BlessingButton(this, favorEffect, favorEffect.getMinLevel(), favorEffect.getMaxLevel(), 0, 0);
                    blessingButtonList.add((EntityButton)button);
                }
                blessingButtonList.sort(BlessingButton::compareTo);
                int n = blessingButtonList.size();
                for (int i = 0; i < n; ++i) {
                    ((BlessingButton)blessingButtonList.get(i)).setIndex(i);
                }
                this.blessingButtons.add(blessingButtonList);
                this.hostileButtons.add(new ArrayList());
            }
        }
        ArrayList<HostileButton> hostileButtonList = new ArrayList<HostileButton>();
        for (Map.Entry<ResourceLocation, ConfiguredFavorRange> e : GreekFantasy.PROXY.getFavorConfiguration().getEntityTargetMap().entrySet()) {
            if (!e.getValue().hasHostileRange()) continue;
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(e.getKey());
            FavorRange hostile = e.getValue().getHostileRange();
            HostileButton button = new HostileButton(this, entityType, hostile.getDeity(), hostile.getMinLevel(), hostile.getMaxLevel(), 0, 0);
            hostileButtonList.add(button);
        }
        for (HostileButton btn : hostileButtonList) {
            int index = this.deityList.indexOf(btn.deity);
            btn.setIndex(this.hostileButtons.get(index).size());
            this.hostileButtons.get(index).add(btn);
        }
        this.hostileButtons.forEach(l -> l.sort(HostileButton::compareTo));
        this.scrollEnabled = this.itemButtons.get(this.selected).size() > 14;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.guiLeft = (this.field_230708_k_ - 196 - 28) / 2;
        this.guiTop = (this.field_230709_l_ - 128) / 2 - 10;
        this.field_238745_s_ = this.field_230709_l_;
        this.func_230480_a_((Widget)new Button(this.guiLeft, this.guiTop + 160 + 4, 196, 20, (ITextComponent)new TranslationTextComponent("gui.done"), c -> this.field_230706_i_.func_147108_a(null)));
        int l2 = Math.min(7, this.deityList.size());
        for (int i = 0; i < l2; ++i) {
            this.tabButtons[i] = (TabButton)this.func_230480_a_((Widget)new TabButton(this, i, (ITextComponent)this.deityList.get(i).getText(), this.guiLeft + i * 28, this.guiTop - 32 + 4));
        }
        this.tabLeftButton = (TabArrowButton)this.func_230480_a_((Widget)new TabArrowButton(this, true, this.guiLeft - 14 - 2, this.guiTop - 22));
        this.tabRightButton = (TabArrowButton)this.func_230480_a_((Widget)new TabArrowButton(this, false, this.guiLeft + 196 + 2, this.guiTop - 22));
        this.itemButtons.forEach(l -> l.forEach(b -> {
            ItemButton cfr_ignored_0 = (ItemButton)this.func_230480_a_((Widget)b);
        }));
        this.entityButtons.forEach(l -> l.forEach(b -> {
            EntityButton cfr_ignored_0 = (EntityButton)this.func_230480_a_((Widget)b);
        }));
        this.blessingButtons.forEach(l -> l.forEach(b -> {
            BlessingButton cfr_ignored_0 = (BlessingButton)this.func_230480_a_((Widget)b);
        }));
        this.hostileButtons.forEach(l -> l.forEach(b -> {
            HostileButton cfr_ignored_0 = (HostileButton)this.func_230480_a_((Widget)b);
        }));
        this.scrollButton = (ScrollButton)this.func_230480_a_((Widget)new ScrollButton<DeityScreen>(this, this.guiLeft + 174, this.guiTop + 22, 14, 124, 0, 192, SCREEN_TEXTURE, s -> s.scrollEnabled, 4, b -> this.updateScroll(b.getScrollAmount())));
        this.func_230480_a_((Widget)new ModeButton(this, this.guiLeft + 7, this.guiTop + 89, "gui.mirror.item", Mode.ITEM));
        this.func_230480_a_((Widget)new ModeButton(this, this.guiLeft + 7, this.guiTop + 89 + 16, "gui.mirror.entity", Mode.ENTITY));
        this.func_230480_a_((Widget)new ModeButton(this, this.guiLeft + 7, this.guiTop + 89 + 32, "gui.mirror.blessing", Mode.BLESSING));
        this.func_230480_a_((Widget)new ModeButton(this, this.guiLeft + 7, this.guiTop + 89 + 48, "gui.mirror.hostile", Mode.HOSTILE));
        this.setSelectedTab(0);
        this.setSelectedDeity(0);
        this.updateMode(Mode.ITEM);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.scrollButton != null) {
            this.scrollButton.tick();
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, 196, 160);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent("** ").func_230529_a_((ITextComponent)this.deityList.get(this.selected).getText()).func_240702_b_(" **").func_240699_a_(TextFormatting.BLACK), (float)(this.guiLeft + 9), (float)(this.guiTop + 5), 0xFFFFFF);
        String subtitle = this.mode.getTooltip();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent(subtitle).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}), (float)(this.guiLeft + 88), (float)(this.guiTop + 16), 0xFFFFFF);
        this.drawFavorText(matrixStack, mouseX, mouseY);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (Widget b : this.field_230710_m_) {
            if (!b.field_230694_p_ || !b.func_230449_g_()) continue;
            b.func_230443_a_(matrixStack, mouseX, mouseY);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        double multiplier = 1.0;
        if (this.mode == Mode.ITEM) {
            multiplier = 1.0f / (float)(this.itemButtons.get(this.selected).size() / 2);
        } else if (this.mode == Mode.ENTITY) {
            multiplier = 1.0f / (float)this.entityButtons.get(this.selected).size();
        } else if (this.mode == Mode.BLESSING) {
            multiplier = 1.0f / (float)this.blessingButtons.get(this.selected).size();
        } else if (this.mode == Mode.HOSTILE) {
            multiplier = 1.0f / (float)this.hostileButtons.get(this.selected).size();
        }
        return this.scrollButton.func_231043_a_(mouseX, mouseY, scrollAmount * multiplier);
    }

    private void drawFavorText(MatrixStack matrixStack, int mouseX, int mouseY) {
        FavorLevel level = this.favor.getFavor(this.deityList.get(this.selected));
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("favor.favor").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}), (float)(this.guiLeft + 9), (float)(this.guiTop + 16), 0xFFFFFF);
        long curFavor = level.getFavor();
        long nextFavor = level.getFavorToNextLevel();
        IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(String.valueOf(curFavor + " / " + nextFavor)).func_240699_a_(TextFormatting.DARK_PURPLE);
        float f = this.guiLeft + 9;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent, f, (float)(this.guiTop + 16 + 9 * 1 + 1), 0xFFFFFF);
        IFormattableTextComponent iFormattableTextComponent2 = new TranslationTextComponent("favor.level").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC});
        float f2 = this.guiLeft + 9;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent2, f2, (float)(this.guiTop + 16 + 9 * 5 / 2), 0xFFFFFF);
        IFormattableTextComponent iFormattableTextComponent3 = new StringTextComponent(String.valueOf(level.getLevel() + " / " + (curFavor < 0L ? level.getMinLevel() : level.getMaxLevel()))).func_240699_a_(TextFormatting.DARK_PURPLE);
        float f3 = this.guiLeft + 9;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent3, f3, (float)(this.guiTop + 16 + 9 * 7 / 2 + 1), 0xFFFFFF);
        IFormattableTextComponent iFormattableTextComponent4 = new TranslationTextComponent("favor.next_level").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC});
        float f4 = this.guiLeft + 9;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent4, f4, (float)(this.guiTop + 16 + 9 * 5), 0xFFFFFF);
        boolean capped = level.getLevel() == level.getMinLevel() || level.getLevel() == level.getMaxLevel();
        IFormattableTextComponent iFormattableTextComponent5 = new StringTextComponent(capped ? "--" : String.valueOf(nextFavor - curFavor)).func_240699_a_(TextFormatting.DARK_PURPLE);
        float f5 = this.guiLeft + 9;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent5, f5, (float)(this.guiTop + 16 + 9 * 6 + 1), 0xFFFFFF);
    }

    private void setSelectedTab(int index) {
        this.tabGroup = index;
        for (int i = 0; i < 7; ++i) {
            if (this.tabButtons[i] == null) continue;
            this.tabButtons[i].updateDeity(i + this.tabGroup * 7);
        }
    }

    private void setSelectedDeity(int index) {
        this.selected = index;
        this.updateMode(this.mode);
    }

    protected void updateMode(Mode modeIn) {
        boolean buttonsVisible;
        int i;
        this.mode = modeIn;
        if (modeIn == Mode.ITEM) {
            this.scrollEnabled = this.itemButtons.get(this.selected).size() > 14;
        } else if (modeIn == Mode.ENTITY) {
            this.scrollEnabled = this.entityButtons.get(this.selected).size() > 13;
        } else if (modeIn == Mode.BLESSING) {
            this.scrollEnabled = this.blessingButtons.get(this.selected).size() > 6;
        } else if (modeIn == Mode.HOSTILE) {
            this.scrollEnabled = this.hostileButtons.get(this.selected).size() > 6;
        }
        int l = this.itemButtons.size();
        for (i = 0; i < l; ++i) {
            buttonsVisible = i == this.selected && modeIn == Mode.ITEM;
            this.itemButtons.get(i).forEach(b -> {
                b.field_230694_p_ = buttonsVisible;
            });
        }
        l = this.entityButtons.size();
        for (i = 0; i < l; ++i) {
            buttonsVisible = i == this.selected && modeIn == Mode.ENTITY;
            this.entityButtons.get(i).forEach(b -> {
                b.field_230694_p_ = buttonsVisible;
            });
        }
        l = this.blessingButtons.size();
        for (i = 0; i < l; ++i) {
            buttonsVisible = i == this.selected && modeIn == Mode.BLESSING;
            this.blessingButtons.get(i).forEach(b -> {
                b.field_230694_p_ = buttonsVisible;
            });
        }
        l = this.hostileButtons.size();
        for (i = 0; i < l; ++i) {
            buttonsVisible = i == this.selected && modeIn == Mode.HOSTILE;
            this.hostileButtons.get(i).forEach(b -> {
                b.field_230694_p_ = buttonsVisible;
            });
        }
        this.scrollButton.resetScroll();
    }

    protected void updateScroll(float amount) {
        if (this.mode == Mode.ITEM) {
            int startIndex = Math.round(amount * (float)(this.itemButtons.get(this.selected).size() / 2 - 7 + 1));
            this.itemButtons.get(this.selected).forEach(b -> b.updateLocation(startIndex));
        } else if (this.mode == Mode.ENTITY) {
            int startIndex = Math.round(amount * (float)(this.entityButtons.get(this.selected).size() - 13));
            this.entityButtons.get(this.selected).forEach(b -> b.updateLocation(startIndex));
        } else if (this.mode == Mode.BLESSING) {
            int startIndex = Math.round(amount * (float)(this.blessingButtons.get(this.selected).size() - 6));
            this.blessingButtons.get(this.selected).forEach(b -> b.updateLocation(startIndex));
        } else if (this.mode == Mode.HOSTILE) {
            int startIndex = Math.round(amount * (float)(this.hostileButtons.get(this.selected).size() - 6));
            this.hostileButtons.get(this.selected).forEach(b -> b.updateLocation(startIndex));
        }
    }

    protected static enum Mode {
        ITEM("favor.favor_modifiers"),
        ENTITY("favor.favor_modifiers"),
        BLESSING("gui.mirror.blessing_levels"),
        HOSTILE("gui.mirror.hostility_levels");

        private String tooltip;

        private Mode(String tooltipIn) {
            this.tooltip = tooltipIn;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    protected class ModeButton
    extends Button {
        private final Mode screenMode;
        private final ITextComponent tooltip;

        public ModeButton(DeityScreen screenIn, int x, int y, String translationKey, Mode modeIn) {
            super(x, y, 70, 16, (ITextComponent)new TranslationTextComponent(translationKey), b -> screenIn.updateMode(modeIn), (b, m, bx, by) -> screenIn.func_238652_a_(m, ((ModeButton)b).tooltip, bx, by));
            this.screenMode = modeIn;
            this.tooltip = new TranslationTextComponent(translationKey.concat(".tooltip"));
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean selected = this.isSelected();
                boolean xOffset = false;
                int yOffset = 160 + (selected ? this.field_230689_k_ : 0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                DeityScreen.this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 0, yOffset, this.field_230688_j_, this.field_230689_k_);
                ModeButton.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)DeityScreen.this.field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
            }
        }

        protected boolean isSelected() {
            return this.func_230449_g_() || DeityScreen.this.mode == this.screenMode;
        }
    }

    protected class TabArrowButton
    extends Button {
        private final boolean isLeft;

        public TabArrowButton(DeityScreen gui, boolean left, int x, int y) {
            super(x, y, 14, 18, StringTextComponent.field_240750_d_, b -> gui.setSelectedTab(left ? Math.max(0, gui.tabGroup - 1) : Math.min(gui.deityList.size() / 7, gui.tabGroup + 1)));
            this.isLeft = left;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_ && DeityScreen.this.deityList.size() > 7) {
                int xOffset = this.isLeft ? 14 : 0;
                int yOffset = 128 + (this.field_230692_n_ ? 18 : 0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                DeityScreen.this.getMinecraft().func_110434_K().func_110577_a(TABS_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, xOffset, yOffset, this.field_230688_j_, this.field_230689_k_);
            }
        }
    }

    protected class TabButton
    extends Button {
        private int id;
        private ItemStack item;

        public TabButton(DeityScreen gui, int index, ITextComponent title, int x, int y) {
            super(x, y, 28, 32, title, b -> gui.setSelectedDeity(((TabButton)b).id), (b, m, bx, by) -> gui.func_238652_a_(m, b.func_230458_i_(), bx, by));
            this.item = ItemStack.field_190927_a;
            this.updateDeity(index);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                int selected = this.isSelected() ? 0 : 2;
                int xOffset = this.id % 7 * 28;
                int yOffset = this.isSelected() ? this.field_230689_k_ : 2;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                DeityScreen.this.getMinecraft().func_110434_K().func_110577_a(TABS_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_ - selected, xOffset, yOffset - selected, this.field_230688_j_, this.field_230689_k_ - selected);
                DeityScreen.this.field_230707_j_.func_175042_a(this.item, this.field_230690_l_ + (this.field_230688_j_ - 16) / 2, this.field_230691_m_ + (this.field_230689_k_ - 16) / 2);
            }
        }

        public void updateDeity(int deityId) {
            this.id = deityId;
            if (this.id < DeityScreen.this.deityList.size()) {
                this.field_230694_p_ = true;
                this.func_238482_a_((ITextComponent)((IDeity)DeityScreen.this.deityList.get(this.id)).getText());
                ResourceLocation rl = ((IDeity)DeityScreen.this.deityList.get(deityId)).getName();
                ResourceLocation altar = new ResourceLocation(rl.func_110624_b(), "altar_" + rl.func_110623_a());
                this.item = new ItemStack((IItemProvider)(ForgeRegistries.ITEMS.containsKey(altar) ? (IItemProvider)ForgeRegistries.ITEMS.getValue(altar) : GFRegistry.PANFLUTE));
            } else {
                this.field_230694_p_ = false;
            }
        }

        public boolean isSelected() {
            return DeityScreen.this.selected == this.id;
        }
    }

    protected class BlessingButton
    extends Button
    implements Comparable<BlessingButton> {
        private final int minValue;
        private final int maxValue;
        private int index;
        private final ITextComponent textHeader;
        private final ITextComponent textRange;

        public BlessingButton(DeityScreen gui, SpecialFavorEffect.Type typeIn, int minLevel, int maxLevel, int x, int y) {
            super(x, y, 81, 18, StringTextComponent.field_240750_d_, b -> {});
            this.minValue = minLevel;
            this.maxValue = maxLevel;
            this.textHeader = new TranslationTextComponent(typeIn.getTranslationKey()).func_240699_a_(TextFormatting.BLACK).func_230529_a_((ITextComponent)new StringTextComponent(":").func_240699_a_(TextFormatting.BLACK));
            TextFormatting color = maxLevel > 0 ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED;
            this.textRange = new TranslationTextComponent("favor.level_range", new Object[]{minLevel, maxLevel}).func_240699_a_(color);
        }

        public BlessingButton(DeityScreen gui, FavorEffect effectIn, int minLevel, int maxLevel, int x, int y) {
            super(x, y, 81, 18, StringTextComponent.field_240750_d_, b -> {});
            this.minValue = minLevel;
            this.maxValue = maxLevel;
            this.textHeader = new TranslationTextComponent(effectIn.getTranslationKey()).func_240699_a_(TextFormatting.BLACK).func_230529_a_((ITextComponent)new StringTextComponent(":").func_240699_a_(TextFormatting.BLACK));
            TextFormatting color = maxLevel > 0 ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED;
            this.textRange = new TranslationTextComponent("favor.level_range", new Object[]{minLevel, maxLevel}).func_240699_a_(color);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                DeityScreen.this.field_230712_o_.func_243248_b(matrixStack, this.textHeader, (float)this.field_230690_l_, (float)this.field_230691_m_, 0xFFFFFF);
                FontRenderer fontRenderer = DeityScreen.this.field_230712_o_;
                float f = this.field_230690_l_ + 9;
                DeityScreen.this.field_230712_o_.getClass();
                fontRenderer.func_243248_b(matrixStack, this.textRange, f, (float)(this.field_230691_m_ + 9), 0xFFFFFF);
            }
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void updateLocation(int startIndex) {
            if (this.index < startIndex || this.index >= startIndex + 6) {
                this.field_230694_p_ = false;
                this.field_230692_n_ = false;
            } else {
                this.field_230694_p_ = true;
                int n = DeityScreen.this.guiTop + 32;
                DeityScreen.this.field_230712_o_.getClass();
                this.field_230691_m_ = n + 2 * 9 * (this.index - startIndex);
                this.field_230690_l_ = DeityScreen.this.guiLeft + 80;
            }
        }

        @Override
        public int compareTo(BlessingButton button) {
            return button.minValue - this.minValue;
        }
    }

    protected class HostileButton
    extends Button
    implements Comparable<HostileButton> {
        private final IDeity deity;
        private final int minValue;
        private final int maxValue;
        private int index;
        private final ITextComponent entityName;
        private final ITextComponent entityValue;

        public HostileButton(DeityScreen gui, EntityType<?> entityIn, IDeity deityIn, int minLevel, int maxLevel, int x, int y) {
            super(x, y, 81, 18, StringTextComponent.field_240750_d_, b -> {});
            this.deity = deityIn;
            this.minValue = minLevel;
            this.maxValue = maxLevel;
            this.entityName = new TranslationTextComponent(entityIn.func_210760_d()).func_240699_a_(TextFormatting.BLACK).func_230529_a_((ITextComponent)new StringTextComponent(":").func_240699_a_(TextFormatting.BLACK));
            this.entityValue = new TranslationTextComponent("favor.level_range", new Object[]{minLevel, maxLevel}).func_240699_a_(TextFormatting.DARK_RED);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                DeityScreen.this.field_230712_o_.func_243248_b(matrixStack, this.entityName, (float)this.field_230690_l_, (float)this.field_230691_m_, 0xFFFFFF);
                FontRenderer fontRenderer = DeityScreen.this.field_230712_o_;
                float f = this.field_230690_l_ + 9;
                DeityScreen.this.field_230712_o_.getClass();
                fontRenderer.func_243248_b(matrixStack, this.entityValue, f, (float)(this.field_230691_m_ + 9), 0xFFFFFF);
            }
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void updateLocation(int startIndex) {
            if (this.index < startIndex || this.index >= startIndex + 6) {
                this.field_230694_p_ = false;
                this.field_230692_n_ = false;
            } else {
                this.field_230694_p_ = true;
                int n = DeityScreen.this.guiTop + 32;
                DeityScreen.this.field_230712_o_.getClass();
                this.field_230691_m_ = n + 2 * 9 * (this.index - startIndex);
                this.field_230690_l_ = DeityScreen.this.guiLeft + 89;
            }
        }

        @Override
        public int compareTo(HostileButton button) {
            return button.minValue - this.minValue;
        }
    }

    protected class EntityButton
    extends Button
    implements Comparable<EntityButton> {
        private final int value;
        private int index;
        private int rightAlign;

        public EntityButton(DeityScreen gui, EntityType<?> entityIn, int entityValue, int x, int y) {
            super(x, y, 90, 9, StringTextComponent.field_240750_d_, b -> {});
            this.rightAlign = -1;
            this.value = entityValue;
            TextFormatting color = entityValue < 0 ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN;
            this.func_238482_a_((ITextComponent)new TranslationTextComponent(entityIn.func_210760_d()).func_240699_a_(TextFormatting.BLACK).func_230529_a_((ITextComponent)new StringTextComponent(":").func_240699_a_(TextFormatting.BLACK)).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%4s", (entityValue < 0 ? "" : "+") + entityValue)).func_240699_a_(color)));
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                DeityScreen.this.field_230712_o_.func_243248_b(matrixStack, this.func_230458_i_(), (float)this.field_230690_l_, (float)this.field_230691_m_, 0xFFFFFF);
            }
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void updateLocation(int startIndex) {
            if (this.index < startIndex || this.index >= startIndex + 13) {
                this.field_230694_p_ = false;
                this.field_230692_n_ = false;
            } else {
                this.field_230694_p_ = true;
                int n = DeityScreen.this.guiTop + 32;
                DeityScreen.this.field_230712_o_.getClass();
                this.field_230691_m_ = n + 9 * (this.index - startIndex);
                if (this.rightAlign < 0) {
                    this.rightAlign = 90 - DeityScreen.this.field_230712_o_.func_78256_a(this.func_230458_i_().getString());
                }
                this.field_230690_l_ = DeityScreen.this.guiLeft + 80 + this.rightAlign;
            }
        }

        @Override
        public int compareTo(EntityButton button) {
            return button.value - this.value;
        }
    }

    protected class ItemButton
    extends Button
    implements Comparable<ItemButton> {
        private final ItemStack item;
        private final int value;
        private int index;
        private ITextComponent valueText;

        public ItemButton(DeityScreen gui, Item itemIn, int itemValue, int x, int y) {
            super(x, y, 48, 18, StringTextComponent.field_240750_d_, b -> {}, (b, m, bx, by) -> gui.func_238652_a_(m, b.func_230458_i_(), bx, by));
            this.valueText = StringTextComponent.field_240750_d_;
            this.field_230694_p_ = false;
            this.field_230694_p_ = true;
            this.item = new ItemStack((IItemProvider)itemIn);
            this.value = itemValue;
            String itemValueString = (itemValue > 0 ? "+" : "") + itemValue;
            TextFormatting color = itemValue > 0 ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED;
            this.valueText = new StringTextComponent(itemValueString).func_240699_a_(color);
            this.func_238482_a_((ITextComponent)new TranslationTextComponent(this.item.func_77977_a()).func_230529_a_((ITextComponent)new StringTextComponent(" " + itemValueString).func_240699_a_(color)));
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                DeityScreen.this.field_230707_j_.func_175042_a(this.item, this.field_230690_l_ + 1, this.field_230691_m_ + 1);
                FontRenderer fontRenderer = DeityScreen.this.field_230712_o_;
                float f = this.field_230690_l_ + 20;
                DeityScreen.this.field_230712_o_.getClass();
                fontRenderer.func_243248_b(matrixStack, this.valueText, f, (float)(this.field_230691_m_ + (1 + 9) / 2), 0xFFFFFF);
            }
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void updateLocation(int startIndex) {
            int iIndex = this.index / 2;
            int sIndex = startIndex / 2 * 2;
            if (iIndex < sIndex || iIndex >= sIndex + 7) {
                this.field_230694_p_ = false;
                this.field_230692_n_ = false;
            } else {
                this.field_230694_p_ = true;
                this.field_230690_l_ = DeityScreen.this.guiLeft + 80 + this.index % 2 * 48;
                this.field_230691_m_ = DeityScreen.this.guiTop + 25 + 18 * (iIndex - sIndex);
            }
        }

        @Override
        public int compareTo(ItemButton button) {
            return button.value - this.value;
        }
    }
}

