/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;

public class ScrollButton<T extends Screen>
extends Button {
    private final Consumer<ScrollButton<T>> scrollEndHandler;
    private float scrollAmount;
    private int scrollTicks;
    private final int updateInterval;
    private final Predicate<T> enabled;
    private final T screen;
    private final ResourceLocation texture;
    private final int u;
    private final int v;
    private final int uWidth = 12;
    private final int vHeight = 16;

    public ScrollButton(T gui, int x, int y, int width, int height, int uX, int vY, ResourceLocation textureIn, Predicate<T> isEnabled, int updateIntervalIn, Consumer<ScrollButton<T>> onScrollEnd) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, b -> {});
        this.screen = gui;
        this.u = uX;
        this.v = vY;
        this.texture = textureIn;
        this.enabled = isEnabled;
        this.updateInterval = updateIntervalIn;
        this.scrollEndHandler = onScrollEnd.andThen(t -> t.resetTick());
        this.scrollAmount = 0.0f;
        this.scrollEndHandler.accept(this);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.screen.getMinecraft().func_110434_K().func_110577_a(this.texture);
            boolean isEnabled = this.enabled.test(this.screen);
            float scroll = isEnabled ? this.scrollAmount : 0.0f;
            int uOffset = isEnabled ? 0 : 12;
            int yOffset = MathHelper.func_76125_a((int)((int)(scroll * (float)this.field_230689_k_ - (float)(this.vHeight / 2))), (int)0, (int)(this.field_230689_k_ - 16 + 1));
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 1, this.field_230691_m_ + yOffset, this.u + uOffset, this.v, 12, 16);
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.enabled.test(this.screen)) {
            this.updateScrollAmount(mouseX, mouseY);
            this.scrollEndHandler.accept(this);
        }
    }

    public void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.enabled.test(this.screen)) {
            this.updateScrollAmount(mouseX, mouseY);
        }
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        if (this.enabled.test(this.screen)) {
            this.updateScrollAmount(mouseX, mouseY);
            this.scrollEndHandler.accept(this);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.enabled.test(this.screen)) {
            this.scrollAmount = MathHelper.func_76131_a((float)((float)((double)this.scrollAmount - delta)), (float)0.0f, (float)1.0f);
            this.scrollEndHandler.accept(this);
            return true;
        }
        return false;
    }

    private void updateScrollAmount(double mouseX, double mouseY) {
        this.scrollAmount = MathHelper.func_76131_a((float)((float)(mouseY - (double)this.field_230691_m_) / (float)this.field_230689_k_), (float)0.0f, (float)1.0f);
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void resetScroll() {
        this.scrollAmount = 0.0f;
        this.scrollEndHandler.accept(this);
    }

    public void tick() {
    }

    public void resetTick() {
        this.scrollTicks = 0;
    }
}

