/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.GreekFantasy;
import greekfantasy.client.gui.ScrollButton;
import greekfantasy.item.InstrumentItem;
import greekfantasy.item.PanfluteItem;
import greekfantasy.network.CUpdateInstrumentPacket;
import greekfantasy.util.Song;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SongScreen
extends Screen {
    private static final ResourceLocation SCREEN_TEXTURE = new ResourceLocation("greekfantasy", "textures/gui/song_selection.png");
    private static final int SCREEN_WIDTH = 154;
    private static final int SCREEN_HEIGHT = 150;
    private static final int BTN_LEFT = 8;
    private static final int BTN_TOP = 22;
    private static final int BTN_WIDTH = 120;
    private static final int BTN_HEIGHT = 24;
    private static final int BTN_VISIBLE = 5;
    private static final int SCROLL_LEFT = 133;
    private static final int SCROLL_TOP = 22;
    private static final int SCROLL_WIDTH = 14;
    private static final int SCROLL_HEIGHT = 120;
    private final List<Map.Entry<ResourceLocation, Optional<Song>>> songs = new ArrayList<Map.Entry<ResourceLocation, Optional<Song>>>();
    private final List<SongButton> songButtons = new ArrayList<SongButton>();
    private final int itemSlot;
    private final ItemStack instrumentStack;
    private final InstrumentItem instrumentItem;
    private ResourceLocation selectedSong = PanfluteItem.DEFAULT_SONG;
    private ScrollButton<SongScreen> scrollButton;
    private int guiLeft;
    private int guiTop;
    private boolean scrollEnabled;

    public SongScreen(int itemSlotIn, ItemStack panfluteItemIn) {
        super((ITextComponent)new TranslationTextComponent("gui.songs.title"));
        this.itemSlot = itemSlotIn;
        this.instrumentStack = panfluteItemIn;
        if (this.instrumentStack.func_77973_b() instanceof InstrumentItem) {
            this.instrumentItem = (InstrumentItem)this.instrumentStack.func_77973_b();
        } else {
            this.instrumentItem = null;
            this.func_231175_as__();
        }
        if (this.songs.isEmpty()) {
            this.songs.addAll(GreekFantasy.PROXY.PANFLUTE_SONGS.getEntries());
            this.songs.sort((e1, e2) -> ((Optional)e1.getValue()).orElse(Song.EMPTY).getName().getString().compareTo(((Optional)e2.getValue()).orElse(Song.EMPTY).getName().getString()));
        }
        this.selectedSong = InstrumentItem.readSong(this.instrumentStack);
        this.scrollEnabled = this.songs.size() > 5;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.guiLeft = (this.field_230708_k_ - 154) / 2;
        this.guiTop = (this.field_230709_l_ - 150) / 2 - 10;
        this.func_230480_a_((Widget)new Button(this.guiLeft, this.guiTop + 150 + 4, 154, 20, (ITextComponent)new TranslationTextComponent("gui.done"), c -> this.field_230706_i_.func_147108_a(null)));
        this.scrollButton = (ScrollButton)this.func_230480_a_((Widget)new ScrollButton<SongScreen>(this, this.guiLeft + 133, this.guiTop + 22, 14, 120, 0, 198, SCREEN_TEXTURE, s -> s.scrollEnabled, 4, b -> this.updateScroll(b.getScrollAmount())));
        int i = 0;
        for (Map.Entry<ResourceLocation, Optional<Song>> e : this.songs) {
            SongButton b2 = (SongButton)this.func_230480_a_((Widget)new SongButton(i, this, e.getValue().orElse(Song.EMPTY), e.getKey(), this.guiLeft + 8, 0));
            b2.updateLocation(0);
            this.songButtons.add(b2);
            ++i;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, 154, 150);
        SongScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 8), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.scrollButton != null) {
            this.scrollButton.tick();
        }
    }

    public void func_231164_f_() {
        if (this.instrumentItem instanceof InstrumentItem) {
            GreekFantasy.CHANNEL.sendToServer((Object)new CUpdateInstrumentPacket(this.itemSlot, this.selectedSong));
        }
        super.func_231164_f_();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        double multiplier = 1.0f / (float)this.songButtons.size();
        return this.scrollButton.func_231043_a_(mouseX, mouseY, scrollAmount * multiplier);
    }

    protected void updateScroll(float amount) {
        int startIndex = Math.round(amount * (float)(this.songButtons.size() - 5));
        this.songButtons.forEach(b -> b.updateLocation(startIndex));
    }

    protected class SongButton
    extends Button {
        private final int index;
        private final Song song;
        private final ResourceLocation songID;

        public SongButton(int indexIn, SongScreen gui, Song songIn, ResourceLocation songInID, int x, int y) {
            super(x, y, 120, 24, StringTextComponent.field_240750_d_, b -> gui.selectedSong = songInID);
            this.index = indexIn;
            this.song = songIn;
            this.songID = songInID;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean selected = this.isSelected();
                boolean xOffset = false;
                int yOffset = 150 + (selected ? this.field_230689_k_ : 0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                SongScreen.this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 0, yOffset, this.field_230688_j_, this.field_230689_k_);
                IFormattableTextComponent name = this.song.getName().func_230532_e_();
                IFormattableTextComponent credits = this.song.getCredits().func_230532_e_();
                if (selected) {
                    name.func_240699_a_(TextFormatting.GRAY);
                    credits.func_240699_a_(TextFormatting.GRAY);
                }
                this.drawStringToFit(matrixStack, (ITextComponent)name, this.field_230690_l_ + 3, this.field_230691_m_ + 4, this.field_230688_j_ - 6);
                SongScreen.this.field_230712_o_.getClass();
                this.drawStringToFit(matrixStack, (ITextComponent)credits, this.field_230690_l_ + 3, this.field_230691_m_ + 9 + 5, this.field_230688_j_ - 6);
            }
        }

        protected void drawStringToFit(MatrixStack matrixStack, ITextComponent text, int x, int y, int maxWidth) {
            float scale = 1.0f;
            while (true) {
                int n = SongScreen.this.field_230712_o_.func_78267_b(text.getString(), (int)((float)maxWidth / scale));
                SongScreen.this.field_230712_o_.getClass();
                if (n <= 9 || !(scale > 0.25f)) break;
                scale -= 0.05f;
            }
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            SongScreen.this.field_230712_o_.func_243248_b(matrixStack, text, (float)x / scale, (float)y / scale, 0);
            RenderSystem.popMatrix();
        }

        protected boolean isSelected() {
            return this.func_230449_g_() || this.songID.equals((Object)SongScreen.this.selectedSong);
        }

        public void updateLocation(int startIndex) {
            this.field_230691_m_ = SongScreen.this.guiTop + 22 + 24 * (this.index - startIndex);
            if (this.index < startIndex || this.index >= startIndex + 5) {
                this.field_230694_p_ = false;
                this.field_230692_n_ = false;
            } else {
                this.field_230694_p_ = true;
            }
        }
    }
}

