/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.GreekFantasy;
import greekfantasy.block.StatueBlock;
import greekfantasy.gui.StatueContainer;
import greekfantasy.network.CUpdateStatuePosePacket;
import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.ModelPart;
import greekfantasy.util.StatuePose;
import greekfantasy.util.StatuePoses;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StatueScreen
extends ContainerScreen<StatueContainer> {
    private static final ResourceLocation SCREEN_TEXTURE = new ResourceLocation("greekfantasy", "textures/gui/statue.png");
    private static final int SCREEN_WIDTH = 224;
    private static final int SCREEN_HEIGHT = 202;
    private static final int PREVIEW_WIDTH = 52;
    private static final int PREVIEW_HEIGHT = 86;
    private static final int PREVIEW_X = 8;
    private static final int PREVIEW_Y = 8;
    private static final int PARTS_X = 147;
    private static final int PARTS_Y = 7;
    private static final int GENDER_X = 26;
    private static final int GENDER_Y = 90;
    private static final int PRESET_X = 69;
    private static final int PRESET_Y = 87;
    private static final int RESET_X = 123;
    private static final int RESET_Y = 87;
    private static final int SLIDER_X = 69;
    private static final int SLIDER_Y = 14;
    private static final int SLIDER_HEIGHT = 20;
    private static final int SLIDER_SPACING = 4;
    private static final int BTN_WIDTH = 70;
    private static final int BTN_HEIGHT = 16;
    protected BlockPos blockPos = BlockPos.field_177992_a;
    protected Direction blockRotation = Direction.NORTH;
    protected StatuePose currentPose = StatuePoses.NONE;
    protected ModelPart selectedPart = ModelPart.BODY;
    protected boolean isStatueFemale = false;
    protected String textureName = "";
    protected AngleSlider sliderAngleX;
    protected AngleSlider sliderAngleY;
    protected AngleSlider sliderAngleZ;

    public StatueScreen(StatueContainer screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.field_146999_f = 224;
        this.field_147000_g = 202;
        this.field_238744_r_ = this.field_147003_i + 32;
        this.field_238745_s_ = this.field_147009_r + 120 - 10;
        this.currentPose = screenContainer.getStatuePose();
        this.blockPos = screenContainer.getBlockPos();
        this.blockRotation = screenContainer.getBlockRotation();
        this.isStatueFemale = screenContainer.isStatueFemale();
        this.textureName = screenContainer.getProfile();
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        int l = ModelPart.values().length;
        for (int i = 0; i < l; ++i) {
            final ModelPart p = ModelPart.values()[i];
            TranslationTextComponent title = new TranslationTextComponent("gui.statue." + p.func_176610_l());
            this.func_230480_a_((Widget)new PartButton(this, this.field_147003_i + 147, this.field_147009_r + 7 + 16 * i, (ITextComponent)title, button -> {
                this.selectedPart = p;
                this.updateSliders();
            }){

                @Override
                protected boolean isSelected() {
                    return this.func_230449_g_() || p == StatueScreen.this.selectedPart;
                }
            });
        }
        TranslationTextComponent titleReset = new TranslationTextComponent("controls.reset");
        this.func_230480_a_((Widget)new IconButton(this, this.field_147003_i + 123, this.field_147009_r + 87, 0, 234, (ITextComponent)titleReset, button -> {
            this.currentPose.set(this.selectedPart, 0.0f, 0.0f, 0.0f);
            this.updateSliders();
        }));
        TranslationTextComponent titleGender = new TranslationTextComponent("gui.statue.gender");
        this.func_230480_a_((Widget)new IconButton(this, this.field_147003_i + 26, this.field_147009_r + 90, 16, 234, (ITextComponent)titleGender, button -> {
            this.isStatueFemale = !this.isStatueFemale;
        }){

            @Override
            public int getIconX() {
                return super.getIconX() + (StatueScreen.this.isStatueFemale ? 0 : this.field_230688_j_);
            }
        });
        TranslationTextComponent titlePreset = new TranslationTextComponent("gui.statue.preset");
        this.func_230480_a_((Widget)new IconButton(this, this.field_147003_i + 69, this.field_147009_r + 87, 48, 234, (ITextComponent)titlePreset, button -> {
            this.currentPose = StatuePoses.getRandomPose(this.field_230706_i_.field_71441_e.field_73012_v);
            this.updateSliders();
        }));
        this.sliderAngleX = new AngleSlider(this.field_147003_i + 69, this.field_147009_r + 14, "X"){

            @Override
            void setAngleValue(double angRadians) {
                StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).setX((float)angRadians);
            }

            @Override
            double getAngleValue() {
                return Math.toDegrees(StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).func_195899_a());
            }
        };
        this.sliderAngleY = new AngleSlider(this.field_147003_i + 69, this.field_147009_r + 14 + 24, "Y"){

            @Override
            void setAngleValue(double angRadians) {
                StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).setY((float)angRadians);
            }

            @Override
            double getAngleValue() {
                return Math.toDegrees(StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).func_195900_b());
            }
        };
        this.sliderAngleZ = new AngleSlider(this.field_147003_i + 69, this.field_147009_r + 14 + 48, "Z"){

            @Override
            void setAngleValue(double angRadians) {
                StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).setZ((float)angRadians);
            }

            @Override
            double getAngleValue() {
                return Math.toDegrees(StatueScreen.this.currentPose.getAngles(StatueScreen.this.selectedPart).func_195902_c());
            }
        };
        this.func_230480_a_((Widget)this.sliderAngleX);
        this.func_230480_a_((Widget)this.sliderAngleY);
        this.func_230480_a_((Widget)this.sliderAngleZ);
        this.updateSliders();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderHelper.func_227783_c_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SCREEN_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawTileEntityOnScreen(matrixStack, this.field_147003_i + 8, this.field_147009_r + 8, mouseX, mouseY, partialTicks);
        for (Widget b : this.field_230710_m_) {
            if (!b.field_230694_p_ || !b.func_230449_g_()) continue;
            b.func_230443_a_(matrixStack, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        GreekFantasy.CHANNEL.sendToServer((Object)new CUpdateStatuePosePacket(this.blockPos, this.currentPose, this.isStatueFemale, this.textureName));
    }

    protected void updateSliders() {
        if (this.sliderAngleX != null) {
            this.sliderAngleX.updateSlider();
            this.sliderAngleY.updateSlider();
            this.sliderAngleZ.updateSlider();
        }
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
    }

    public void setStatuePose(StatuePose pose) {
        this.currentPose = pose;
        this.updateSliders();
    }

    public void drawTileEntityOnScreen(MatrixStack matrixStackIn, int posX, int posY, float mouseX, float mouseY, float partialTicks) {
        float margin = 12.0f;
        float scale = 52.0f - margin * 2.0f;
        float rotX = (float)Math.atan((mouseX - (float)this.field_147003_i) / 40.0f);
        float rotY = (float)Math.atan((mouseY - (float)this.field_147009_r - 43.0f) / 40.0f);
        TileEntity teMain = this.field_230706_i_.field_71441_e.func_175625_s(this.blockPos);
        boolean isUpper = teMain.func_195044_w().func_177229_b(StatueBlock.HALF) == DoubleBlockHalf.UPPER;
        TileEntity teOther = this.field_230706_i_.field_71441_e.func_175625_s(isUpper ? this.blockPos.func_177977_b() : this.blockPos.func_177984_a());
        if (teMain instanceof StatueTileEntity && teOther instanceof StatueTileEntity) {
            StatueTileEntity statueMain = (StatueTileEntity)teMain;
            StatueTileEntity statueOther = (StatueTileEntity)teOther;
            this.updateStatueTileEntity(statueMain);
            this.updateStatueTileEntity(statueOther);
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.translatef((float)((float)posX + margin), (float)((float)posY + margin), (float)110.0f);
            RenderSystem.translatef((float)0.0f, (float)(86.0f - margin * 1.75f), (float)0.0f);
            RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            RenderSystem.rotatef((float)(rotX * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.rotatef((float)(rotY * 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderHelper.func_227783_c_();
            IRenderTypeBuffer.Impl bufferType = this.field_230706_i_.func_228019_au_().func_228487_b_();
            TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)statueMain).func_225616_a_((TileEntity)statueMain, partialTicks, matrixStackIn, (IRenderTypeBuffer)bufferType, 0xF000F0, OverlayTexture.field_229196_a_);
            bufferType.func_228461_a_();
            RenderSystem.translatef((float)0.0f, (float)1.0f, (float)0.0f);
            TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)statueOther).func_225616_a_((TileEntity)statueOther, partialTicks, matrixStackIn, (IRenderTypeBuffer)bufferType, 0xF000F0, OverlayTexture.field_229196_a_);
            bufferType.func_228461_a_();
            RenderSystem.enableDepthTest();
            RenderHelper.func_227784_d_();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            RenderSystem.popMatrix();
        }
    }

    private void updateStatueTileEntity(StatueTileEntity te) {
        te.setStatuePose(this.currentPose);
        te.setStatueFemale(this.isStatueFemale);
        te.setTextureName(this.textureName);
    }

    protected abstract class AngleSlider
    extends AbstractSlider {
        private final String rotationName;

        public AngleSlider(int x, int y, String rName) {
            super(x, y, 70, 20, StringTextComponent.field_240750_d_, 0.5);
            this.rotationName = rName;
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.statue.rotation", new Object[]{this.rotationName, Math.round(this.getAngleValue())}));
        }

        protected void func_230972_a_() {
            this.setAngleValue(Math.toRadians((this.field_230683_b_ - 0.5) * this.getAngleBounds()));
        }

        protected double getValueRadians() {
            return Math.toRadians((this.field_230683_b_ - 0.5) * this.getAngleBounds());
        }

        public void updateSlider() {
            this.field_230683_b_ = MathHelper.func_151237_a((double)(this.getAngleValue() / this.getAngleBounds() + 0.5), (double)0.0, (double)1.0);
            this.func_230979_b_();
        }

        protected double getAngleBounds() {
            return 360.0;
        }

        abstract double getAngleValue();

        abstract void setAngleValue(double var1);
    }

    protected class IconButton
    extends Button {
        private final int textureX;
        private final int textureY;

        public IconButton(StatueScreen screenIn, int x, int y, int tX, int tY, ITextComponent title, Button.IPressable pressedAction) {
            super(x, y, 16, 16, StringTextComponent.field_240750_d_, pressedAction, (b, m, bx, by) -> screenIn.func_238654_b_(m, ((StatueScreen)screenIn).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)title, Math.max(screenIn.field_230708_k_ / 2 - 43, 170)), bx, by));
            this.textureX = tX;
            this.textureY = tY;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                int xOffset = 70;
                int yOffset = 202 + (this.func_230449_g_() ? this.field_230688_j_ : 0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                StatueScreen.this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, xOffset, yOffset, this.field_230688_j_, this.field_230689_k_);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, this.getIconX(), this.getIconY(), this.field_230688_j_, this.field_230689_k_);
            }
        }

        public int getIconX() {
            return this.textureX;
        }

        public int getIconY() {
            return this.textureY;
        }
    }

    protected class PartButton
    extends Button {
        public PartButton(StatueScreen screenIn, int x, int y, ITextComponent title, Button.IPressable pressedAction) {
            super(x, y, 70, 16, title, pressedAction);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean selected = this.isSelected();
                boolean xOffset = false;
                int yOffset = 202 + (selected ? this.field_230689_k_ : 0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                StatueScreen.this.getMinecraft().func_110434_K().func_110577_a(SCREEN_TEXTURE);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 0, yOffset, this.field_230688_j_, this.field_230689_k_);
                PartButton.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)StatueScreen.this.field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
            }
        }

        protected boolean isSelected() {
            return this.func_230449_g_();
        }
    }
}

