/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.GreekFantasy;
import greekfantasy.client.render.GorgonRenderer;
import greekfantasy.client.render.model.GorgonModel;
import greekfantasy.entity.GorgonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class GorgonParticle
extends Particle {
    private final GorgonModel<GorgonEntity> model;
    private final RenderType renderType;

    public GorgonParticle(ClientWorld worldIn, double posX, double posY, double posZ, double motX, double motY, double motZ) {
        super(worldIn, posX, posY, posZ, motX, motY, motZ);
        GreekFantasy.LOGGER.debug("Spawning gorgon particle at " + posX + ", " + posY + ", " + posZ);
        this.model = new GorgonModel(0.0f);
        this.renderType = RenderType.func_228644_e_((ResourceLocation)GorgonRenderer.GORGON_TEXTURE);
        this.field_70545_g = 0.0f;
        this.field_70546_d = 0;
        this.field_70547_e = 78;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTick) {
        float agePercent = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        float cosAge = MathHelper.func_76126_a((float)(agePercent * (float)Math.PI));
        float disZ = 0.65f * (cosAge - 0.5f);
        this.field_82339_as = 0.05f + 0.75f * agePercent;
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227863_a_(renderInfo.func_227995_f_());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227862_a_(-1.0f, 1.0f, -1.0f);
        matrixStack.func_227861_a_(0.0, 0.309999, 1.15 + (double)disZ);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(this.renderType);
        this.model.func_205072_a().func_228309_a_(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, this.field_82339_as);
        this.model.renderSnakeHair(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, (float)this.field_70546_d + partialTick, this.field_82339_as);
        renderTypeBuffer.func_228461_a_();
    }

    public boolean shouldCull() {
        return false;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GorgonParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

