/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render;

import greekfantasy.client.render.layer.CentaurHorseLayer;
import greekfantasy.client.render.layer.CentaurQuiverLayer;
import greekfantasy.client.render.model.CentaurModel;
import greekfantasy.entity.CentaurEntity;
import java.util.EnumMap;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.util.ResourceLocation;

public class CentaurRenderer<T extends CentaurEntity>
extends BipedRenderer<T, CentaurModel<T>> {
    public static final EnumMap<CoatColors, ResourceLocation> BODY_TEXTURE_MAP = new EnumMap(CoatColors.class);

    public CentaurRenderer(EntityRendererManager renderManagerIn) {
        this(renderManagerIn, new CentaurModel(0.0f));
    }

    public CentaurRenderer(EntityRendererManager renderManagerIn, CentaurModel<T> model) {
        super(renderManagerIn, model, 0.75f);
        this.func_177094_a(new CentaurHorseLayer(this));
        this.func_177094_a(new CentaurQuiverLayer(this));
    }

    public ResourceLocation getEntityTexture(T entity) {
        return BODY_TEXTURE_MAP.get(((CentaurEntity)((Object)entity)).getCoatColor());
    }

    static {
        BODY_TEXTURE_MAP.put(CoatColors.BLACK, new ResourceLocation("greekfantasy", "textures/entity/centaur/black.png"));
        BODY_TEXTURE_MAP.put(CoatColors.BROWN, new ResourceLocation("greekfantasy", "textures/entity/centaur/brown.png"));
        BODY_TEXTURE_MAP.put(CoatColors.CHESTNUT, new ResourceLocation("greekfantasy", "textures/entity/centaur/chestnut.png"));
        BODY_TEXTURE_MAP.put(CoatColors.CREAMY, new ResourceLocation("greekfantasy", "textures/entity/centaur/creamy.png"));
        BODY_TEXTURE_MAP.put(CoatColors.DARKBROWN, new ResourceLocation("greekfantasy", "textures/entity/centaur/darkbrown.png"));
        BODY_TEXTURE_MAP.put(CoatColors.GRAY, new ResourceLocation("greekfantasy", "textures/entity/centaur/gray.png"));
        BODY_TEXTURE_MAP.put(CoatColors.WHITE, new ResourceLocation("greekfantasy", "textures/entity/centaur/white.png"));
    }
}

