/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.client.render.model.GiantBoarModel;
import greekfantasy.entity.GiantBoarEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;

public class GiantBoarRenderer<T extends GiantBoarEntity>
extends MobRenderer<T, GiantBoarModel<T>> {
    private static final ResourceLocation HOGLIN_TEXTURE = new ResourceLocation("textures/entity/hoglin/hoglin.png");
    private static final ResourceLocation GIANT_BOAR_TEXTURE = new ResourceLocation("greekfantasy", "textures/entity/giant_boar.png");
    public static final float SCALE = 1.9f;
    protected boolean isAlphaLayer;

    public GiantBoarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new GiantBoarModel(), 1.0f);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entity.func_82150_aj()) {
            matrixStackIn.func_227860_a_();
            float spawnPercent = ((GiantBoarEntity)((Object)entity)).getSpawnPercent(partialTicks % 1.0f);
            float scale = 1.0f + 0.9f * spawnPercent;
            matrixStackIn.func_227862_a_(scale, scale, scale);
            ((GiantBoarModel)this.func_217764_d()).setColorAlpha(1.0f);
            super.func_225623_a_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            if (spawnPercent < 0.99f) {
                this.isAlphaLayer = true;
                matrixStackIn.func_227860_a_();
                RenderSystem.enableAlphaTest();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.enableBlend();
                ((GiantBoarModel)this.field_77045_g).setColorAlpha(1.0f - spawnPercent);
                super.func_225623_a_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                matrixStackIn.func_227865_b_();
                this.isAlphaLayer = false;
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected boolean func_230495_a_(T entity) {
        return ((GiantBoarEntity)((Object)entity)).func_234364_eK_();
    }

    protected void preRenderCallback(T entity, MatrixStack matrix, float ageInTicks) {
    }

    public ResourceLocation getEntityTexture(T entity) {
        return GIANT_BOAR_TEXTURE;
    }

    @Nullable
    protected RenderType func_230496_a_(T entity, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        return this.isAlphaLayer ? RenderType.func_230168_b_((ResourceLocation)HOGLIN_TEXTURE, (boolean)isGlowing) : super.func_230496_a_(entity, isVisible, isVisibleToPlayer, isGlowing);
    }
}

