/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import greekfantasy.client.render.layer.SatyrGroverLayer;
import greekfantasy.client.render.layer.SatyrPanfluteLayer;
import greekfantasy.client.render.layer.SatyrShamanLayer;
import greekfantasy.client.render.model.SatyrModel;
import greekfantasy.entity.SatyrEntity;
import java.util.EnumMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.util.ResourceLocation;

public class SatyrRenderer<T extends SatyrEntity>
extends BipedRenderer<T, SatyrModel<T>> {
    private static final ResourceLocation TEXTURE_GROVER = new ResourceLocation("greekfantasy", "textures/entity/satyr/grover.png");
    public static final EnumMap<CoatColors, ResourceLocation> BODY_TEXTURE_MAP = new EnumMap(CoatColors.class);

    public SatyrRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new SatyrModel(0.0f), 0.5f);
        this.func_177094_a(new SatyrShamanLayer(this));
        this.func_177094_a(new SatyrPanfluteLayer(this));
        this.func_177094_a(new SatyrGroverLayer(this));
    }

    public void render(T entityIn, float rotationYawIn, float partialTick, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_(entityIn, rotationYawIn, partialTick, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(T entity) {
        if (entity.func_145818_k_() && "Grover".equals(entity.func_200201_e().func_150261_e())) {
            return TEXTURE_GROVER;
        }
        return BODY_TEXTURE_MAP.get(((SatyrEntity)((Object)entity)).getCoatColor());
    }

    static {
        BODY_TEXTURE_MAP.put(CoatColors.BLACK, new ResourceLocation("greekfantasy", "textures/entity/satyr/black.png"));
        BODY_TEXTURE_MAP.put(CoatColors.BROWN, new ResourceLocation("greekfantasy", "textures/entity/satyr/brown.png"));
        BODY_TEXTURE_MAP.put(CoatColors.CHESTNUT, new ResourceLocation("greekfantasy", "textures/entity/satyr/chestnut.png"));
        BODY_TEXTURE_MAP.put(CoatColors.CREAMY, new ResourceLocation("greekfantasy", "textures/entity/satyr/creamy.png"));
        BODY_TEXTURE_MAP.put(CoatColors.DARKBROWN, new ResourceLocation("greekfantasy", "textures/entity/satyr/darkbrown.png"));
        BODY_TEXTURE_MAP.put(CoatColors.GRAY, new ResourceLocation("greekfantasy", "textures/entity/satyr/gray.png"));
        BODY_TEXTURE_MAP.put(CoatColors.WHITE, new ResourceLocation("greekfantasy", "textures/entity/satyr/white.png"));
    }
}

