/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.client.render.model.PegasusModel;
import greekfantasy.entity.PegasusEntity;
import java.util.EnumMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.util.ResourceLocation;

public class PegasusMarkingsLayer<T extends PegasusEntity>
extends LayerRenderer<T, PegasusModel<T>> {
    public static final EnumMap<CoatTypes, ResourceLocation> COAT_TEXTURES = new EnumMap(CoatTypes.class);

    public PegasusMarkingsLayer(IEntityRenderer<T, PegasusModel<T>> ientityrenderer) {
        super(ientityrenderer);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.getEntityTexture(entity);
        if (texture != null && !entity.func_82150_aj()) {
            IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
            ((PegasusModel)this.func_215332_c()).func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, LivingRenderer.func_229117_c_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getEntityTexture(T entity) {
        return COAT_TEXTURES.get(((PegasusEntity)((Object)entity)).getCoatType());
    }

    static {
        COAT_TEXTURES.put(CoatTypes.NONE, null);
        COAT_TEXTURES.put(CoatTypes.WHITE, new ResourceLocation("textures/entity/horse/horse_markings_white.png"));
        COAT_TEXTURES.put(CoatTypes.WHITE_FIELD, new ResourceLocation("textures/entity/horse/horse_markings_whitefield.png"));
        COAT_TEXTURES.put(CoatTypes.WHITE_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_whitedots.png"));
        COAT_TEXTURES.put(CoatTypes.BLACK_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_blackdots.png"));
    }
}

