/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.client.render.model.PegasusModel;
import greekfantasy.entity.PegasusEntity;
import java.util.EnumMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.util.ResourceLocation;

public class PegasusWingLayer<T extends PegasusEntity>
extends LayerRenderer<T, PegasusModel<T>> {
    public static final EnumMap<CoatColors, ResourceLocation> WING_TEXTURE_MAP = new EnumMap(CoatColors.class);

    public PegasusWingLayer(IEntityRenderer<T, PegasusModel<T>> ientityrenderer) {
        super(ientityrenderer);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.func_82150_aj()) {
            int packedOverlay = LivingRenderer.func_229117_c_(entity, (float)0.0f);
            IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entity)));
            matrixStackIn.func_227860_a_();
            if (entity.func_70631_g_()) {
                float scale = 0.5f;
                float childBodyOffsetY = 20.0f;
                matrixStackIn.func_227862_a_(scale, scale, scale);
                matrixStackIn.func_227861_a_(0.0, (double)(childBodyOffsetY / 16.0f), 0.0);
            }
            ((PegasusModel)this.func_215332_c()).renderWings(entity, matrixStackIn, vertexBuilder, packedLightIn, packedOverlay, limbSwing, limbSwingAmount, partialTick);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(T entity) {
        return WING_TEXTURE_MAP.get(((PegasusEntity)((Object)entity)).getCoatColor());
    }

    static {
        WING_TEXTURE_MAP.put(CoatColors.BLACK, new ResourceLocation("greekfantasy", "textures/entity/pegasus/black.png"));
        WING_TEXTURE_MAP.put(CoatColors.BROWN, new ResourceLocation("greekfantasy", "textures/entity/pegasus/brown.png"));
        WING_TEXTURE_MAP.put(CoatColors.CHESTNUT, new ResourceLocation("greekfantasy", "textures/entity/pegasus/chestnut.png"));
        WING_TEXTURE_MAP.put(CoatColors.CREAMY, new ResourceLocation("greekfantasy", "textures/entity/pegasus/creamy.png"));
        WING_TEXTURE_MAP.put(CoatColors.DARKBROWN, new ResourceLocation("greekfantasy", "textures/entity/pegasus/darkbrown.png"));
        WING_TEXTURE_MAP.put(CoatColors.GRAY, new ResourceLocation("greekfantasy", "textures/entity/pegasus/gray.png"));
        WING_TEXTURE_MAP.put(CoatColors.WHITE, new ResourceLocation("greekfantasy", "textures/entity/pegasus/white.png"));
    }
}

