/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.entity.CentaurEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class CentaurModel<T extends CentaurEntity>
extends BipedModel<T> {
    private final ModelRenderer horseBody;
    private final ModelRenderer leftBackLeg;
    private final ModelRenderer rightBackLeg;
    private final ModelRenderer leftFrontLeg;
    private final ModelRenderer rightFrontLeg;
    private final ModelRenderer tail;
    private final ModelRenderer quiver;
    private final ModelRenderer arrows;
    private final ModelRenderer arrow1;
    private final ModelRenderer arrow2;

    public CentaurModel(float modelSize) {
        super(modelSize);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.field_78115_e = new ModelRenderer((Model)this, 16, 16);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, -2.5f);
        this.field_78115_e.func_228301_a_(-4.0f, -9.0f, -10.0f, 8.0f, 12.0f, 4.0f, modelSize);
        this.field_78116_c = this.makeHeadModel(modelSize);
        this.field_178720_f = new ModelRenderer((Model)this, 32, 0);
        this.field_178720_f.func_78793_a(0.0f, -9.0f, -10.5f);
        this.field_178720_f.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize + 0.5f);
        this.field_178724_i = new ModelRenderer((Model)this, 32, 48);
        this.field_178724_i.func_78793_a(4.0f, -8.0f, -10.5f);
        this.field_178724_i.func_228301_a_(0.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178724_i.field_78809_i = true;
        this.field_178723_h = new ModelRenderer((Model)this, 40, 16);
        this.field_178723_h.func_78793_a(-4.0f, -8.0f, -10.5f);
        this.field_178723_h.func_228301_a_(-4.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178722_k.field_78806_j = false;
        this.field_178721_j.field_78806_j = false;
        this.horseBody = new ModelRenderer((Model)this, 0, 32);
        this.horseBody.func_228301_a_(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, 0.05f);
        this.horseBody.func_78793_a(0.0f, 0.0f, 5.0f);
        this.leftBackLeg = new ModelRenderer((Model)this, 48, 21);
        this.leftBackLeg.func_228301_a_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, modelSize);
        this.leftBackLeg.func_78793_a(4.0f, 14.0f, 7.0f);
        this.leftBackLeg.field_78809_i = true;
        this.rightBackLeg = new ModelRenderer((Model)this, 48, 21);
        this.rightBackLeg.func_228301_a_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, modelSize);
        this.rightBackLeg.func_78793_a(-4.0f, 14.0f, 7.0f);
        this.leftFrontLeg = new ModelRenderer((Model)this, 48, 21);
        this.leftFrontLeg.func_228301_a_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, modelSize);
        this.leftFrontLeg.func_78793_a(4.0f, 6.0f, -12.0f);
        this.leftFrontLeg.field_78809_i = true;
        this.rightFrontLeg = new ModelRenderer((Model)this, 48, 21);
        this.rightFrontLeg.func_228301_a_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, modelSize);
        this.rightFrontLeg.func_78793_a(-4.0f, 6.0f, -12.0f);
        this.tail = new ModelRenderer((Model)this, 42, 36);
        this.tail.func_228301_a_(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, modelSize);
        this.tail.func_78793_a(0.0f, -5.0f, 2.0f);
        this.tail.field_78795_f = 0.5235988f;
        this.horseBody.func_78792_a(this.tail);
        this.quiver = new ModelRenderer((Model)this);
        this.quiver.func_78793_a(0.0f, -4.0f, -6.5f);
        this.quiver.field_78808_h = 0.6109f;
        this.quiver.func_78784_a(48, 0).func_228301_a_(-2.0f, -5.0f, -2.0f, 4.0f, 10.0f, 4.0f, modelSize);
        this.arrows = new ModelRenderer((Model)this);
        this.arrows.func_78793_a(0.0f, 0.0f, 0.0f);
        this.quiver.func_78792_a(this.arrows);
        this.arrow1 = new ModelRenderer((Model)this);
        this.arrow1.func_78793_a(0.0f, -7.0f, 0.0f);
        this.arrow1.func_78784_a(28, 0).func_228301_a_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, modelSize);
        this.arrows.func_78792_a(this.arrow1);
        this.arrow2 = new ModelRenderer((Model)this);
        this.arrow2.func_78793_a(0.0f, -7.0f, 0.0f);
        this.arrow2.field_78796_g = -1.5708f;
        this.arrow2.func_78784_a(28, 0).func_228301_a_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, modelSize);
        this.arrows.func_78792_a(this.arrow2);
    }

    protected ModelRenderer makeHeadModel(float modelSize) {
        ModelRenderer head = new ModelRenderer((Model)this, 0, 0);
        head.func_78793_a(0.0f, -9.0f, -10.5f);
        head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize);
        return head;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.field_178724_i, (Object)this.field_178723_h, (Object)this.field_178720_f);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        ItemStack item = entity.func_184586_b(Hand.MAIN_HAND);
        if (item.func_77973_b() instanceof BowItem && entity.func_213398_dR()) {
            if (entity.func_184591_cq() == HandSide.RIGHT) {
                this.field_187076_m = BipedModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.field_187075_l = BipedModel.ArmPose.BOW_AND_ARROW;
            }
        } else {
            this.field_187076_m = this.field_187075_l = BipedModel.ArmPose.EMPTY;
        }
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch);
        this.horseBody.field_78797_d = 11.0f;
        float rearingTime = ((CentaurEntity)((Object)entity)).getRearingAmount(ageInTicks - (float)Math.floor(ageInTicks));
        float rearingTimeLeft = 1.0f - rearingTime;
        this.field_78115_e.func_78793_a(0.0f, -7.0f * rearingTime, 5.0f * rearingTime - 2.5f * rearingTimeLeft);
        this.field_78116_c.func_78793_a(0.0f, -16.0f * rearingTime - 9.0f * rearingTimeLeft, -3.0f * rearingTime - 10.5f * rearingTimeLeft);
        this.field_178720_f.func_78793_a(this.field_78116_c.field_78800_c, this.field_78116_c.field_78797_d, this.field_78116_c.field_78798_e);
        this.field_178724_i.func_78793_a(4.0f, -15.0f * rearingTime - 8.0f * rearingTimeLeft, -3.0f * rearingTime - 10.5f * rearingTimeLeft);
        this.field_178723_h.func_78793_a(-4.0f, this.field_178724_i.field_78797_d, this.field_178724_i.field_78798_e);
        this.quiver.func_78793_a(0.0f, -11.0f * rearingTime - 4.0f * rearingTimeLeft, 1.5f * rearingTime - 6.5f * rearingTimeLeft);
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)((CentaurEntity)((Object)entity)).field_70173_aa + partialTick;
        float swimmingOffset = entity.func_70090_H() ? 0.2f : 1.0f;
        float limbSwingCos = MathHelper.func_76134_b((float)(swimmingOffset * limbSwing * 0.6662f + (float)Math.PI));
        float limbSwingAmountCos = limbSwingCos * 0.8f * limbSwingAmount;
        float rearingTime = ((CentaurEntity)((Object)entity)).getRearingAmount(partialTick);
        float rearingTimeLeft = 1.0f - rearingTime;
        this.horseBody.field_78795_f = 0.0f;
        this.horseBody.field_78795_f = rearingTime * -0.7853982f + rearingTimeLeft * this.horseBody.field_78795_f;
        float rearingAmount = 0.2617994f * rearingTime;
        float rearingCos = MathHelper.func_76134_b((float)(ticks * 0.6f + (float)Math.PI));
        this.leftFrontLeg.field_78797_d = 2.0f * rearingTime + 14.0f * rearingTimeLeft;
        this.leftFrontLeg.field_78798_e = -6.0f * rearingTime - 10.0f * rearingTimeLeft;
        this.rightFrontLeg.field_78797_d = this.leftFrontLeg.field_78797_d;
        this.rightFrontLeg.field_78798_e = this.leftFrontLeg.field_78798_e;
        float frontAngleCos = (-1.0471976f + rearingCos) * rearingTime + limbSwingAmountCos * rearingTimeLeft;
        float frontAngleSin = (-1.0471976f - rearingCos) * rearingTime - limbSwingAmountCos * rearingTimeLeft;
        this.leftBackLeg.field_78795_f = rearingAmount - limbSwingCos * 0.5f * limbSwingAmount * rearingTimeLeft;
        this.rightBackLeg.field_78795_f = rearingAmount + limbSwingCos * 0.5f * limbSwingAmount * rearingTimeLeft;
        this.leftFrontLeg.field_78795_f = frontAngleCos;
        this.rightFrontLeg.field_78795_f = frontAngleSin;
        boolean tailSwinging = ((CentaurEntity)((Object)entity)).tailCounter != 0;
        this.tail.field_78795_f = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.field_78797_d = -5.0f + limbSwingAmount;
        this.tail.field_78798_e = 2.0f + limbSwingAmount * 2.0f;
        this.tail.field_78796_g = tailSwinging ? MathHelper.func_76134_b((float)(ticks * 0.7f)) : 0.0f;
        boolean child = entity.func_70631_g_();
        this.horseBody.field_78797_d = child ? 10.8f : 0.0f;
    }

    public void renderHorseBody(T entity, MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount) {
        this.horseBody.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.leftBackLeg.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.rightBackLeg.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.leftFrontLeg.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.rightFrontLeg.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void renderQuiver(T entity, MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount) {
        this.quiver.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.field_78115_e.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public ModelRenderer getActualHead() {
        return this.field_78116_c;
    }
}

