/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.CerastesEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class CerastesModel<T extends CerastesEntity>
extends AgeableModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer mouth;
    private final ModelRenderer tongue;
    private final ModelRenderer body1;
    private final ModelRenderer body2;
    private final ModelRenderer body3;
    private final ModelRenderer body4;
    private final ModelRenderer body5;
    private final ModelRenderer body6;
    private final ModelRenderer body7;

    public CerastesModel(float modelSize) {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 10.0f, -6.0f);
        this.head.func_78784_a(0, 0).func_228301_a_(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 6.0f, modelSize);
        this.head.func_78784_a(25, 0).func_228301_a_(-2.0f, -1.0f, -10.0f, 4.0f, 2.0f, 4.0f, modelSize);
        this.head.func_78784_a(43, 5).func_228301_a_(-1.5f, 0.75f, -9.5f, 3.0f, 1.0f, 0.0f, modelSize);
        this.mouth = new ModelRenderer((Model)this);
        this.mouth.func_78793_a(0.0f, 1.0f, -6.0f);
        this.head.func_78792_a(this.mouth);
        this.mouth.field_78795_f = 0.5236f;
        this.mouth.func_78784_a(25, 7).func_228301_a_(-2.0f, 0.0f, -4.0f, 4.0f, 1.0f, 4.0f, modelSize);
        this.tongue = new ModelRenderer((Model)this);
        this.tongue.func_78793_a(0.0f, 0.0f, 0.0f);
        this.mouth.func_78792_a(this.tongue);
        this.tongue.func_78784_a(41, 0).func_228301_a_(-0.5f, 0.1f, -4.0f, 1.0f, 0.0f, 4.0f, modelSize);
        this.head.func_78792_a(CerastesModel.makeRamHorn(this, modelSize, 3.0f, -2.0f, -4.0f, true));
        this.head.func_78792_a(CerastesModel.makeRamHorn(this, modelSize, -4.0f, -2.0f, -4.0f, false));
        this.head.func_78792_a(CerastesModel.makePapillae(this, modelSize, true));
        this.head.func_78792_a(CerastesModel.makePapillae(this, modelSize, false));
        this.body1 = new ModelRenderer((Model)this);
        this.body1.func_78793_a(0.0f, 8.0f, -6.5f);
        this.body1.func_78784_a(0, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 6.0f, 0.0f, false);
        this.body2 = new ModelRenderer((Model)this);
        this.body2.func_78793_a(0.0f, 0.0f, 6.0f);
        this.body1.func_78792_a(this.body2);
        this.body2.func_78784_a(0, 13).func_228303_a_(-2.01f, 0.01f, 0.0f, 4.0f, 4.0f, 6.0f, 0.0f, false);
        this.body3 = new ModelRenderer((Model)this);
        this.body3.func_78793_a(0.0f, 4.0f, 5.5f);
        this.body2.func_78792_a(this.body3);
        this.body3.func_78784_a(0, 13).func_228303_a_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, 0.0f, false);
        this.body4 = new ModelRenderer((Model)this);
        this.body4.func_78793_a(0.0f, 0.0f, 5.5f);
        this.body3.func_78792_a(this.body4);
        this.body4.func_78784_a(0, 13).func_228303_a_(-2.01f, -4.01f, 0.0f, 4.0f, 4.0f, 6.0f, 0.0f, false);
        this.body5 = new ModelRenderer((Model)this);
        this.body5.func_78793_a(0.0f, 0.0f, 5.5f);
        this.body4.func_78792_a(this.body5);
        this.body5.func_78784_a(0, 13).func_228303_a_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, 0.0f, false);
        this.body6 = new ModelRenderer((Model)this);
        this.body6.func_78793_a(0.0f, 0.0f, 5.5f);
        this.body5.func_78792_a(this.body6);
        this.body6.func_78784_a(21, 14).func_228303_a_(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 6.0f, 0.0f, false);
        this.body7 = new ModelRenderer((Model)this);
        this.body7.func_78793_a(0.0f, 0.0f, 5.5f);
        this.body6.func_78792_a(this.body7);
        this.body7.func_78784_a(22, 14).func_228303_a_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 6.0f, 0.0f, false);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        float standingTime = ((CerastesEntity)entity).getStandingTime(partialTick);
        float hidingTime = ((CerastesEntity)entity).getHidingTime(partialTick);
        this.head.field_78797_d = 21.5f - 10.25f * standingTime + 6.5f * hidingTime;
        this.head.field_78798_e = -6.0f + 6.0f * hidingTime;
        this.body1.field_78797_d = this.head.field_78797_d - 2.0f;
        this.body1.field_78798_e = this.head.field_78798_e - 0.5f;
        this.head.field_78796_g = rotationYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = rotationPitch * ((float)Math.PI / 180);
        this.tongue.field_78798_e = -4.0f * (1.0f - 2.0f * Math.abs(((CerastesEntity)entity).getTongueTime() - 0.5f));
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTick);
        float standingTime = ((CerastesEntity)entity).getStandingTime(partialTick);
        float standingTimeLeft = 1.0f - standingTime;
        float hidingTime = ((CerastesEntity)entity).getHidingTime(partialTick);
        float limbSwingCos = ((CerastesEntity)entity).isHiding() ? 1.0f : MathHelper.func_76134_b((float)limbSwing);
        float idleSwingCos = MathHelper.func_76134_b((float)(((float)((CerastesEntity)entity).field_70173_aa + partialTick) * 0.22f));
        this.body1.field_78795_f = -0.7854f * standingTime - 1.4707f * hidingTime;
        this.body2.field_78795_f = -0.5236f * standingTime;
        this.body3.field_78795_f = 0.3491f * standingTime;
        this.body4.field_78795_f = 0.9599f * standingTime;
        this.mouth.field_78795_f = (0.5236f + 0.06f * idleSwingCos) * standingTime;
        this.body1.field_78796_g = limbSwingCos * -0.4f * standingTimeLeft;
        this.body2.field_78796_g = limbSwingCos * 0.4f * standingTimeLeft;
        this.body3.field_78796_g = limbSwingCos * -0.65f * standingTimeLeft;
        this.body4.field_78796_g = limbSwingCos * 0.75f * standingTimeLeft;
        this.body5.field_78796_g = limbSwingCos * -0.65f;
        this.body6.field_78796_g = limbSwingCos * 0.65f;
        this.body7.field_78796_g = limbSwingCos * -0.25f;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body1);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    public static ModelRenderer makeRamHorn(EntityModel<?> model, float modelSize, float rotX, float rotY, float rotZ, boolean isLeft) {
        float angleY = isLeft ? 0.1745f : -0.1745f;
        ModelRenderer horn1 = new ModelRenderer(model);
        horn1.func_78793_a(rotX, rotY, rotZ);
        horn1.field_78795_f = -0.2618f;
        horn1.func_78784_a(58, 0).func_228301_a_(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, modelSize);
        horn1.field_78809_i = isLeft;
        ModelRenderer horn2 = new ModelRenderer(model);
        horn2.func_78793_a(0.0f, -4.0f, 0.0f);
        horn2.field_78795_f = -0.7854f;
        horn2.field_78796_g = angleY;
        horn2.func_78784_a(58, 6).func_228301_a_(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, modelSize);
        horn2.field_78809_i = isLeft;
        horn1.func_78792_a(horn2);
        ModelRenderer horn3 = new ModelRenderer(model);
        horn3.func_78793_a(0.0f, -4.0f, 0.0f);
        horn3.field_78795_f = -1.2217f;
        horn3.field_78796_g = angleY;
        horn3.func_78784_a(58, 13).func_228301_a_(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, modelSize);
        horn3.field_78809_i = isLeft;
        horn2.func_78792_a(horn3);
        ModelRenderer horn4 = new ModelRenderer(model);
        horn4.func_78793_a(0.0f, -4.0f, 0.0f);
        horn4.field_78795_f = -1.2217f;
        horn4.field_78796_g = angleY;
        horn4.func_78784_a(58, 18).func_228301_a_(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, modelSize);
        horn4.field_78809_i = isLeft;
        horn3.func_78792_a(horn4);
        ModelRenderer horn5 = new ModelRenderer(model);
        horn5.func_78793_a(0.0f, -3.0f, 0.0f);
        horn5.field_78795_f = -1.0472f;
        horn5.field_78796_g = angleY;
        horn5.func_78784_a(58, 22).func_228301_a_(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, modelSize);
        horn5.field_78809_i = isLeft;
        horn4.func_78792_a(horn5);
        return horn1;
    }

    public static ModelRenderer makePapillae(EntityModel<?> model, float modelSize, boolean isLeft) {
        float rotX = isLeft ? 1.0f : -2.0f;
        float angleZ = isLeft ? 0.1745f : -0.1745f;
        ModelRenderer papillae = new ModelRenderer(model);
        papillae.func_78793_a(rotX, -4.0f, -4.0f);
        papillae.field_78795_f = 0.48f;
        papillae.field_78808_h = angleZ;
        papillae.func_78784_a(59, 13).func_228301_a_(0.0f, -4.0f, -1.0f, 1.0f, 4.0f, 1.0f, modelSize);
        return papillae;
    }
}

