/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.entity.CerberusEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class CerberusModel<T extends CerberusEntity>
extends AgeableModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer neck1;
    private final ModelRenderer head1;
    private final ModelRenderer mouth1;
    private final ModelRenderer neck2;
    private final ModelRenderer head2;
    private final ModelRenderer mouth2;
    private final ModelRenderer neck3;
    private final ModelRenderer head3;
    private final ModelRenderer mouth3;
    private final ModelRenderer legFrontRight;
    private final ModelRenderer legBackRight;
    private final ModelRenderer legFrontLeft;
    private final ModelRenderer legBackLeft;
    private final ModelRenderer tail1;
    private final ModelRenderer tail2;
    float color = 1.0f;

    public CerberusModel(float modelSize) {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.func_78784_a(0, 29).func_228301_a_(-5.0f, -18.0f, -6.0f, 10.0f, 8.0f, 6.0f, modelSize);
        this.body.func_78784_a(0, 12).func_228301_a_(-4.0f, -17.0f, 0.0f, 8.0f, 7.0f, 9.0f, modelSize);
        this.neck1 = new ModelRenderer((Model)this);
        this.head1 = new ModelRenderer((Model)this);
        this.mouth1 = new ModelRenderer((Model)this);
        CerberusModel.initCerberusHead((Model)this, this.neck1, this.head1, this.mouth1, 0.0f, 12.0f, -6.0f, 0.0f);
        this.neck2 = new ModelRenderer((Model)this);
        this.head2 = new ModelRenderer((Model)this);
        this.mouth2 = new ModelRenderer((Model)this);
        CerberusModel.initCerberusHead((Model)this, this.neck2, this.head2, this.mouth2, 4.0f, 14.0f, -5.0f, -0.5236f);
        this.neck3 = new ModelRenderer((Model)this);
        this.head3 = new ModelRenderer((Model)this);
        this.mouth3 = new ModelRenderer((Model)this);
        CerberusModel.initCerberusHead((Model)this, this.neck3, this.head3, this.mouth3, -4.0f, 14.0f, -5.0f, 0.5236f);
        this.legFrontRight = CerberusModel.makeLegModel((Model)this, -3.0f, 14.0f, -2.0f);
        this.legBackRight = CerberusModel.makeLegModel((Model)this, -3.0f, 14.0f, 7.0f);
        this.legFrontLeft = CerberusModel.makeLegModel((Model)this, 3.0f, 14.0f, -2.0f);
        this.legBackLeft = CerberusModel.makeLegModel((Model)this, 3.0f, 14.0f, 7.0f);
        this.tail1 = new ModelRenderer((Model)this);
        this.tail1.func_78793_a(0.0f, 7.0f, 9.0f);
        this.tail1.func_78784_a(50, 0).func_228301_a_(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, modelSize);
        this.tail2 = new ModelRenderer((Model)this);
        this.tail2.func_78793_a(0.0f, 6.0f, -2.0f);
        this.tail1.func_78792_a(this.tail2);
        this.tail2.func_78784_a(50, 8).func_228301_a_(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, modelSize);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.neck1, (Object)this.neck2, (Object)this.neck3);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft, (Object)this.tail1);
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        float limbSwingCos = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float limbSwingSin = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        float ticks = (float)((CerberusEntity)((Object)entity)).field_70173_aa + partialTick;
        float idleSwing = 0.12f * MathHelper.func_76134_b((float)(ticks * 0.11f));
        float tailSwing = 0.42f * limbSwingCos;
        this.tail1.field_78795_f = 0.5854f + tailSwing;
        this.tail2.field_78795_f = 0.2618f + tailSwing * 0.6f;
        this.tail1.field_78808_h = idleSwing;
        this.tail2.field_78808_h = idleSwing * 0.85f;
        float legAngle = 1.2f;
        this.legBackRight.field_78795_f = limbSwingCos * 1.2f;
        this.legBackLeft.field_78795_f = limbSwingSin * 1.2f;
        this.legFrontRight.field_78795_f = limbSwingSin * 1.2f;
        this.legFrontLeft.field_78795_f = limbSwingCos * 1.2f;
        float howlingTimeLeft = 1.0f - ((CerberusEntity)((Object)entity)).getSummonPercent(partialTick);
        float mouthAngle = 0.26f;
        this.mouth1.field_78795_f = (0.26f - MathHelper.func_76134_b((float)((ticks + 0.0f) * 0.28f)) * 0.26f * 0.3f) * howlingTimeLeft;
        this.mouth2.field_78795_f = (0.26f - MathHelper.func_76134_b((float)((ticks + 0.9f) * 0.19f)) * 0.26f * 0.3f) * howlingTimeLeft;
        this.mouth3.field_78795_f = (0.26f - MathHelper.func_76134_b((float)((ticks + 0.4f) * 0.24f)) * 0.26f * 0.3f) * howlingTimeLeft;
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        this.color = ((CerberusEntity)((Object)entity)).isSpawning() ? ((CerberusEntity)((Object)entity)).getSpawnPercent(partialTick) : 1.0f;
        float ticks = (float)((CerberusEntity)((Object)entity)).field_70173_aa + partialTick;
        float howlingTime = ((CerberusEntity)((Object)entity)).getSummonPercent(partialTick);
        float howlingTimeLeft = 1.0f - howlingTime;
        float howlingAngle = howlingTime > 0.0f ? -4.0f * (float)Math.pow(2.0f * howlingTime - 1.0f, 2.0) + 5.0f : 1.0f;
        float neckAngleX = 0.1f;
        float neck1X = -0.2618f * howlingAngle + MathHelper.func_76134_b((float)((ticks + 0.1f) * 0.049f)) * 0.1f * howlingTimeLeft;
        float neck2X = -0.1745f * howlingAngle + MathHelper.func_76134_b((float)((ticks + 0.9f) * 0.059f)) * 0.1f * howlingTimeLeft;
        float neck3X = -0.1745f * howlingAngle + MathHelper.func_76134_b((float)((ticks + 1.5f) * 0.055f)) * 0.1f * howlingTimeLeft;
        this.neck1.field_78795_f = neck1X;
        this.neck2.field_78795_f = neck2X;
        this.neck3.field_78795_f = neck3X;
        float offsetX = 0.2309f;
        float pitch = rotationPitch * ((float)Math.PI / 180);
        float yaw = rotationYaw * ((float)Math.PI / 180) * howlingTimeLeft;
        this.head1.field_78795_f = (pitch - this.neck1.field_78795_f) * howlingTimeLeft;
        this.head1.field_78796_g = yaw;
        this.head2.field_78795_f = (pitch - this.neck2.field_78795_f) * howlingTimeLeft;
        this.head2.field_78796_g = yaw * 0.8f + 0.2309f;
        this.head3.field_78795_f = (pitch - this.neck3.field_78795_f) * howlingTimeLeft;
        this.head3.field_78796_g = yaw * 0.8f - 0.2309f;
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float redIn, float greenIn, float blueIn, float alphaIn) {
        super.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, 1.0f, this.color, this.color, alphaIn);
    }

    public static ModelRenderer makeLegModel(Model model, float rotX, float rotY, float rotZ) {
        ModelRenderer leg = new ModelRenderer(model);
        leg.func_78793_a(rotX, rotY, rotZ);
        leg.func_78784_a(37, 0).func_228301_a_(-2.0f, 4.0f, -2.0f, 3.0f, 6.0f, 3.0f, 0.0f);
        leg.func_78784_a(33, 10).func_228301_a_(-2.5f, -2.0f, -2.5f, 4.0f, 6.0f, 4.0f, 0.0f);
        return leg;
    }

    public static void initCerberusHead(Model model, ModelRenderer neck, ModelRenderer head, ModelRenderer mouth, float rotX, float rotY, float rotZ, float neckY) {
        CerberusModel.initCerberusHead(model, head, mouth, 0.0f, -4.0f, -3.0f);
        neck.func_78793_a(rotX, rotY, rotZ);
        neck.field_78796_g = neckY;
        neck.func_78784_a(50, 17).func_228301_a_(-1.5f, -4.0f, -3.0f, 3.0f, 4.0f, 3.0f, 0.0f);
        neck.func_78792_a(head);
    }

    public static void initCerberusHead(Model model, ModelRenderer head, ModelRenderer mouth, float rotX, float rotY, float rotZ) {
        head.func_78793_a(rotX, rotY, rotZ);
        head.func_78784_a(0, 0).func_228301_a_(-2.5f, -2.0f, -5.0f, 5.0f, 6.0f, 5.0f, 0.0f);
        head.func_78784_a(21, 0).func_228301_a_(-1.5f, 1.0f, -9.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        head.func_78784_a(16, 0).func_228301_a_(-2.5f, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        head.func_78784_a(16, 0).func_228303_a_(0.5f, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, 0.0f, true);
        mouth.func_78793_a(0.0f, 3.0f, -5.0f);
        mouth.func_78784_a(21, 6).func_228301_a_(-1.5f, 0.0f, -4.0f, 3.0f, 1.0f, 4.0f, 0.0f);
        head.func_78792_a(mouth);
    }
}

