/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.client.render.model.GorgonModel;
import greekfantasy.entity.FuryEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class FuryModel<T extends FuryEntity>
extends BipedModel<T> {
    private final ModelRenderer chest;
    private final ModelRenderer leftWingArm;
    private final ModelRenderer leftWing;
    private final ModelRenderer leftWing2;
    private final ModelRenderer rightWingArm;
    private final ModelRenderer rightWing;
    private final ModelRenderer rightWing2;
    private final ModelRenderer snakeHair;
    private final ModelRenderer[] snakeHair1;
    private final ModelRenderer[] snakeHair2;
    private final ModelRenderer[] snakeHair3;

    public FuryModel(float modelSize) {
        super(modelSize, 0.0f, 64, 64);
        this.field_78116_c = new ModelRenderer((Model)this);
        this.field_78116_c.func_78793_a(0.0f, 4.0f, 0.0f);
        this.field_78116_c.func_78784_a(0, 0).func_228303_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.field_178720_f.func_78793_a(0.0f, 4.0f, 0.0f);
        this.field_78115_e = new ModelRenderer((Model)this);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_78115_e.func_78784_a(16, 16).func_228303_a_(-4.0f, 4.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f, false);
        this.field_178723_h = new ModelRenderer((Model)this);
        this.field_178723_h.func_78793_a(-5.0f, 5.0f, 0.0f);
        this.field_178723_h.func_78784_a(40, 16).func_228303_a_(-2.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f, false);
        this.field_178724_i = new ModelRenderer((Model)this);
        this.field_178724_i.func_78793_a(5.0f, 5.0f, 0.0f);
        this.field_178724_i.func_78784_a(32, 48).func_228303_a_(-1.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f, false);
        this.field_178724_i.field_78809_i = true;
        this.field_178721_j = new ModelRenderer((Model)this);
        this.field_178721_j.func_78793_a(-2.0f, 16.0f, 0.0f);
        this.field_178721_j.func_78784_a(0, 16).func_228303_a_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
        this.field_178722_k = new ModelRenderer((Model)this);
        this.field_178722_k.func_78793_a(2.0f, 16.0f, 0.0f);
        this.field_178722_k.func_78784_a(16, 48).func_228303_a_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
        this.field_178722_k.field_78809_i = true;
        this.chest = new ModelRenderer((Model)this);
        this.chest.func_78793_a(0.0f, 5.0f, -2.0f);
        this.chest.field_78795_f = -0.2182f;
        this.chest.func_78784_a(0, 32).func_228301_a_(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, modelSize);
        this.leftWingArm = new ModelRenderer((Model)this);
        this.leftWingArm.func_78793_a(1.0f, 8.0f, 2.0f);
        this.leftWingArm.field_78795_f = 0.0873f;
        this.leftWingArm.field_78796_g = 0.3927f;
        this.leftWingArm.func_78784_a(47, 33).func_228301_a_(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 4.0f, modelSize);
        this.leftWingArm.field_78809_i = true;
        this.leftWing = new ModelRenderer((Model)this);
        this.leftWing.func_78793_a(3.0f, 0.0f, 4.0f);
        this.leftWing.func_78784_a(31, 33).func_228301_a_(-4.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, modelSize);
        this.leftWing.field_78809_i = true;
        this.leftWingArm.func_78792_a(this.leftWing);
        this.leftWing2 = new ModelRenderer((Model)this);
        this.leftWing2.func_78793_a(2.0f, -7.0f, 1.0f);
        this.leftWing2.func_78784_a(46, 43).func_228301_a_(0.0f, -3.0f, -1.0f, 8.0f, 20.0f, 1.0f, modelSize);
        this.leftWing2.field_78809_i = true;
        this.leftWing.func_78792_a(this.leftWing2);
        this.rightWingArm = new ModelRenderer((Model)this);
        this.rightWingArm.func_78793_a(-1.0f, 8.0f, 2.0f);
        this.rightWingArm.field_78795_f = 0.0873f;
        this.rightWingArm.field_78796_g = -0.3927f;
        this.rightWingArm.func_78784_a(33, 33).func_228301_a_(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 4.0f, modelSize);
        this.rightWing = new ModelRenderer((Model)this);
        this.rightWing.func_78793_a(-2.0f, 0.0f, 4.0f);
        this.rightWing.func_78784_a(31, 33).func_228303_a_(-3.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, 0.0f, true);
        this.rightWingArm.func_78792_a(this.rightWing);
        this.rightWing2 = new ModelRenderer((Model)this);
        this.rightWing2.func_78793_a(-3.0f, -8.0f, 1.0f);
        this.rightWing2.func_78784_a(46, 43).func_228303_a_(-8.0f, -2.0f, -1.0f, 8.0f, 20.0f, 1.0f, 0.0f, true);
        this.rightWing.func_78792_a(this.rightWing2);
        this.snakeHair = new ModelRenderer((Model)this);
        this.snakeHair.func_78793_a(0.0f, 4.0f, 0.0f);
        this.snakeHair1 = this.makeSnakes(3.8f, 0.5235988f, modelSize).toArray(new ModelRenderer[0]);
        this.snakeHair2 = this.makeSnakes(2.25f, 0.7853982f, modelSize).toArray(new ModelRenderer[0]);
        this.snakeHair3 = this.makeSnakes(1.25f, 1.0471976f, modelSize).toArray(new ModelRenderer[0]);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return Iterables.concat((Iterable)super.func_225600_b_(), (Iterable)ImmutableList.of((Object)this.chest, (Object)this.leftWingArm, (Object)this.rightWingArm));
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, partialTick, rotationYaw, rotationPitch);
        this.field_78116_c.func_78793_a(0.0f, 4.0f, 0.0f);
        this.snakeHair.func_217177_a(this.field_78116_c);
        this.field_178720_f.func_78793_a(0.0f, 4.0f, 0.0f);
        this.field_178723_h.func_78793_a(-5.0f, 5.0f, 0.0f);
        this.field_178724_i.func_78793_a(5.0f, 5.0f, 0.0f);
        this.field_178721_j.func_78793_a(-2.0f, 16.0f, 0.0f);
        this.field_178722_k.func_78793_a(2.0f, 16.0f, 0.0f);
        float flyingLeft = 1.0f - ((FuryEntity)((Object)entity)).flyingTime * 0.74f;
        this.field_178722_k.field_78795_f *= flyingLeft;
        this.field_178721_j.field_78795_f *= flyingLeft;
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTick);
        float flying = ((FuryEntity)((Object)entity)).flyingTime > 0.01f && ((FuryEntity)((Object)entity)).field_70173_aa > 5 ? MathHelper.func_76131_a((float)((FuryEntity)((Object)entity)).flyingTime, (float)0.0f, (float)1.0f) : 0.0f;
        float ticks = (float)(entity.func_145782_y() * 2 + ((FuryEntity)((Object)entity)).field_70173_aa) + partialTick;
        float cosTicks = MathHelper.func_76134_b((float)(ticks * (0.2f + flying * 0.25f)));
        this.leftWing.field_78796_g = cosTicks * (0.035f + flying * 0.21f);
        this.leftWing2.field_78796_g = 0.3491f + cosTicks * (0.05f + flying * 0.11f);
        this.rightWing.field_78796_g = -cosTicks * (0.035f + flying * 0.21f);
        this.rightWing2.field_78796_g = -0.3491f - cosTicks * (0.05f + flying * 0.11f);
    }

    private void animateSnakes(ModelRenderer[] list, float ticks, float baseAngleX) {
        int l = list.length;
        for (int i = 0; i < l; ++i) {
            list[i].field_78795_f = baseAngleX + (float)Math.cos((double)ticks * 0.32 + (double)((float)i * 2.89f)) * 0.08f;
        }
    }

    public void renderSnakeHair(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float ticks, float aggroTime) {
        this.animateSnakes(this.snakeHair1, ticks, 1.7f);
        this.animateSnakes(this.snakeHair2, ticks, 1.03f);
        this.animateSnakes(this.snakeHair3, ticks, 0.82f);
        matrixStackIn.func_227860_a_();
        this.snakeHair.func_217177_a(this.field_78116_c);
        float scale = 0.25f + aggroTime * 0.75f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.snakeHair.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    private List<ModelRenderer> makeSnakes(float radius, float deltaAngle, float modelSize) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        double count = 1.0;
        for (double angle = 0.0; angle < Math.PI * 2; angle += (double)deltaAngle) {
            float ptX = (float)(Math.cos(angle) * (double)radius);
            float ptZ = (float)(Math.sin(angle) * (double)radius);
            float angY = (float)(angle - (double)(deltaAngle * 2.0f) * count);
            ModelRenderer snake = GorgonModel.makeSnake((Model)this, ptX, -8.5f, ptZ, 0.0f, angY, 0.0f, 0, 52);
            list.add(snake);
            this.snakeHair.func_78792_a(snake);
            count += 1.0;
        }
        return list;
    }
}

