/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.client.render.model.DrakainaModel;
import greekfantasy.entity.GorgonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;

public class GorgonModel<T extends GorgonEntity>
extends DrakainaModel<T> {
    private final ModelRenderer chest;
    private final ModelRenderer snakeHair;
    private final List<ModelRenderer> snakeHair1 = new ArrayList<ModelRenderer>();
    private final List<ModelRenderer> snakeHair2 = new ArrayList<ModelRenderer>();
    private final List<ModelRenderer> snakeHair3 = new ArrayList<ModelRenderer>();

    public GorgonModel(float modelSize) {
        super(modelSize);
        this.field_178720_f.field_78806_j = false;
        this.chest = new ModelRenderer((Model)this);
        this.chest.func_78793_a(0.0f, 1.0f, -4.0f);
        this.chest.field_78795_f = -0.2182f;
        this.chest.func_78784_a(0, 17).func_228301_a_(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, modelSize);
        this.snakeHair = new ModelRenderer((Model)this);
        this.snakeHair.func_78793_a(0.0f, 0.0f, 0.0f);
        this.makeSnakes(this.snakeHair1, 3.8f, 0.5235988f, modelSize);
        this.makeSnakes(this.snakeHair2, 2.25f, 0.7853982f, modelSize);
        this.makeSnakes(this.snakeHair3, 1.25f, 1.0471976f, modelSize);
    }

    @Override
    protected Iterable<ModelRenderer> func_225600_b_() {
        return Iterables.concat(super.func_225600_b_(), (Iterable)ImmutableList.of((Object)this.chest));
    }

    @Override
    public boolean canAnimateBow(T entity, ItemStack heldItem) {
        return ((GorgonEntity)((Object)entity)).isMedusa() && super.canAnimateBow(entity, heldItem);
    }

    public void renderSnakeHair(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float ticks, float colorAlpha) {
        this.animateSnakes(this.snakeHair1, ticks, 1.7f);
        this.animateSnakes(this.snakeHair2, ticks, 1.03f);
        this.animateSnakes(this.snakeHair3, ticks, 0.82f);
        this.snakeHair.func_217177_a(this.field_78116_c);
        this.snakeHair.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, colorAlpha);
    }

    private void animateSnakes(List<ModelRenderer> list, float ticks, float baseAngleX) {
        int i = 0;
        for (ModelRenderer m : list) {
            m.field_78795_f = baseAngleX + (float)Math.cos((double)ticks * 0.15 + (double)((float)i * 2.89f)) * 0.08f;
            ++i;
        }
    }

    private void makeSnakes(List<ModelRenderer> list, float radius, float deltaAngle, float modelSize) {
        double count = 1.0;
        for (double angle = 0.0; angle < Math.PI * 2; angle += (double)deltaAngle) {
            float ptX = (float)(Math.cos(angle) * (double)radius);
            float ptZ = (float)(Math.sin(angle) * (double)radius);
            float angY = (float)(angle - (double)(deltaAngle * 2.0f) * count);
            ModelRenderer snake = GorgonModel.makeSnake((Model)this, ptX, -8.5f, ptZ, 0.0f, angY, 0.0f, 46, 52);
            list.add(snake);
            this.snakeHair.func_78792_a(snake);
            count += 1.0;
        }
    }

    public static ModelRenderer makeSnake(Model model, float rotX, float rotY, float rotZ, float angleX, float angleY, float angleZ, int textureX, int textureY) {
        ModelRenderer snakeHair1 = new ModelRenderer(model);
        snakeHair1.func_78793_a(rotX, rotY, rotZ);
        snakeHair1.field_78795_f = angleX;
        snakeHair1.field_78796_g = angleY;
        snakeHair1.field_78808_h = angleZ;
        snakeHair1.func_78784_a(textureX, textureY).func_228301_a_(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, 0.0f);
        ModelRenderer snakeHair2 = new ModelRenderer(model);
        snakeHair2.func_78793_a(0.0f, -3.0f, 0.0f);
        snakeHair1.func_78792_a(snakeHair2);
        snakeHair2.field_78795_f = 0.5236f;
        snakeHair2.func_78784_a(textureX, textureY + 4).func_228301_a_(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, 0.0f);
        ModelRenderer snakeHair3 = new ModelRenderer(model);
        snakeHair3.func_78793_a(0.0f, -3.0f, -0.5f);
        snakeHair2.func_78792_a(snakeHair3);
        snakeHair3.field_78795_f = 0.5236f;
        snakeHair3.func_78784_a(textureX, textureY + 8).func_228301_a_(-1.0f, -1.5f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        return snakeHair1;
    }
}

