/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.HarpyEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class HarpyModel<T extends HarpyEntity>
extends BipedModel<T> {
    private final ModelRenderer chest;
    private final ModelRenderer tail;
    private final ModelRenderer leftWing1;
    private final ModelRenderer leftWing2;
    private final ModelRenderer leftWing3;
    private final ModelRenderer rightWing1;
    private final ModelRenderer rightWing2;
    private final ModelRenderer rightWing3;

    public HarpyModel(float modelSize) {
        super(modelSize, 0.0f, 64, 64);
        this.field_78116_c.func_78784_a(24, 0).func_228301_a_(-4.0f, 0.0f, 4.0f, 8.0f, 5.0f, 0.0f, modelSize);
        this.chest = new ModelRenderer((Model)this);
        this.chest.func_78793_a(0.0f, 1.0f, -2.0f);
        this.chest.field_78795_f = -0.2182f;
        this.chest.func_78784_a(19, 20).func_228301_a_(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, modelSize);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, 12.0f, 2.0f);
        this.tail.field_78795_f = 0.3491f;
        this.tail.func_78784_a(48, 57).func_228301_a_(-4.0f, 0.0f, 0.0f, 8.0f, 7.0f, 0.0f, modelSize);
        this.field_178722_k = new ModelRenderer((Model)this);
        this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        this.field_178722_k.func_78784_a(0, 33).func_228301_a_(-1.0f, 0.0f, -2.0f, 3.0f, 11.0f, 3.0f, modelSize);
        this.field_178722_k.field_78809_i = true;
        this.field_178721_j = new ModelRenderer((Model)this);
        this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
        this.field_178721_j.func_78784_a(0, 17).func_228301_a_(-2.0f, 0.0f, -2.0f, 3.0f, 11.0f, 3.0f, modelSize);
        this.field_178722_k.func_78792_a(this.makeFoot(modelSize, true));
        this.field_178721_j.func_78792_a(this.makeFoot(modelSize, false));
        this.leftWing1 = new ModelRenderer((Model)this);
        this.leftWing1.func_78793_a(4.0f, 1.0f, 0.0f);
        this.leftWing1.func_78784_a(0, 48).func_228303_a_(0.0f, 0.0f, 0.0f, 6.0f, 10.0f, 1.0f, 0.0f, true);
        this.leftWing1.field_78809_i = true;
        this.leftWing2 = new ModelRenderer((Model)this);
        this.leftWing2.func_78793_a(6.0f, 0.0f, 1.0f);
        this.leftWing1.func_78792_a(this.leftWing2);
        this.leftWing2.func_78784_a(15, 48).func_228303_a_(0.0f, 0.0f, -1.05f, 8.0f, 14.0f, 1.0f, 0.0f, true);
        this.leftWing2.field_78809_i = true;
        this.leftWing3 = new ModelRenderer((Model)this);
        this.leftWing3.func_78793_a(8.0f, 0.0f, 0.0f);
        this.leftWing2.func_78792_a(this.leftWing3);
        this.leftWing3.func_78784_a(34, 48).func_228303_a_(0.0f, 0.0f, -1.1f, 6.0f, 10.0f, 1.0f, 0.0f, true);
        this.leftWing3.field_78809_i = true;
        this.rightWing1 = new ModelRenderer((Model)this);
        this.rightWing1.func_78793_a(-4.0f, 1.0f, 0.0f);
        this.rightWing1.func_78784_a(0, 48).func_228301_a_(-6.0f, 0.0f, 0.0f, 6.0f, 10.0f, 1.0f, modelSize);
        this.rightWing2 = new ModelRenderer((Model)this);
        this.rightWing2.func_78793_a(-6.0f, 0.0f, 1.0f);
        this.rightWing1.func_78792_a(this.rightWing2);
        this.rightWing2.func_78784_a(15, 48).func_228301_a_(-8.0f, 0.0f, -1.05f, 8.0f, 14.0f, 1.0f, modelSize);
        this.rightWing3 = new ModelRenderer((Model)this);
        this.rightWing3.func_78793_a(-8.0f, 0.0f, 0.0f);
        this.rightWing2.func_78792_a(this.rightWing3);
        this.rightWing3.func_78784_a(34, 48).func_228301_a_(-6.0f, 0.0f, -1.1f, 6.0f, 10.0f, 1.0f, modelSize);
        this.field_178723_h.field_78806_j = false;
        this.field_178724_i.field_78806_j = false;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.chest, (Object)this.tail, (Object)this.field_178721_j, (Object)this.field_178722_k, (Object)this.rightWing1, (Object)this.leftWing1, (Object)this.field_178720_f);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float flyingTime = ((HarpyEntity)((Object)entity)).flyingTime;
        float flyingTimeLeft = 1.0f - flyingTime;
        this.field_178722_k.field_78795_f *= flyingTimeLeft * 0.6f;
        this.field_178722_k.field_78795_f += -0.35f * flyingTime;
        this.field_178721_j.field_78795_f *= flyingTimeLeft * 0.6f;
        this.field_178721_j.field_78795_f += -0.35f * flyingTime;
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)(entity.func_145782_y() * 2 + ((HarpyEntity)((Object)entity)).field_70173_aa) + partialTick;
        float flyingTime = ((HarpyEntity)((Object)entity)).flyingTime;
        float flyingTimeLeft = 1.0f - flyingTime;
        float downSwing = 0.5f;
        float wingAngle = 0.5f;
        float wingSpeed = 0.7f;
        float cosTicks = flyingTime > 0.0f ? MathHelper.func_76134_b((float)(ticks * 0.7f)) : 0.0f;
        float sinTicks = flyingTime > 0.0f ? MathHelper.func_76134_b((float)(ticks * 0.7f + (float)Math.PI)) : 0.0f;
        float idleSwing = 0.035f * MathHelper.func_76134_b((float)(ticks * 0.08f));
        this.leftWing1.field_78795_f = 1.0472f - 0.7854f * flyingTime;
        this.leftWing1.field_78796_g = 0.0f + (cosTicks + 0.5f) * 0.5f * 0.75f * flyingTime;
        this.leftWing1.field_78808_h = 0.9908f - 0.8908f * flyingTime + idleSwing;
        this.leftWing2.field_78796_g = 0.5236f * flyingTimeLeft + (cosTicks + 0.5f) * 0.5f * flyingTime;
        this.leftWing3.field_78796_g = 0.1745f * flyingTimeLeft + (cosTicks + 0.5f) * 0.5f * flyingTime;
        this.rightWing1.field_78795_f = this.leftWing1.field_78795_f;
        this.rightWing1.field_78796_g = 0.0f + (sinTicks - 0.5f) * 0.32f * flyingTime;
        this.rightWing1.field_78808_h = -0.9908f + 0.8908f * flyingTime - idleSwing;
        this.rightWing2.field_78796_g = -0.5236f * flyingTimeLeft + (sinTicks - 0.5f) * 0.5f * flyingTime;
        this.rightWing3.field_78796_g = -0.1745f * flyingTimeLeft + (sinTicks - 0.5f) * 0.5f * flyingTime;
    }

    private ModelRenderer makeFoot(float modelSize, boolean isLeft) {
        float offsetX = isLeft ? 1.0f : 0.0f;
        float rotationToe = 0.3491f;
        ModelRenderer foot = new ModelRenderer((Model)this);
        foot.func_78793_a(0.0f, 0.0f, 0.0f);
        ModelRenderer frontToe1 = new ModelRenderer((Model)this);
        frontToe1.func_78793_a(offsetX - 1.0f, 10.0f, -2.0f);
        frontToe1.field_78795_f = 0.3491f;
        frontToe1.field_78796_g = 0.3491f;
        frontToe1.func_78784_a(13, 38).func_228301_a_(-1.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, modelSize);
        foot.func_78792_a(frontToe1);
        ModelRenderer frontToe2 = new ModelRenderer((Model)this);
        frontToe2.func_78793_a(offsetX, 10.0f, -2.0f);
        frontToe2.field_78795_f = 0.3491f;
        frontToe2.field_78796_g = -0.3491f;
        frontToe2.func_78784_a(13, 38).func_228301_a_(0.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, modelSize);
        foot.func_78792_a(frontToe2);
        ModelRenderer backToe = new ModelRenderer((Model)this);
        backToe.func_78793_a(offsetX, 10.0f, 1.0f);
        foot.func_78792_a(backToe);
        backToe.field_78795_f = -0.5236f;
        backToe.func_78784_a(13, 33).func_228301_a_(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f, modelSize);
        return foot;
    }
}

