/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.client.render.model.HoofedBipedModel;
import greekfantasy.entity.MinotaurEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class MinotaurModel<T extends MinotaurEntity>
extends HoofedBipedModel<T> {
    private boolean stomping;

    public MinotaurModel(float modelSize) {
        super(modelSize, true, false);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.field_78116_c.func_78784_a(24, 0).func_228301_a_(-3.0f, -3.0f, -5.0f, 6.0f, 3.0f, 1.0f, modelSize);
        this.field_78116_c.func_78792_a(MinotaurModel.makeBullHorns(this, modelSize, true));
        this.field_78116_c.func_78792_a(MinotaurModel.makeBullHorns(this, modelSize, false));
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, partialTick, rotationYaw, rotationPitch);
        if (((MinotaurEntity)((Object)entity)).isCharging()) {
            float ticks = (float)((MinotaurEntity)((Object)entity)).field_70173_aa + partialTick;
            float stompSpeed = ((MinotaurEntity)((Object)entity)).getStompingSpeed();
            float limbSwingSin = MathHelper.func_76134_b((float)(ticks * stompSpeed + (float)Math.PI));
            float limbSwingCos = MathHelper.func_76134_b((float)(ticks * stompSpeed)) * 0.75f;
            float rightLegSwing = 0.38f * limbSwingSin;
            float leftLegSwing = 0.38f * limbSwingCos;
            this.rightLegUpper.field_78795_f = -0.2618f + limbSwingSin * 0.42f;
            this.leftLegUpper.field_78795_f = -0.2618f + limbSwingCos * 0.42f;
            this.rightLegLower.field_78795_f = 0.7854f + rightLegSwing;
            this.rightHoof.field_78795_f = -0.5236f - rightLegSwing;
            this.leftLegLower.field_78795_f = 0.7854f + leftLegSwing;
            this.leftHoof.field_78795_f = -0.5236f - leftLegSwing;
            this.field_78116_c.field_78795_f = 0.558f;
        }
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float redIn, float greenIn, float blueIn, float alphaIn) {
        matrixStackIn.func_227860_a_();
        if (this.stomping) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(9.0f));
        }
        super.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, redIn, greenIn, blueIn, alphaIn);
        matrixStackIn.func_227865_b_();
    }

    public boolean isStomping() {
        return this.stomping;
    }

    public void setStomping(boolean isStomping) {
        this.stomping = isStomping;
    }

    public void resetStomping() {
        this.stomping = false;
    }

    public static ModelRenderer makeBullHorns(EntityModel<?> model, float modelSize, boolean isLeft) {
        int textureX = isLeft ? 58 : 51;
        float horn1X = isLeft ? 3.0f : -3.0f;
        float horn1Z = isLeft ? 0.0f : -2.0f;
        float angleY = isLeft ? -1.0f : 1.0f;
        ModelRenderer horn3 = new ModelRenderer(model);
        horn3.func_78793_a(0.0f, -3.0f, 0.0f);
        horn3.field_78795_f = -0.5236f;
        horn3.func_78784_a(textureX, 59).func_228301_a_(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, modelSize);
        horn3.field_78809_i = isLeft;
        ModelRenderer horn2 = new ModelRenderer(model);
        horn2.func_78793_a(-1.0f, -4.0f, -2.0f);
        horn2.field_78795_f = -0.5236f;
        horn2.func_78784_a(textureX, 54).func_228301_a_(-0.51f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, modelSize);
        horn2.func_78792_a(horn3);
        horn2.field_78809_i = isLeft;
        ModelRenderer horn1 = new ModelRenderer(model);
        horn1.func_78793_a(horn1X, -7.0f, horn1Z);
        horn1.field_78795_f = 1.3963f;
        horn1.field_78796_g = 1.0472f * angleY;
        horn1.func_78784_a(textureX, 48).func_228301_a_(-1.5f, -4.0f, -2.0f, 1.0f, 4.0f, 2.0f, modelSize);
        horn1.func_78792_a(horn2);
        horn1.field_78809_i = isLeft;
        return horn1;
    }
}

