/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.entity.SirenEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class SirenModel<T extends SirenEntity>
extends BipedModel<T> {
    private final ModelRenderer chest = new ModelRenderer((Model)this);
    private final ModelRenderer upperTail;
    private final ModelRenderer midTail;
    private final ModelRenderer lowerTail1;
    private final ModelRenderer lowerTail2;
    private final float swimSpeed = 0.14f;

    public SirenModel(float modelSize) {
        super(modelSize, 0.0f, 64, 64);
        this.chest.func_78793_a(0.0f, 1.0f, -2.0f);
        this.chest.field_78795_f = -0.2182f;
        this.chest.func_78784_a(0, 17).func_228301_a_(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, modelSize);
        this.upperTail = new ModelRenderer((Model)this);
        this.upperTail.func_78793_a(0.0f, 10.0f, 0.0f);
        this.upperTail.field_78795_f = -0.2618f;
        this.upperTail.func_78784_a(0, 32).func_228301_a_(-4.01f, 0.0f, -2.0f, 8.0f, 6.0f, 4.0f, modelSize);
        this.midTail = new ModelRenderer((Model)this);
        this.midTail.func_78793_a(0.0f, 6.0f, -2.0f);
        this.upperTail.func_78792_a(this.midTail);
        this.midTail.field_78795_f = 0.5236f;
        this.midTail.func_78784_a(0, 46).func_228301_a_(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 4.0f, modelSize);
        this.lowerTail1 = new ModelRenderer((Model)this);
        this.lowerTail1.func_78793_a(0.0f, 6.0f, 0.0f);
        this.midTail.func_78792_a(this.lowerTail1);
        this.lowerTail1.field_78795_f = 0.2618f;
        this.lowerTail1.func_78784_a(0, 23).func_228301_a_(-2.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f, modelSize);
        this.lowerTail2 = new ModelRenderer((Model)this);
        this.lowerTail2.func_78793_a(0.0f, 5.0f, 2.0f);
        this.lowerTail1.func_78792_a(this.lowerTail2);
        this.lowerTail2.func_78784_a(0, 57).func_228301_a_(-5.0f, -2.0f, -0.5f, 10.0f, 6.0f, 1.0f, modelSize);
        this.field_178724_i = new ModelRenderer((Model)this, 32, 48);
        this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize);
        this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
        this.field_178724_i.field_78809_i = true;
        this.field_178723_h = new ModelRenderer((Model)this, 40, 16);
        this.field_178723_h.func_228301_a_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize);
        this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
        this.field_178722_k.field_78806_j = false;
        this.field_178721_j.field_78806_j = false;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.chest, (Object)this.field_178724_i, (Object)this.field_178723_h, (Object)this.upperTail, (Object)this.field_178720_f);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float swimming = ((SirenEntity)entityIn).getSwimmingPercent(ageInTicks);
        if (swimming > 0.0f) {
            float ticks = ageInTicks + (float)entityIn.func_145782_y();
            float cosTicks = MathHelper.func_76134_b((float)(ticks * 0.14f * 0.75f)) * 0.5f + 0.5f;
            float minX = -0.09f;
            float maxX = 0.18f;
            float minZ = 0.52f;
            float maxZ = 1.08f;
            this.field_178723_h.field_78795_f = (0.09f - cosTicks * 0.27f) * swimming;
            this.field_178723_h.field_78808_h = (0.52f + cosTicks * 0.56000006f) * swimming;
            this.field_178724_i.field_78795_f = (0.09f - cosTicks * 0.27f) * swimming;
            this.field_178724_i.field_78808_h = (-0.52f - cosTicks * 0.56000006f) * swimming;
        }
        if (((SirenEntity)entityIn).isCharming()) {
            this.field_78116_c.field_78795_f = -0.24f;
        }
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTick);
        if (entity.func_203007_ba() || entity.func_70090_H()) {
            float ticks = (float)((SirenEntity)entity).field_70173_aa + partialTick + (float)entity.func_145782_y();
            float tailAngle = 0.21f;
            float cosTail = MathHelper.func_76134_b((float)(ticks * 0.14f)) * 0.21f;
            this.upperTail.field_78795_f = -0.2618f + cosTail * 0.4f;
            this.midTail.field_78795_f = 0.5236f + cosTail * 0.6f;
            this.lowerTail1.field_78795_f = 0.2618f + cosTail * 0.8f;
            this.lowerTail2.field_78795_f = cosTail * 0.8f;
        }
    }

    public void renderChest(T entity, MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount) {
        this.chest.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }
}

