/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.model.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.ModelPart;
import greekfantasy.util.StatuePose;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public class StatueModel<T extends StatueTileEntity>
extends Model
implements IHasArm,
IHasHead {
    protected ModelRenderer bipedHead;
    protected ModelRenderer bipedBody;
    protected ModelRenderer bipedBodyChest;
    protected ModelRenderer bipedRightArm;
    protected ModelRenderer bipedLeftArm;
    protected ModelRenderer bipedRightArmSlim;
    protected ModelRenderer bipedLeftArmSlim;
    protected ModelRenderer bipedRightLeg;
    protected ModelRenderer bipedLeftLeg;
    protected ModelRenderer bipedHeadwear;
    protected ModelRenderer bipedLeftArmwear;
    protected ModelRenderer bipedRightArmwear;
    protected ModelRenderer bipedLeftArmwearSlim;
    protected ModelRenderer bipedRightArmwearSlim;
    protected ModelRenderer bipedLeftLegwear;
    protected ModelRenderer bipedRightLegwear;
    protected ModelRenderer bipedBodyWear;
    private static final EnumMap<ModelPart, Collection<ModelRenderer>> ROTATION_MAP = new EnumMap(ModelPart.class);

    public StatueModel() {
        this(0.0f, 0.0f);
    }

    public StatueModel(float modelSizeIn, float yOffsetIn) {
        super(RenderType::func_228640_c_);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.bipedHead = new ModelRenderer((Model)this, 0, 0);
        this.bipedHead.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSizeIn);
        this.bipedHead.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.bipedBody = new ModelRenderer((Model)this, 16, 16);
        this.bipedBody.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedBody.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.bipedBodyChest = new ModelRenderer((Model)this);
        this.bipedBodyChest.func_78793_a(0.0f, 1.0f, -2.0f);
        this.bipedBodyChest.field_78795_f = -0.2182f;
        this.bipedBodyChest.func_78784_a(19, 20).func_228301_a_(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, modelSizeIn);
        this.bipedLeftArm = new ModelRenderer((Model)this, 32, 48);
        this.bipedLeftArm.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedLeftArm.func_78793_a(5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedLeftArm.field_78809_i = true;
        this.bipedRightArm = new ModelRenderer((Model)this, 40, 16);
        this.bipedRightArm.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedRightArm.func_78793_a(-5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedLeftArmSlim = new ModelRenderer((Model)this, 32, 48);
        this.bipedLeftArmSlim.func_228301_a_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedLeftArmSlim.func_78793_a(5.0f, 2.5f + yOffsetIn, 0.0f);
        this.bipedLeftArmSlim.field_78809_i = true;
        this.bipedRightArmSlim = new ModelRenderer((Model)this, 40, 16);
        this.bipedRightArmSlim.func_228301_a_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedRightArmSlim.func_78793_a(-5.0f, 2.5f + yOffsetIn, 0.0f);
        this.bipedRightLeg = new ModelRenderer((Model)this, 16, 48);
        this.bipedRightLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedRightLeg.func_78793_a(-2.0f, 12.0f + yOffsetIn, 0.0f);
        this.bipedLeftLeg = new ModelRenderer((Model)this, 0, 16);
        this.bipedLeftLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn);
        this.bipedLeftLeg.func_78793_a(2.0f, 12.0f + yOffsetIn, 0.0f);
        this.bipedHeadwear = new ModelRenderer((Model)this, 32, 0);
        this.bipedHeadwear.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSizeIn + 0.5f);
        this.bipedHeadwear.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.bipedLeftArmwear = new ModelRenderer((Model)this, 48, 48);
        this.bipedLeftArmwear.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedRightArmwear = new ModelRenderer((Model)this, 40, 32);
        this.bipedRightArmwear.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedLeftArmwearSlim = new ModelRenderer((Model)this, 48, 48);
        this.bipedLeftArmwearSlim.func_228301_a_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedLeftArmwearSlim.func_78793_a(5.0f, 2.5f + yOffsetIn, 0.0f);
        this.bipedRightArmwearSlim = new ModelRenderer((Model)this, 40, 32);
        this.bipedRightArmwearSlim.func_228301_a_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedRightArmwearSlim.func_78793_a(-5.0f, 2.5f + yOffsetIn, 0.0f);
        this.bipedLeftLegwear = new ModelRenderer((Model)this, 0, 48);
        this.bipedLeftLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f + yOffsetIn, 0.0f);
        this.bipedRightLegwear = new ModelRenderer((Model)this, 0, 32);
        this.bipedRightLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f + yOffsetIn, 0.0f);
        this.bipedBodyWear = new ModelRenderer((Model)this, 16, 32);
        this.bipedBodyWear.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSizeIn + 0.25f);
        this.bipedBodyWear.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        ROTATION_MAP.put(ModelPart.HEAD, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedHead, (Object)this.bipedHeadwear));
        ROTATION_MAP.put(ModelPart.BODY, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedBody, (Object)this.bipedBodyChest, (Object)this.bipedBodyWear));
        ROTATION_MAP.put(ModelPart.LEFT_ARM, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedLeftArm, (Object)this.bipedLeftArmSlim, (Object)this.bipedLeftArmwear, (Object)this.bipedLeftArmwearSlim));
        ROTATION_MAP.put(ModelPart.RIGHT_ARM, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedRightArm, (Object)this.bipedRightArmSlim, (Object)this.bipedRightArmwear, (Object)this.bipedRightArmwearSlim));
        ROTATION_MAP.put(ModelPart.LEFT_LEG, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedLeftLeg, (Object)this.bipedLeftLegwear));
        ROTATION_MAP.put(ModelPart.RIGHT_LEG, (Collection<ModelRenderer>)ImmutableList.of((Object)this.bipedRightLeg, (Object)this.bipedRightLegwear));
    }

    protected Iterable<ModelRenderer> getUpperParts() {
        return ImmutableList.of((Object)this.bipedHead, (Object)this.bipedBody, (Object)this.bipedBodyChest, (Object)this.bipedHeadwear, (Object)this.bipedBodyWear);
    }

    protected Iterable<ModelRenderer> getLowerParts() {
        return ImmutableList.of((Object)this.bipedLeftLeg, (Object)this.bipedRightLeg, (Object)this.bipedLeftLegwear, (Object)this.bipedRightLegwear);
    }

    protected Iterable<ModelRenderer> getSlimArms() {
        return ImmutableList.of((Object)this.bipedLeftArmSlim, (Object)this.bipedRightArmSlim, (Object)this.bipedLeftArmwearSlim, (Object)this.bipedRightArmwearSlim);
    }

    protected Iterable<ModelRenderer> getArms() {
        return ImmutableList.of((Object)this.bipedLeftArm, (Object)this.bipedRightArm, (Object)this.bipedLeftArmwear, (Object)this.bipedRightArmwear);
    }

    public void setRotationAngles(T entity, float partialTicks) {
        StatuePose pose = ((StatueTileEntity)((Object)entity)).getStatuePose();
        for (Map.Entry<ModelPart, Collection<ModelRenderer>> e : ROTATION_MAP.entrySet()) {
            Vector3f rotations = pose.getAngles(e.getKey());
            for (ModelRenderer m : e.getValue()) {
                m.field_78795_f = rotations.func_195899_a();
                m.field_78796_g = rotations.func_195900_b();
                m.field_78808_h = rotations.func_195902_c();
            }
        }
        this.bipedBody.field_78795_f = 0.0f;
        this.bipedBody.field_78796_g = 0.0f;
        this.bipedBody.field_78808_h = 0.0f;
        this.bipedBodyWear.field_78795_f = 0.0f;
        this.bipedBodyWear.field_78796_g = 0.0f;
        this.bipedBodyWear.field_78808_h = 0.0f;
        this.bipedBodyChest.field_78795_f = -0.2182f;
        this.bipedBodyChest.field_78796_g = 0.0f;
        this.bipedBodyChest.field_78808_h = 0.0f;
    }

    public void rotateAroundBody(Vector3f bodyRotations, MatrixStack matrixStackIn, float partialTicks) {
        if (bodyRotations.func_195902_c() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(bodyRotations.func_195902_c()));
        }
        if (bodyRotations.func_195900_b() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(bodyRotations.func_195900_b()));
        }
        if (bodyRotations.func_195899_a() != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(bodyRotations.func_195899_a()));
        }
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
    }

    public void render(T entity, MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean isUpper, boolean isFemaleModel) {
        Object arms;
        Iterable<ModelRenderer> parts;
        this.bipedBodyChest.field_78806_j = isFemaleModel;
        if (isUpper) {
            parts = this.getUpperParts();
            arms = isFemaleModel ? this.getSlimArms() : this.getArms();
        } else {
            parts = this.getLowerParts();
            arms = ImmutableList.of();
        }
        parts.forEach(m -> m.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
        arms.forEach(m -> m.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public ModelRenderer func_205072_a() {
        return this.bipedHead;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.getArmForSide(sideIn).func_228307_a_(matrixStackIn);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.bipedLeftArm : this.bipedRightArm;
    }
}

