/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.block.StatueBlock;
import greekfantasy.client.render.model.tileentity.CerberusHeadModel;
import greekfantasy.client.render.model.tileentity.GiganteHeadModel;
import greekfantasy.client.render.model.tileentity.OrthusHeadModel;
import greekfantasy.tileentity.MobHeadTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class MobHeadTileEntityRenderer
extends TileEntityRenderer<MobHeadTileEntity> {
    protected Model giganteHeadModel = new GiganteHeadModel();
    protected Model cerberusHeadModel = new CerberusHeadModel();
    protected Model orthusHeadModel = new OrthusHeadModel();

    public MobHeadTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MobHeadTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn) {
        MobHeadTileEntity.HeadType head = tileEntityIn.getHeadType();
        float rotation = ((Direction)tileEntityIn.func_195044_w().func_177229_b((Property)StatueBlock.field_185512_D)).func_185119_l();
        ResourceLocation texture = head.getTexture();
        Model model = this.getModel(head);
        float scale = ((IWallModel)model).getScale();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matrixStackIn.func_227861_a_(0.5 / (double)scale, 0.0, 0.5 / (double)scale);
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture));
        ((IWallModel)model).setWallRotations(tileEntityIn.onWall());
        model.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    protected Model getModel(MobHeadTileEntity.HeadType head) {
        switch (head) {
            case GIGANTE: {
                return this.giganteHeadModel;
            }
            case CERBERUS: {
                return this.cerberusHeadModel;
            }
        }
        return this.orthusHeadModel;
    }

    public static class CerberusItemStackRenderer
    extends ItemStackTileEntityRenderer {
        final CerberusHeadModel cerberusHeadModel = new CerberusHeadModel();

        public void func_239207_a_(ItemStack item, ItemCameraTransforms.TransformType transform, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            IVertexBuilder vertexBuilder = buffer.getBuffer(this.cerberusHeadModel.func_228282_a_(MobHeadTileEntity.HeadType.CERBERUS.getTexture()));
            this.cerberusHeadModel.func_225598_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    public static class GiganteItemStackRenderer
    extends ItemStackTileEntityRenderer {
        final GiganteHeadModel giganteHeadModel = new GiganteHeadModel();

        public void func_239207_a_(ItemStack item, ItemCameraTransforms.TransformType transform, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            IVertexBuilder vertexBuilder = buffer.getBuffer(this.giganteHeadModel.func_228282_a_(MobHeadTileEntity.HeadType.GIGANTE.getTexture()));
            this.giganteHeadModel.func_225598_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    public static class OrthusItemStackRenderer
    extends ItemStackTileEntityRenderer {
        final OrthusHeadModel orthusHeadModel = new OrthusHeadModel();

        public void func_239207_a_(ItemStack item, ItemCameraTransforms.TransformType transform, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            IVertexBuilder vertexBuilder = buffer.getBuffer(this.orthusHeadModel.func_228282_a_(MobHeadTileEntity.HeadType.ORTHUS.getTexture()));
            this.orthusHeadModel.func_225598_a_(matrixStack, vertexBuilder, combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    public static interface IWallModel {
        public float getScale();

        public void setWallRotations(boolean var1);
    }
}

