/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.render.tileentity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import greekfantasy.block.StatueBlock;
import greekfantasy.client.gui.StatueScreen;
import greekfantasy.client.render.model.tileentity.IHasName;
import greekfantasy.client.render.model.tileentity.StatueModel;
import greekfantasy.deity.Deity;
import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.ModelPart;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class StatueTileEntityRenderer
extends TileEntityRenderer<StatueTileEntity>
implements IHasName<StatueTileEntity> {
    protected static final ResourceLocation STEVE_TEXTURE = new ResourceLocation("greekfantasy", "textures/entity/statue/steve.png");
    protected static final ResourceLocation ALEX_TEXTURE = new ResourceLocation("greekfantasy", "textures/entity/statue/alex.png");
    protected StatueModel<StatueTileEntity> model = new StatueModel();

    public StatueTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(StatueTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn) {
        TileEntity tmp;
        Minecraft mc = Minecraft.func_71410_x();
        boolean gui = mc.field_71462_r instanceof StatueScreen;
        boolean upper = tileEntityIn.isUpper();
        StatueTileEntity te = tileEntityIn;
        if (upper && (tmp = tileEntityIn.func_145831_w().func_175625_s(tileEntityIn.func_174877_v().func_177977_b())) instanceof StatueTileEntity) {
            te = (StatueTileEntity)tmp;
        }
        float rotation = ((Direction)te.func_195044_w().func_177229_b((Property)StatueBlock.field_185512_D)).func_185119_l();
        boolean isFemaleModel = te.isStatueFemale();
        float translateY = upper ? 0.95f : 1.95f;
        StatueBlock.StatueMaterial material = te.getStatueMaterial();
        ResourceLocation textureStone = te.hasDeity() ? te.getDeity().getOverlay() : material.getStoneTexture();
        ResourceLocation textureOverlay = this.getOverlayTexture(te);
        matrixStackIn.func_227860_a_();
        if (!gui && this.canRenderName(tileEntityIn)) {
            this.renderName(tileEntityIn, matrixStackIn, bufferIn, packedLightIn);
        }
        if (!upper && !gui) {
            BlockState base = te.hasDeity() ? te.getDeity().getBaseBlock() : material.getBase();
            Minecraft.func_71410_x().func_175602_ab().renderBlock(base, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        }
        matrixStackIn.func_227861_a_(0.5, (double)translateY, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (!gui) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        }
        this.model.setRotationAngles(te, partialTicks);
        this.model.rotateAroundBody(te.getRotations(ModelPart.BODY), matrixStackIn, partialTicks);
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureOverlay));
        if (material.hasSkin()) {
            this.model.render(te, matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, upper, isFemaleModel);
        }
        if (textureStone != null) {
            vertexBuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)textureStone));
            float alpha = 1.0f;
            if (material.hasSkin()) {
                alpha = 0.3f;
                RenderSystem.enableBlend();
                RenderSystem.blendEquation((int)32774);
                RenderSystem.blendFunc((int)770, (int)1);
                RenderSystem.alphaFunc((int)516, (float)0.0f);
            }
            this.model.render(te, matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, 0.8f, 0.8f, 0.8f, alpha, upper, isFemaleModel);
            if (material.hasSkin()) {
                RenderSystem.defaultBlendFunc();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.disableBlend();
            }
        }
        this.renderHeldItems(te, partialTicks, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, upper);
        matrixStackIn.func_227865_b_();
    }

    @Override
    public boolean canRenderName(StatueTileEntity entityIn) {
        return entityIn.isUpper() && IHasName.isWithinDistanceToRenderName(entityIn, 6.0);
    }

    @Override
    public void renderName(StatueTileEntity entityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        IFormattableTextComponent name = null;
        if (entityIn.hasDeity()) {
            name = entityIn.getDeity().getText();
        } else if (!entityIn.getTextureName().isEmpty()) {
            name = new StringTextComponent(entityIn.getTextureName());
        }
        if (name != null) {
            matrixStackIn.func_227860_a_();
            IHasName.renderNameplate(entityIn, (ITextComponent)name, 1.9f, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    protected ResourceLocation getOverlayTexture(StatueTileEntity te) {
        Minecraft minecraft;
        Map map;
        if (te.getDeity() != Deity.EMPTY) {
            return te.getDeity().getTexture();
        }
        GameProfile gameProfile = te.getPlayerProfile();
        boolean isFemale = te.isStatueFemale();
        if (gameProfile != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(gameProfile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return isFemale ? ALEX_TEXTURE : STEVE_TEXTURE;
    }

    protected void renderHeldItems(StatueTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, boolean upper) {
        if (upper) {
            ItemStack itemstackRight = tileEntityIn.getItem(HandSide.RIGHT);
            ItemStack itemstackLeft = tileEntityIn.getItem(HandSide.LEFT);
            if (!itemstackLeft.func_190926_b() || !itemstackRight.func_190926_b()) {
                matrixStackIn.func_227860_a_();
                this.renderItem(tileEntityIn, itemstackRight, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
                this.renderItem(tileEntityIn, itemstackLeft, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    protected void renderItem(StatueTileEntity tileEntity, ItemStack stack, ItemCameraTransforms.TransformType transform, HandSide handSide, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn) {
        matrixStackIn.func_227860_a_();
        this.model.func_225599_a_(handSide, matrixStackIn);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        boolean flag = handSide == HandSide.LEFT;
        matrixStackIn.func_227861_a_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
        Minecraft.func_71410_x().func_175599_af().func_229109_a_(null, stack, transform, flag, matrixStackIn, bufferIn, tileEntity.func_145831_w(), packedLightIn, packedOverlayIn);
        matrixStackIn.func_227865_b_();
    }
}

