/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.crafting;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class SalveRecipe
extends ShapelessRecipe {
    public static final String CATEGORY = "salve";
    private static final String KEY_RESULT_TAG = "result_tag";
    private final CompoundNBT resultTag;

    public SalveRecipe(ResourceLocation idIn, ItemStack resultIn, CompoundNBT resultTagIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, CATEGORY, resultIn, recipeItemsIn);
        this.resultTag = resultTagIn;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack result = super.func_77572_b(inv);
        if (this.resultTag != null) {
            result.func_77982_d(this.resultTag);
        }
        return result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return GFRegistry.SALVE_RECIPE_SERIALIZER;
    }

    public CompoundNBT getResultTag() {
        return this.resultTag;
    }

    public static class Factory
    extends ShapelessRecipe.Serializer {
        public ShapelessRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            CompoundNBT tag;
            ShapelessRecipe recipe = super.func_199425_a_(recipeId, json);
            String tagString = JSONUtils.func_151200_h((JsonObject)json, (String)SalveRecipe.KEY_RESULT_TAG);
            try {
                tag = JsonToNBT.func_180713_a((String)tagString);
            }
            catch (CommandSyntaxException e) {
                GreekFantasy.LOGGER.error("Failed to parse compound tag \"" + tagString + "\" in recipe with id " + recipeId);
                tag = new CompoundNBT();
            }
            return new SalveRecipe(recipeId, recipe.func_77571_b(), tag, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public ShapelessRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = super.func_199426_a_(recipeId, buffer);
            CompoundNBT tag = buffer.func_150793_b();
            return new SalveRecipe(recipeId, recipe.func_77571_b(), tag, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public void func_199427_a_(PacketBuffer buffer, ShapelessRecipe recipeIn) {
            super.func_199427_a_(buffer, recipeIn);
            SalveRecipe recipe = (SalveRecipe)recipeIn;
            buffer.func_150786_a(recipe.getResultTag());
        }
    }
}

