/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor_effect.FavorEffect;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.deity.favor_effect.TriggeredFavorEffect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Deity
implements IDeity {
    public static final Deity EMPTY = new Deity(new ResourceLocation("greekfantasy", "null"), false, false, ItemStack.field_190927_a, ItemStack.field_190927_a, new ResourceLocation("greekfantasy", "null"), "none", Arrays.asList(new FavorEffect[0]), Arrays.asList(new TriggeredFavorEffect[0]), Arrays.asList(new SpecialFavorEffect[0]), Maps.newHashMap(), Maps.newHashMap());
    public static final Codec<Deity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("name").forGetter(Deity::getName), (App)Codec.BOOL.fieldOf("enabled").forGetter(Deity::isEnabled), (App)Codec.BOOL.optionalFieldOf("female", (Object)false).forGetter(Deity::isFemale), (App)ItemStack.field_234691_a_.optionalFieldOf("left_hand", (Object)ItemStack.field_190927_a).forGetter(Deity::getLeftHandItem), (App)ItemStack.field_234691_a_.optionalFieldOf("right_hand", (Object)ItemStack.field_190927_a).forGetter(Deity::getRightHandItem), (App)ResourceLocation.field_240908_a_.optionalFieldOf("base", (Object)new ResourceLocation("greekfantasy", "polished_marble_slab")).forGetter(Deity::getBase), (App)Codec.STRING.optionalFieldOf("overlay", (Object)"none").forGetter(Deity::getOverlayString), (App)FavorEffect.CODEC.listOf().optionalFieldOf("effects", Arrays.asList(new FavorEffect[0])).forGetter(Deity::getFavorEffects), (App)TriggeredFavorEffect.CODEC.listOf().optionalFieldOf("triggered_effects", Arrays.asList(new TriggeredFavorEffect[0])).forGetter(Deity::getTriggeredFavorEffects), (App)SpecialFavorEffect.CODEC.listOf().optionalFieldOf("special_effects", (Object)Lists.newArrayList()).forGetter(Deity::getSpecialFavorEffects), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.INT).optionalFieldOf("kill_favor_map", (Object)Maps.newHashMap()).forGetter(Deity::getKillFavorModifiers), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.INT).optionalFieldOf("item_favor_map", (Object)Maps.newHashMap()).forGetter(Deity::getItemFavorModifiers)).apply((Applicative)instance, Deity::new));
    private final ResourceLocation name;
    private final ResourceLocation texture;
    private final boolean isEnabled;
    private final boolean isFemale;
    private final ItemStack leftHandItem;
    private final ItemStack rightHandItem;
    private final ResourceLocation base;
    private final ResourceLocation overlay;
    private final String overlayString;
    private final Map<ResourceLocation, Integer> killFavorMap;
    private final Map<ResourceLocation, Integer> itemFavorMap;
    private final List<FavorEffect> favorEffects;
    private final List<TriggeredFavorEffect> triggeredFavorEffects;
    private final List<SpecialFavorEffect> specialFavorEffects;

    private Deity(ResourceLocation lName, boolean lIsEnabled, boolean lIsFemale, ItemStack lLeftHandItem, ItemStack lRightHandItem, ResourceLocation lBase, String lOverlay, List<FavorEffect> lFavorEffects, List<TriggeredFavorEffect> lTriggeredFavorEffects, List<SpecialFavorEffect> lSpecialFavorEffects, Map<ResourceLocation, Integer> lKillFavorMap, Map<ResourceLocation, Integer> lItemFavorMap) {
        this.name = lName;
        this.texture = new ResourceLocation(lName.func_110624_b(), "textures/deity/" + lName.func_110623_a() + ".png");
        this.killFavorMap = ImmutableMap.copyOf(lKillFavorMap);
        this.itemFavorMap = ImmutableMap.copyOf(lItemFavorMap);
        this.favorEffects = ImmutableList.copyOf(lFavorEffects);
        this.triggeredFavorEffects = ImmutableList.copyOf(lTriggeredFavorEffects);
        this.specialFavorEffects = ImmutableList.copyOf(lSpecialFavorEffects);
        this.isFemale = lIsFemale;
        this.isEnabled = lIsEnabled;
        this.leftHandItem = lLeftHandItem;
        this.rightHandItem = lRightHandItem;
        this.base = lBase;
        this.overlayString = lOverlay;
        this.overlay = this.makeOverlay(lOverlay);
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isFemale() {
        return this.isFemale;
    }

    @Override
    public ItemStack getRightHandItem() {
        return this.rightHandItem;
    }

    @Override
    public ItemStack getLeftHandItem() {
        return this.leftHandItem;
    }

    @Override
    public ResourceLocation getBase() {
        return this.base;
    }

    @Override
    public String getOverlayString() {
        return this.overlayString;
    }

    @Override
    public ResourceLocation getOverlay() {
        return this.overlay;
    }

    @Override
    public Map<ResourceLocation, Integer> getKillFavorModifiers() {
        return this.killFavorMap;
    }

    @Override
    public Map<ResourceLocation, Integer> getItemFavorModifiers() {
        return this.itemFavorMap;
    }

    @Override
    public List<FavorEffect> getFavorEffects() {
        return this.favorEffects;
    }

    @Override
    public List<TriggeredFavorEffect> getTriggeredFavorEffects() {
        return this.triggeredFavorEffects;
    }

    @Override
    public List<SpecialFavorEffect> getSpecialFavorEffects() {
        return this.specialFavorEffects;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Deity:");
        b.append(" name[").append(this.name.toString()).append("]");
        b.append(" leftHand[").append(this.leftHandItem.toString()).append("]");
        b.append(" rightHand[").append(this.rightHandItem.toString()).append("]");
        b.append(" enabled[").append(this.isEnabled).append("]");
        b.append(" female[").append(this.isFemale).append("]");
        return b.toString();
    }
}

