/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import greekfantasy.GreekFantasy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class DeityArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES;
    public static final DynamicCommandExceptionType DEITY_UNKNOWN;
    private static final Collection<ResourceLocation> SUGGESTIONS;

    public static DeityArgument deity() {
        return new DeityArgument();
    }

    public static ResourceLocation getDeityId(CommandContext<CommandSource> source, String string) throws CommandSyntaxException {
        return DeityArgument.checkIfDeityExists((ResourceLocation)source.getArgument(string, ResourceLocation.class));
    }

    private static ResourceLocation checkIfDeityExists(ResourceLocation id) throws CommandSyntaxException {
        GreekFantasy.PROXY.DEITY.get(id).orElseThrow(() -> DEITY_UNKNOWN.create((Object)id));
        return id;
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation parsed = ResourceLocation.func_195826_a((StringReader)reader);
        return DeityArgument.checkIfDeityExists("minecraft".equals(parsed.func_110624_b()) ? new ResourceLocation("greekfantasy", parsed.func_110623_a()) : parsed);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        GreekFantasy.PROXY.DEITY.getKeys().forEach(r -> {
            if (!SUGGESTIONS.contains(r)) {
                SUGGESTIONS.add((ResourceLocation)r);
            }
        });
        return ISuggestionProvider.func_197014_a(SUGGESTIONS, (SuggestionsBuilder)p_listSuggestions_2_);
    }

    static {
        String[] names;
        EXAMPLES = Arrays.asList("greekfantasy:zeus", "hades");
        DEITY_UNKNOWN = new DynamicCommandExceptionType(o -> new TranslationTextComponent("commands.deity.not_found", new Object[]{o}));
        SUGGESTIONS = new ArrayList<ResourceLocation>();
        for (String s : names = new String[]{"aphrodite", "apollo", "ares", "artemis", "athena", "demeter", "dionysus", "hades", "hecate", "hephaestus", "hera", "hermes", "hestia", "persephone", "poseidon", "zeus"}) {
            SUGGESTIONS.add(new ResourceLocation("greekfantasy", s));
        }
    }
}

