/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity;

import greekfantasy.GFRegistry;
import greekfantasy.block.StatueBlock;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.FavorEffect;
import greekfantasy.deity.favor_effect.FavorEffectTrigger;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.deity.favor_effect.TriggeredFavorEffect;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public interface IDeity {
    public ResourceLocation getName();

    default public IFormattableTextComponent getText() {
        ResourceLocation name = this.getName();
        return new TranslationTextComponent("deity." + name.func_110624_b() + "." + name.func_110623_a());
    }

    public ResourceLocation getTexture();

    public Map<ResourceLocation, Integer> getKillFavorModifiers();

    default public boolean hasKillFavorModifier(EntityType<?> entity) {
        return this.getKillFavorModifiers().containsKey(entity.getRegistryName());
    }

    default public int getKillFavorModifier(EntityType<?> entity) {
        return this.getKillFavorModifiers().getOrDefault(entity.getRegistryName(), 0);
    }

    public Map<ResourceLocation, Integer> getItemFavorModifiers();

    default public boolean hasItemFavorModifier(Item item) {
        return this.getItemFavorModifiers().containsKey(item.getRegistryName());
    }

    default public int getItemFavorModifier(Item item) {
        return this.getItemFavorModifiers().getOrDefault(item.getRegistryName(), 0);
    }

    public List<FavorEffect> getFavorEffects();

    public List<TriggeredFavorEffect> getTriggeredFavorEffects();

    public List<SpecialFavorEffect> getSpecialFavorEffects();

    default public List<ConfiguredSpecialFavorEffect> getSpecialFavorEffects(SpecialFavorEffect.Type type) {
        return this.getSpecialFavorEffects().stream().filter(e -> e.getType() == type).map(f -> new ConfiguredSpecialFavorEffect(this, (SpecialFavorEffect)f)).collect(Collectors.toList());
    }

    default public FavorEffect getRandomEffect(Random rand, int playerLevel) {
        List<FavorEffect> effects = this.getFavorEffects();
        if (!effects.isEmpty()) {
            int tries = Math.min(effects.size(), 10);
            while (tries-- >= 0) {
                FavorEffect effect = effects.get(rand.nextInt(effects.size()));
                if (!effect.isInRange(playerLevel)) continue;
                return effect;
            }
        }
        return FavorEffect.EMPTY;
    }

    default public TriggeredFavorEffect getTriggeredFavorEffect(Random rand, FavorEffectTrigger.Type type, ResourceLocation data, int playerLevel) {
        List<TriggeredFavorEffect> effects = this.getTriggeredFavorEffects();
        if (!effects.isEmpty()) {
            int tries = Math.min(effects.size(), 10);
            while (tries-- > 0) {
                TriggeredFavorEffect effect = effects.get(rand.nextInt(effects.size()));
                if (effect.getTrigger().getType() != type || !data.equals((Object)effect.getTrigger().getData()) || !effect.getEffect().isInRange(playerLevel) || !(rand.nextFloat() < effect.getAdjustedChance(playerLevel))) continue;
                return effect;
            }
        }
        return TriggeredFavorEffect.EMPTY;
    }

    public boolean isEnabled();

    public boolean isFemale();

    public ItemStack getRightHandItem();

    public ItemStack getLeftHandItem();

    public ResourceLocation getBase();

    public String getOverlayString();

    public ResourceLocation getOverlay();

    @Nullable
    default public ResourceLocation makeOverlay(String overlay) {
        if ("none".equals(overlay)) {
            return null;
        }
        return StatueBlock.StatueMaterial.getByName(overlay).getStoneTexture();
    }

    default public BlockState getBaseBlock() {
        Block b = GFRegistry.POLISHED_MARBLE_SLAB;
        if (ForgeRegistries.BLOCKS.containsKey(this.getBase())) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(this.getBase());
        }
        return b.func_176223_P();
    }
}

