/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor;

import greekfantasy.GreekFantasy;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.IFavor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class Favor
implements IFavor {
    protected final Map<ResourceLocation, FavorLevel> favorMap = new HashMap<ResourceLocation, FavorLevel>();
    private boolean enabled = true;
    private long effectTimestamp;
    private long effectCooldown = 1000L;
    private long triggeredTimestamp;
    private long triggeredCooldown = 100L;

    @Override
    public FavorLevel getFavor(ResourceLocation deity) {
        if (this.favorMap.containsKey(deity)) {
            return this.favorMap.get(deity);
        }
        FavorLevel favorLevel = new FavorLevel(0L);
        this.favorMap.put(deity, favorLevel);
        return favorLevel;
    }

    @Override
    public void setFavor(ResourceLocation deity, FavorLevel favorLevel) {
        this.favorMap.put(deity, favorLevel);
    }

    @Override
    public Map<ResourceLocation, FavorLevel> getAllFavor() {
        return this.favorMap;
    }

    @Override
    public boolean isEnabled() {
        return GreekFantasy.CONFIG.isFavorEnabled() && this.enabled;
    }

    @Override
    public void setEnabled(boolean enabledIn) {
        this.enabled = enabledIn;
    }

    @Override
    public long getEffectTimestamp() {
        return this.effectTimestamp;
    }

    @Override
    public void setEffectTimestamp(long timestamp) {
        this.effectTimestamp = timestamp;
    }

    @Override
    public long getEffectCooldown() {
        return this.effectCooldown;
    }

    @Override
    public void setEffectCooldown(long cooldown) {
        this.effectCooldown = cooldown;
    }

    @Override
    public long getTriggeredTimestamp() {
        return this.triggeredTimestamp;
    }

    @Override
    public void setTriggeredTimestamp(long timestamp) {
        this.triggeredTimestamp = timestamp;
    }

    @Override
    public long getTriggeredCooldown() {
        return this.triggeredCooldown;
    }

    @Override
    public void setTriggeredCooldown(long cooldown) {
        this.triggeredCooldown = cooldown;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Favor:");
        b.append(" enabled[").append(this.enabled).append("]");
        b.append(" effectTimestamp[").append(this.effectTimestamp).append("]");
        b.append(" effectCooldown[").append(this.effectCooldown).append("]");
        b.append(" triggeredTimestamp[").append(this.triggeredTimestamp).append("]");
        b.append(" triggeredCooldown[").append(this.triggeredCooldown).append("]");
        b.append("\nfavorMap[").append(this.getAllFavor().toString()).append("]");
        return b.toString();
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public IFavor instance = (IFavor)GreekFantasy.FAVOR.getDefaultInstance();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == GreekFantasy.FAVOR ? GreekFantasy.FAVOR.orEmpty(cap, LazyOptional.of(() -> this.instance)) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)GreekFantasy.FAVOR.getStorage().writeNBT(GreekFantasy.FAVOR, (Object)this.instance, null);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            GreekFantasy.FAVOR.getStorage().readNBT(GreekFantasy.FAVOR, (Object)this.instance, null, (INBT)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IFavor> {
        public INBT writeNBT(Capability<IFavor> capability, IFavor instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IFavor> capability, IFavor instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((CompoundNBT)nbt);
            } else {
                GreekFantasy.LOGGER.error("Failed to read Favor capability from NBT of type " + (nbt != null ? nbt.func_225647_b_().func_225648_a_() : "null"));
            }
        }
    }
}

