/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.DeityArgument;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.event.FavorChangedEvent;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FavorCommand {
    private static final DynamicCommandExceptionType FAVOR_DISABLED_EXCEPTION = new DynamicCommandExceptionType(o -> new TranslationTextComponent("commands.favor.enabled.disabled", new Object[]{o}));

    public static void register(CommandDispatcher<CommandSource> commandSource) {
        LiteralCommandNode commandNode = commandSource.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"favor").requires(p -> p.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"deity", (ArgumentType)DeityArgument.deity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> FavorCommand.addFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.LEVELS))).then(Commands.func_197057_a((String)"points").executes(command -> FavorCommand.addFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.POINTS)))).then(Commands.func_197057_a((String)"levels").executes(command -> FavorCommand.addFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.LEVELS)))))))).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"deity", (ArgumentType)DeityArgument.deity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> FavorCommand.setFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.LEVELS))).then(Commands.func_197057_a((String)"points").executes(command -> FavorCommand.setFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.POINTS)))).then(Commands.func_197057_a((String)"levels").executes(command -> FavorCommand.setFavor((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"), Type.LEVELS)))))).then(Commands.func_197057_a((String)"enabled").then(Commands.func_197056_a((String)"flag", (ArgumentType)BoolArgumentType.bool()).executes(command -> FavorCommand.setEnabled((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), BoolArgumentType.getBool((CommandContext)command, (String)"flag")))))).then(Commands.func_197057_a((String)"cooldown").then(Commands.func_197056_a((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(command -> FavorCommand.setCooldown((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), LongArgumentType.getLong((CommandContext)command, (String)"amount")))))))).then(Commands.func_197057_a((String)"query").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"deity", (ArgumentType)DeityArgument.deity()).executes(command -> FavorCommand.queryFavor((CommandSource)command.getSource(), EntityArgument.func_197089_d((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), Type.LEVELS))).then(Commands.func_197057_a((String)"points").executes(command -> FavorCommand.queryFavor((CommandSource)command.getSource(), EntityArgument.func_197089_d((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), Type.POINTS)))).then(Commands.func_197057_a((String)"levels").executes(command -> FavorCommand.queryFavor((CommandSource)command.getSource(), EntityArgument.func_197089_d((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), Type.LEVELS))))).then(Commands.func_197057_a((String)"enabled").executes(command -> FavorCommand.queryEnabled((CommandSource)command.getSource(), EntityArgument.func_197089_d((CommandContext)command, (String)"target"))))))).then(Commands.func_197057_a((String)"cap").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"deity", (ArgumentType)DeityArgument.deity()).then(Commands.func_197056_a((String)"min", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"max", (ArgumentType)IntegerArgumentType.integer()).executes(command -> FavorCommand.setCap((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"min"), IntegerArgumentType.getInteger((CommandContext)command, (String)"max"), Type.LEVELS))).then(Commands.func_197057_a((String)"points").executes(command -> FavorCommand.setCap((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"min"), IntegerArgumentType.getInteger((CommandContext)command, (String)"max"), Type.POINTS)))).then(Commands.func_197057_a((String)"levels").executes(command -> FavorCommand.setCap((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"target"), DeityArgument.getDeityId((CommandContext<CommandSource>)command, "deity"), IntegerArgumentType.getInteger((CommandContext)command, (String)"min"), IntegerArgumentType.getInteger((CommandContext)command, (String)"max"), Type.LEVELS)))))))));
        commandSource.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"favor").requires(p -> p.func_197034_c(2))).redirect((CommandNode)commandNode));
    }

    private static int queryFavor(CommandSource source, ServerPlayerEntity player, ResourceLocation deity, Type type) throws CommandSyntaxException {
        IDeity ideity = GreekFantasy.PROXY.DEITY.get(deity).orElse(Deity.EMPTY);
        IFavor favor = (IFavor)player.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance());
        if (!favor.isEnabled()) {
            throw FAVOR_DISABLED_EXCEPTION.create((Object)player.func_145748_c_());
        }
        int amount = type.favorGetter.accept(player, favor, ideity, 0);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.query." + type.name, new Object[]{player.func_145748_c_(), amount, ideity.getText()}), false);
        return amount;
    }

    private static int setFavor(CommandSource source, Collection<? extends ServerPlayerEntity> players, ResourceLocation deity, int amount, Type type) throws CommandSyntaxException {
        IDeity ideity = GreekFantasy.PROXY.DEITY.get(deity).orElse(Deity.EMPTY);
        for (ServerPlayerEntity serverPlayerEntity : players) {
            IFavor favor = (IFavor)serverPlayerEntity.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (!favor.isEnabled()) {
                throw FAVOR_DISABLED_EXCEPTION.create((Object)serverPlayerEntity.func_145748_c_());
            }
            type.favorSetter.accept(serverPlayerEntity, favor, ideity, amount);
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.set." + type.name + ".success.single", new Object[]{amount, ideity.getText(), players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.set." + type.name + ".success.multiple", new Object[]{amount, ideity.getText(), players.size()}), true);
        }
        return players.size();
    }

    private static int addFavor(CommandSource source, Collection<? extends ServerPlayerEntity> players, ResourceLocation deity, int amount, Type type) throws CommandSyntaxException {
        IDeity ideity = GreekFantasy.PROXY.DEITY.get(deity).orElse(Deity.EMPTY);
        for (ServerPlayerEntity serverPlayerEntity : players) {
            IFavor favor = (IFavor)serverPlayerEntity.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (!favor.isEnabled()) {
                throw FAVOR_DISABLED_EXCEPTION.create((Object)serverPlayerEntity.func_145748_c_());
            }
            type.favorAdder.accept(serverPlayerEntity, favor, ideity, amount);
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.add." + type.name + ".success.single", new Object[]{amount, ideity.getText(), players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.add." + type.name + ".success.multiple", new Object[]{amount, ideity.getText(), players.size()}), true);
        }
        return players.size();
    }

    private static int setEnabled(CommandSource source, Collection<? extends ServerPlayerEntity> players, boolean enabled) {
        String sub;
        for (ServerPlayerEntity serverPlayerEntity : players) {
            ((IFavor)serverPlayerEntity.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance())).setEnabled(enabled);
        }
        String string = sub = enabled ? "enabled" : "disabled";
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor." + sub + ".success.single", new Object[]{players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor." + sub + ".success.multiple", new Object[]{players.size()}), true);
        }
        return 0;
    }

    private static int queryEnabled(CommandSource source, ServerPlayerEntity player) {
        boolean enabled = ((IFavor)player.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance())).isEnabled();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.enabled." + (enabled ? "enabled" : "disabled"), new Object[]{player.func_145748_c_()}), true);
        return enabled ? 1 : 0;
    }

    private static int setCooldown(CommandSource source, Collection<? extends ServerPlayerEntity> players, long cooldown) throws CommandSyntaxException {
        for (ServerPlayerEntity serverPlayerEntity : players) {
            long time = IFavor.calculateTime((Entity)serverPlayerEntity);
            IFavor favor = (IFavor)serverPlayerEntity.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (!favor.isEnabled()) {
                throw FAVOR_DISABLED_EXCEPTION.create((Object)serverPlayerEntity.func_145748_c_());
            }
            favor.setEffectTime(time, cooldown);
            favor.setTriggeredTime(time, cooldown);
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.cooldown.success.single", new Object[]{cooldown, players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.cooldown.success.multiple", new Object[]{cooldown, players.size()}), true);
        }
        return players.size();
    }

    private static int setCap(CommandSource source, Collection<ServerPlayerEntity> players, ResourceLocation deity, int min, int max, Type type) throws CommandSyntaxException {
        IDeity ideity = GreekFantasy.PROXY.DEITY.get(deity).orElse(Deity.EMPTY);
        int actualMin = Math.min(min, max);
        int actualMax = Math.max(min, max);
        for (ServerPlayerEntity player : players) {
            IFavor favor = (IFavor)player.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance());
            if (!favor.isEnabled()) {
                throw FAVOR_DISABLED_EXCEPTION.create((Object)player.func_145748_c_());
            }
            type.favorCapper.accept(player, favor, ideity, actualMin, actualMax);
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.cap." + type.name + ".success.single", new Object[]{actualMin, actualMax, ideity.getText(), players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.favor.cap." + type.name + ".success.multiple", new Object[]{actualMin, actualMax, ideity.getText(), players.size()}), true);
        }
        return players.size();
    }

    @FunctionalInterface
    private static interface IXFavorFunction {
        public int accept(ServerPlayerEntity var1, IFavor var2, IDeity var3, int var4, int var5);
    }

    @FunctionalInterface
    private static interface IFavorFunction {
        public int accept(ServerPlayerEntity var1, IFavor var2, IDeity var3, int var4);
    }

    static enum Type {
        POINTS("points", (p, f, d, a) -> (int)f.getFavor(d).getFavor(), (p, f, d, a) -> {
            f.getFavor(d).setFavor((PlayerEntity)p, d, a, FavorChangedEvent.Source.COMMAND);
            return a;
        }, (p, f, d, a) -> {
            f.getFavor(d).addFavor((PlayerEntity)p, d, a, FavorChangedEvent.Source.COMMAND);
            return a;
        }, (p, f, d, a1, a2) -> {
            f.getFavor(d).setLevelBounds(FavorLevel.calculateLevel(a1), FavorLevel.calculateLevel(a2));
            return a2 - a1;
        }),
        LEVELS("levels", (p, f, d, a) -> f.getFavor(d).getLevel(), (p, f, d, a) -> {
            f.getFavor(d).setFavor((PlayerEntity)p, d, FavorLevel.calculateFavor(a), FavorChangedEvent.Source.COMMAND);
            return a;
        }, (p, f, d, a) -> {
            f.getFavor(d).addFavor((PlayerEntity)p, d, FavorLevel.calculateFavor(a) + (long)Math.signum(a), FavorChangedEvent.Source.COMMAND);
            return a;
        }, (p, f, d, a1, a2) -> {
            f.getFavor(d).setLevelBounds(a1, a2);
            return a2 - a1;
        });

        public final String name;
        public final IFavorFunction favorGetter;
        public final IFavorFunction favorSetter;
        public final IFavorFunction favorAdder;
        public final IXFavorFunction favorCapper;

        private Type(String key, IFavorFunction getter, IFavorFunction setter, IFavorFunction adder, IXFavorFunction capper) {
            this.name = key;
            this.favorGetter = getter;
            this.favorSetter = setter;
            this.favorAdder = adder;
            this.favorCapper = capper;
        }
    }
}

