/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor;

import greekfantasy.deity.IDeity;
import greekfantasy.event.FavorChangedEvent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;

public class FavorLevel
implements INBTSerializable<CompoundNBT> {
    public static final int MAX_FAVOR_LEVEL = 10;
    public static final long MAX_FAVOR_POINTS = FavorLevel.calculateFavor(11) - 1L;
    public static final String FAVOR = "Favor";
    public static final String MIN_LEVEL = "MinLevel";
    public static final String MAX_LEVEL = "MaxLevel";
    private long favor;
    private int level;
    private int minLevel = -10;
    private int maxLevel = 10;

    public FavorLevel(long f) {
        this(f, -10, 10);
    }

    public FavorLevel(long f, int min, int max) {
        this.setFavor(f);
    }

    public FavorLevel(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public void setFavor(long favorIn) {
        this.favor = FavorLevel.clamp(favorIn, FavorLevel.calculateFavor(this.minLevel - 1) + 1L, FavorLevel.calculateFavor(this.maxLevel + 1) - 1L);
        this.level = FavorLevel.calculateLevel(this.favor);
    }

    public long getFavor() {
        return this.favor;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public long setFavor(PlayerEntity playerIn, IDeity deityIn, long newFavor, FavorChangedEvent.Source source) {
        FavorChangedEvent event = new FavorChangedEvent(playerIn, deityIn, this.favor, newFavor, source);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.setFavor(event.getNewFavor());
        return this.favor;
    }

    public long addFavor(PlayerEntity playerIn, IDeity deityIn, long toAdd, FavorChangedEvent.Source source) {
        return this.setFavor(playerIn, deityIn, this.favor + toAdd, source);
    }

    public long depleteFavor(PlayerEntity playerIn, IDeity deityIn, long toRemove, FavorChangedEvent.Source source) {
        return this.addFavor(playerIn, deityIn, Math.min(Math.abs(this.favor), Math.abs(toRemove)) * -1L * (long)Math.signum(this.favor), source);
    }

    public void setLevelBounds(int min, int max) {
        this.minLevel = min;
        this.maxLevel = max;
        this.setFavor(this.favor);
    }

    public long getFavorToNextLevel() {
        return this.level == this.minLevel || this.level == this.maxLevel ? 0L : FavorLevel.calculateFavor(this.level + (int)Math.signum(this.favor));
    }

    public double getPercentFavor() {
        return Math.abs((double)this.favor / (0.1 + (double)FavorLevel.calculateFavor(this.maxLevel) - (double)FavorLevel.calculateFavor(this.minLevel)));
    }

    public int compareToAbs(FavorLevel other) {
        return (int)(Math.abs(this.getFavor()) - Math.abs(other.getFavor()));
    }

    public void sendStatusMessage(PlayerEntity playerIn, IDeity deity) {
        long favorToNext = Math.min(FavorLevel.calculateFavor(this.maxLevel), this.getFavorToNextLevel());
        playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("favor.current_favor", new Object[]{deity.getText(), this.getFavor(), favorToNext == 0L ? "--" : Long.valueOf(favorToNext), this.getLevel()}).func_240699_a_(TextFormatting.LIGHT_PURPLE), false);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a(FAVOR, this.favor);
        nbt.func_74768_a(MIN_LEVEL, this.minLevel);
        nbt.func_74768_a(MAX_LEVEL, this.maxLevel);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.minLevel = nbt.func_74762_e(MIN_LEVEL);
        this.maxLevel = nbt.func_74762_e(MAX_LEVEL);
        this.setFavor(nbt.func_74763_f(FAVOR));
    }

    public String toString() {
        return this.favor + " (" + this.level + ") range[" + this.minLevel + "," + this.maxLevel + "]";
    }

    public static int calculateLevel(long favorIn) {
        long f = Math.abs(favorIn);
        int sig = (int)Math.signum(favorIn + 1L);
        return sig * Math.floorDiv(-100 + (int)Math.sqrt(10000L + 40L * f), 20);
    }

    public static long calculateFavor(int lv) {
        int l = Math.abs(lv);
        int sig = (int)Math.signum(lv);
        return sig * (10 * l * (l + 10));
    }

    private static long clamp(long num, long min, long max) {
        if (num <= min) {
            return min;
        }
        if (num >= max) {
            return max;
        }
        return num;
    }
}

