/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor;

import com.google.common.collect.Lists;
import greekfantasy.GFRegistry;
import greekfantasy.GFWorldSavedData;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorConfiguration;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.FavorEffectManager;
import greekfantasy.deity.favor_effect.FavorEffectTrigger;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import greekfantasy.entity.MakhaiEntity;
import greekfantasy.event.FavorChangedEvent;
import greekfantasy.network.SSimpleParticlesPacket;
import greekfantasy.tileentity.StatueTileEntity;
import greekfantasy.util.BiomeWhitelistConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Dimension;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class FavorManager {
    public static void onPlayerKilled(PlayerEntity player, Entity source, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.ENTITY_KILLED_PLAYER, source.func_200600_R().getRegistryName(), player, favor);
    }

    public static void onPlayerHurt(PlayerEntity player, Entity source, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.ENTITY_HURT_PLAYER, source.func_200600_R().getRegistryName(), player, favor);
        if (player.func_110142_aN().func_180134_f() < 40) {
            FavorManager.onCombatStart(player, source, favor);
        }
    }

    public static void onBreakBlock(PlayerEntity player, Block block, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.PLAYER_BREAK_BLOCK, block.getRegistryName(), player, favor);
    }

    public static void onAddPotion(PlayerEntity player, EffectInstance effect, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.EFFECTS_CHANGED, effect.func_188419_a().getRegistryName(), player, favor);
        long time = IFavor.calculateTime((Entity)player);
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        if (player.field_70173_aa > 10 && favor.hasNoTriggeredCooldown(time)) {
            float lengthMultiplier = 0.0f;
            long cooldown = -1L;
            for (ConfiguredSpecialFavorEffect favorEffect : favorConfig.getSpecials(SpecialFavorEffect.Type.POTION_BONUS_LENGTH)) {
                if (!favorEffect.canApply(player, favor)) continue;
                lengthMultiplier += favorEffect.getEffect().getMultiplier().get().floatValue();
                cooldown = Math.max(cooldown, favorEffect.getEffect().getRandomCooldown(player.func_70681_au()));
            }
            if (cooldown > 0L) {
                int length = effect.func_76459_b() + Math.round((float)effect.func_76459_b() * lengthMultiplier);
                effect.func_199308_a(new EffectInstance(effect.func_188419_a(), length, effect.func_76458_c()));
                favor.setTriggeredTime(time, cooldown);
            }
        }
        if (player.field_70173_aa > 10 && favor.hasNoTriggeredCooldown(time)) {
            long cooldown = -1L;
            for (ConfiguredSpecialFavorEffect favorEffect : favorConfig.getSpecials(SpecialFavorEffect.Type.POTION_BONUS_EFFECT)) {
                if (!favorEffect.canApply(player, favor)) continue;
                cooldown = Math.max(cooldown, favorEffect.getEffect().getRandomCooldown(player.func_70681_au()));
                favorEffect.getEffect().getPotionEffect().ifPresent(e -> player.func_195064_c(e));
            }
            if (cooldown > 0L) {
                favor.setTriggeredTime(time, cooldown);
            }
        }
    }

    public static void onPlayerTick(PlayerEntity player, IFavor favor) {
        GFWorldSavedData data;
        long cooldown;
        if (!favor.isEnabled()) {
            return;
        }
        long time = IFavor.calculateTime((Entity)player);
        if (player.field_70173_aa > 10 && GreekFantasy.CONFIG.doesFavorDecrease() && time % GreekFantasy.CONFIG.getFavorDecreaseInterval() == 0L) {
            favor.forEach((d, f) -> f.depleteFavor(player, (IDeity)d, 1 + Math.abs(f.getLevel()), FavorChangedEvent.Source.PASSIVE), true);
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && player.field_70173_aa > 10 && time % 45L == 0L && favor.hasNoEffectCooldown(time)) {
            ArrayList entryList = Lists.newArrayList(favor.getAllFavor().entrySet());
            Collections.shuffle(entryList, player.func_70681_au());
            for (Map.Entry entry : entryList) {
                long cooldown2;
                Optional<Deity> deity = GreekFantasy.PROXY.DEITY.get((ResourceLocation)entry.getKey());
                FavorLevel info = (FavorLevel)entry.getValue();
                if (!deity.isPresent() || !deity.get().isEnabled() || !(player.func_70681_au().nextDouble() * 0.7 < info.getPercentFavor()) || (cooldown2 = FavorEffectManager.onFavorEffect(player.func_130014_f_(), player, deity.get(), favor, info)) <= 0L) continue;
                favor.setEffectTime(time, cooldown2);
                break;
            }
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && player.field_70173_aa > 10 && time % 50L == 0L && favor.hasNoTriggeredCooldown(time) && (cooldown = FavorManager.onNearCrops(player, favor)) > 0L) {
            favor.setTriggeredTime(time, cooldown);
        }
        if (GreekFantasy.CONFIG.isFlyingEnabled() && player.func_130014_f_() instanceof ServerWorld && !player.func_184812_l_() && !player.func_175149_v() && player.field_70173_aa > 10 && time % 11L == 0L && (data = GFWorldSavedData.getOrCreate((ServerWorld)player.func_130014_f_())).hasFlyingPlayer(player) && !GFWorldSavedData.validatePlayer(player, favor)) {
            data.removeFlyingPlayer(player);
        }
        if (GreekFantasy.CONFIG.isPrisonerEnabled() && player.func_70660_b(GFRegistry.PRISONER_EFFECT) != null) {
            Optional<Deity> hades = GreekFantasy.PROXY.DEITY.get(new ResourceLocation("greekfantasy", "hades"));
            if (!Dimension.field_236054_c_.equals(player.func_130014_f_().func_234923_W_())) {
                player.func_184596_c(GFRegistry.PRISONER_EFFECT);
            } else if (hades.isPresent() && favor.getFavor(hades.get()).getLevel() >= 8 && player.func_70681_au().nextInt(400) == 0) {
                player.func_184596_c(GFRegistry.PRISONER_EFFECT);
                FavorEffectManager.sendStatusMessage(player, hades.get(), true);
            } else {
                player.func_242279_ag();
            }
        }
    }

    private static boolean triggerFavorEffect(FavorEffectTrigger.Type type, ResourceLocation data, PlayerEntity playerIn, IFavor favor) {
        long time = IFavor.calculateTime((Entity)playerIn);
        if (favor.hasNoTriggeredCooldown(time)) {
            ArrayList deityList = Lists.newArrayList(GreekFantasy.PROXY.getDeityCollection(true));
            deityList.sort((o1, o2) -> favor.getFavor((IDeity)o1).compareToAbs(favor.getFavor((IDeity)o2)));
            long cooldown = -1L;
            for (IDeity deity : deityList) {
                FavorLevel level = favor.getFavor(deity);
                long lCooldown = FavorEffectManager.onTriggeredFavorEffect(type, data, playerIn.func_130014_f_(), playerIn, deity, favor, level);
                cooldown = Math.max(cooldown, lCooldown);
            }
            if (cooldown > 0L) {
                favor.setTriggeredTime(time, cooldown);
            }
        }
        return false;
    }

    private static void onCombatStart(PlayerEntity player, Entity other, IFavor favor) {
        long time = IFavor.calculateTime((Entity)player);
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        if (favor.hasNoTriggeredCooldown(time)) {
            long cooldown = -1L;
            for (ConfiguredSpecialFavorEffect effect : favorConfig.getSpecials(SpecialFavorEffect.Type.COMBAT_START_EFFECT)) {
                if (!effect.canApply(player, favor)) continue;
                effect.getEffect().getPotionEffect().ifPresent(e -> player.func_195064_c(e));
                cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(player.func_70681_au()));
            }
            if (cooldown > 0L) {
                favor.setTriggeredTime(time, cooldown);
            }
        }
        BiomeWhitelistConfig makhaiConfig = GreekFantasy.CONFIG.MOB_SPAWNS.get("makhai_spawn");
        RegistryKey biome = player.func_130014_f_().func_242406_i(player.func_233580_cy_()).orElse(Biomes.field_76772_c);
        if (favor.hasNoTriggeredCooldown(time) && makhaiConfig != null && makhaiConfig.chance() > 0 && makhaiConfig.canSpawnInBiome((RegistryKey<Biome>)biome)) {
            long cooldown = -1L;
            int level = 0;
            for (ConfiguredSpecialFavorEffect effect : favorConfig.getSpecials(SpecialFavorEffect.Type.COMBAT_SUMMON_MAKHAI)) {
                MakhaiEntity entity;
                level = favor.getFavor(effect.getDeity()).getLevel();
                if (!effect.canApply(player, favor) || level == 0 || (entity = FavorManager.summonMahkai(player, level >= 0)) == null) continue;
                cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(player.func_70681_au()));
                break;
            }
            if (cooldown > 0L) {
                favor.setTriggeredTime(time, cooldown);
            }
        }
    }

    public static void onAttackEntity(LivingEntity entity, PlayerEntity playerIn, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        ArrayList deityList = Lists.newArrayList(GreekFantasy.PROXY.getDeityCollection(true));
        for (IDeity deity : deityList) {
            long favorModifier = deity.getKillFavorModifier(entity.func_200600_R()) / 8;
            if (favorModifier == 0L) continue;
            favor.getFavor(deity).addFavor(playerIn, deity, favorModifier, FavorChangedEvent.Source.ATTACK_ENTITY);
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.PLAYER_HURT_ENTITY, entity.func_200600_R().getRegistryName(), playerIn, favor);
        if (playerIn.func_110142_aN().func_180134_f() < 40) {
            FavorManager.onCombatStart(playerIn, (Entity)entity, favor);
        }
    }

    public static void onKillEntity(LivingEntity entity, PlayerEntity playerIn, IFavor favor) {
        if (!favor.isEnabled()) {
            return;
        }
        for (IDeity deity : GreekFantasy.PROXY.getDeityCollection(true)) {
            long favorModifier = deity.getKillFavorModifier(entity.func_200600_R());
            if (favorModifier == 0L) continue;
            favor.getFavor(deity).addFavor(playerIn, deity, favorModifier, FavorChangedEvent.Source.KILL_ENTITY);
        }
        FavorManager.triggerFavorEffect(FavorEffectTrigger.Type.PLAYER_KILLED_ENTITY, entity.func_200600_R().getRegistryName(), playerIn, favor);
    }

    public static boolean onGiveItem(StatueTileEntity altar, IDeity deity, PlayerEntity playerIn, IFavor favor, FavorLevel info, ItemStack item) {
        long favorModifier = deity.getItemFavorModifier(item.func_77973_b());
        if (favorModifier != 0L && info.getFavor() + favorModifier <= FavorLevel.MAX_FAVOR_POINTS) {
            info.addFavor(playerIn, deity, favorModifier, FavorChangedEvent.Source.GIVE_ITEM);
            if (!playerIn.func_184812_l_()) {
                item.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public static void onShootArrow(PlayerEntity player, IFavor favor, AbstractArrowEntity arrow) {
        if (!favor.isEnabled()) {
            return;
        }
        long time = IFavor.calculateTime((Entity)player);
        if (favor.hasNoTriggeredCooldown(time)) {
            double damage = arrow.func_70242_d();
            float multiplier = 0.0f;
            long cooldown = -1L;
            for (ConfiguredSpecialFavorEffect effect : GreekFantasy.PROXY.getFavorConfiguration().getSpecials(SpecialFavorEffect.Type.ARROW_DAMAGE_MULTIPLIER)) {
                if (!effect.canApply(player, favor)) continue;
                multiplier += effect.getEffect().getMultiplier().orElse(Float.valueOf(0.0f)).floatValue();
                cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(player.func_70681_au()));
            }
            if (cooldown > 0L && multiplier != 0.0f) {
                favor.setTriggeredTime(time, cooldown);
                GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(true, arrow.func_233580_cy_(), 8));
                arrow.func_70239_b(damage + damage * (double)multiplier);
            }
        }
    }

    public static int onPlayerXP(PlayerEntity player, IFavor favor, int xpValue) {
        long time = IFavor.calculateTime((Entity)player);
        if (favor.isEnabled() && favor.hasNoTriggeredCooldown(time)) {
            FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
            float xpMultiplier = 0.0f;
            long cooldown = -1L;
            for (ConfiguredSpecialFavorEffect effect : favorConfig.getSpecials(SpecialFavorEffect.Type.XP_MULTIPLIER)) {
                if (!effect.canApply(player, favor)) continue;
                xpMultiplier += effect.getEffect().getMultiplier().orElse(Float.valueOf(0.0f)).floatValue();
                cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(player.func_70681_au()));
            }
            if (cooldown > 0L && xpMultiplier != 0.0f) {
                favor.setTriggeredTime(time, cooldown);
                return Math.round((float)xpValue + (float)xpValue * xpMultiplier);
            }
        }
        return xpValue;
    }

    public static int onBabySpawn(PlayerEntity player, IFavor favor) {
        if (!favor.isEnabled()) {
            return 1;
        }
        long time = IFavor.calculateTime((Entity)player);
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        float breedingMultiplier = 0.0f;
        long cooldown = -1L;
        for (ConfiguredSpecialFavorEffect effect : favorConfig.getSpecials(SpecialFavorEffect.Type.BREEDING_OFFSPRING_MULTIPLIER)) {
            if (!effect.canApply(player, favor)) continue;
            breedingMultiplier += effect.getEffect().getMultiplier().get().floatValue();
            cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(player.func_70681_au()));
        }
        if (cooldown > 0L && breedingMultiplier != 0.0f) {
            favor.setTriggeredTime(time, cooldown);
            return Math.round(1.0f + breedingMultiplier);
        }
        return 1;
    }

    private static long onNearCrops(PlayerEntity player, IFavor favor) {
        IntegerProperty[] AGES = new IntegerProperty[]{BlockStateProperties.field_222512_Y, BlockStateProperties.field_208171_X, BlockStateProperties.field_208167_T, BlockStateProperties.field_208168_U, BlockStateProperties.field_208169_V, BlockStateProperties.field_208170_W};
        FavorConfiguration favorConfig = GreekFantasy.PROXY.getFavorConfiguration();
        Random rand = player.func_130014_f_().func_201674_k();
        int maxAttempts = 10;
        int variationY = 2;
        int radius = 6;
        int attempts = 0;
        int growthToAdd = 0;
        long cooldown = -1L;
        for (ConfiguredSpecialFavorEffect effect : favorConfig.getSpecials(SpecialFavorEffect.Type.CROP_GROWTH_MULTIPLIER)) {
            if (!effect.canApply(player, favor)) continue;
            growthToAdd += Math.round(effect.getEffect().getMultiplier().get().floatValue());
            cooldown = Math.max(cooldown, effect.getEffect().getRandomCooldown(rand));
        }
        if (growthToAdd == 0 || cooldown < 0L) {
            return -1L;
        }
        while (attempts++ <= 10) {
            int x1 = rand.nextInt(radius * 2) - radius;
            int y1 = rand.nextInt(4) - 2 + 1;
            int z1 = rand.nextInt(radius * 2) - radius;
            BlockPos blockpos = player.func_233580_cy_().func_177982_a(x1, y1, z1);
            BlockState state = player.func_130014_f_().func_180495_p(blockpos);
            if (!(state.func_177230_c() instanceof IGrowable)) continue;
            for (IntegerProperty AGE : AGES) {
                if (!state.func_235901_b_((Property)AGE)) continue;
                int oldAge = (Integer)state.func_177229_b((Property)AGE);
                int newAge = Math.max(0, oldAge + growthToAdd);
                if (!AGE.func_177700_c().contains(newAge)) continue;
                player.func_130014_f_().func_175656_a(blockpos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(newAge)));
                GreekFantasy.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SSimpleParticlesPacket(growthToAdd > 0, blockpos, 10));
                return cooldown;
            }
        }
        return -1L;
    }

    private static MakhaiEntity summonMahkai(PlayerEntity playerIn, boolean tame) {
        MakhaiEntity entity = (MakhaiEntity)GFRegistry.MAKHAI_ENTITY.func_200721_a(playerIn.func_130014_f_());
        Random rand = playerIn.func_70681_au();
        int range = 6;
        for (int attempts = 24; attempts > 0; --attempts) {
            boolean isValidSpawn;
            BlockPos spawnPos = playerIn.func_233580_cy_().func_177982_a(rand.nextInt(range) - rand.nextInt(range), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(range) - rand.nextInt(range));
            boolean bl = isValidSpawn = playerIn.field_70170_p.func_180495_p(spawnPos.func_177977_b()).func_200132_m() && playerIn.field_70170_p.func_180495_p(spawnPos).func_185904_a() == Material.field_151579_a && playerIn.field_70170_p.func_180495_p(spawnPos.func_177984_a()).func_185904_a() == Material.field_151579_a;
            if (!isValidSpawn) continue;
            entity.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.01, (double)spawnPos.func_177952_p() + 0.5);
            if (tame) {
                entity.func_70903_f(true);
                entity.func_184754_b(playerIn.func_110124_au());
            } else {
                entity.func_70604_c((LivingEntity)playerIn);
            }
            playerIn.field_70170_p.func_217376_c((Entity)entity);
            entity.func_213386_a((IServerWorld)playerIn.field_70170_p, playerIn.field_70170_p.func_175649_E(spawnPos), SpawnReason.MOB_SUMMONED, null, null);
            entity.setSpawning(true);
            return entity;
        }
        entity.func_70106_y();
        return null;
    }
}

