/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor;

import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public interface IFavor
extends INBTSerializable<CompoundNBT> {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("greekfantasy", "favor");
    public static final String ENABLED = "Enabled";
    public static final String FAVOR_LEVELS = "FavorLevels";
    public static final String NAME = "Name";
    public static final String FAVOR = "Favor";
    public static final String TIMESTAMP = "Timestamp";
    public static final String COOLDOWN = "Cooldown";
    public static final String TRIGGERED_TIMESTAMP = "TriggeredTimestamp";
    public static final String TRIGGERED_COOLDOWN = "TriggeredCooldown";
    public static final long MIN_FAVOR = 10L;

    default public FavorLevel getFavor(IDeity deity) {
        return this.getFavor(deity.getName());
    }

    public FavorLevel getFavor(ResourceLocation var1);

    public void setFavor(ResourceLocation var1, FavorLevel var2);

    public Map<ResourceLocation, FavorLevel> getAllFavor();

    default public void forEach(BiConsumer<Deity, FavorLevel> action, boolean enabledOnly) {
        for (Map.Entry<ResourceLocation, FavorLevel> e : this.getAllFavor().entrySet()) {
            GreekFantasy.PROXY.DEITY.get(e.getKey()).ifPresent(d -> {
                if (d.isEnabled() || !enabledOnly) {
                    action.accept((Deity)d, (FavorLevel)e.getValue());
                }
            });
        }
    }

    default public Set<IDeity> getDeitySet() {
        return this.getAllFavor().keySet().stream().map(i -> GreekFantasy.PROXY.DEITY.get((ResourceLocation)i).orElse(Deity.EMPTY)).collect(Collectors.toSet());
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public long getEffectTimestamp();

    public void setEffectTimestamp(long var1);

    public long getEffectCooldown();

    public void setEffectCooldown(long var1);

    public long getTriggeredTimestamp();

    public void setTriggeredTimestamp(long var1);

    public long getTriggeredCooldown();

    public void setTriggeredCooldown(long var1);

    default public void setEffectTime(long time, long cooldown) {
        this.setEffectTimestamp(time);
        this.setEffectCooldown(cooldown);
    }

    default public void setTriggeredTime(long time, long cooldown) {
        this.setTriggeredTimestamp(time);
        this.setTriggeredCooldown(cooldown);
    }

    default public boolean hasNoEffectCooldown(long time) {
        return time >= this.getEffectTimestamp() + this.getEffectCooldown();
    }

    default public boolean hasNoTriggeredCooldown(long time) {
        return time >= this.getTriggeredTimestamp() + this.getTriggeredCooldown();
    }

    public static long calculateTime(Entity player) {
        return player.func_130014_f_().func_82737_E() + (long)(player.func_145782_y() * 3);
    }

    default public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT deities = new ListNBT();
        for (Map.Entry<ResourceLocation, FavorLevel> entry : this.getAllFavor().entrySet()) {
            CompoundNBT deityTag = new CompoundNBT();
            deityTag.func_74778_a(NAME, entry.getKey().toString());
            deityTag.func_218657_a(FAVOR, (INBT)entry.getValue().serializeNBT());
            deities.add((Object)deityTag);
        }
        nbt.func_218657_a(FAVOR_LEVELS, (INBT)deities);
        nbt.func_74757_a(ENABLED, this.isEnabled());
        nbt.func_74772_a(TIMESTAMP, this.getEffectTimestamp());
        nbt.func_74772_a(COOLDOWN, this.getEffectCooldown());
        nbt.func_74772_a(TRIGGERED_TIMESTAMP, this.getTriggeredTimestamp());
        nbt.func_74772_a(TRIGGERED_COOLDOWN, this.getTriggeredCooldown());
        return nbt;
    }

    default public void deserializeNBT(CompoundNBT nbt) {
        ListNBT deities = nbt.func_150295_c(FAVOR_LEVELS, 10);
        int l = deities.size();
        for (int i = 0; i < l; ++i) {
            CompoundNBT deity = deities.func_150305_b(i);
            String name = deity.func_74779_i(NAME);
            FavorLevel level = deity.func_150297_b(FAVOR, 10) ? new FavorLevel(deity.func_74775_l(FAVOR)) : new FavorLevel(deity.func_74763_f(FAVOR));
            this.setFavor(new ResourceLocation(name), level);
        }
        this.setEnabled(!nbt.func_74764_b(ENABLED) || nbt.func_74767_n(ENABLED));
        this.setEffectTimestamp(nbt.func_74763_f(TIMESTAMP));
        this.setEffectCooldown(nbt.func_74763_f(COOLDOWN));
        this.setTriggeredTimestamp(nbt.func_74763_f(TRIGGERED_TIMESTAMP));
        this.setTriggeredCooldown(nbt.func_74763_f(TRIGGERED_COOLDOWN));
    }
}

