/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.favor_effect.ConfiguredFavorRange;
import greekfantasy.deity.favor_effect.ConfiguredSpecialFavorEffect;
import greekfantasy.deity.favor_effect.FavorRange;
import greekfantasy.deity.favor_effect.SpecialFavorEffect;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;

public class FavorConfiguration {
    public static final ResourceLocation NAME = new ResourceLocation("greekfantasy", "favor_configuration");
    public static final FavorConfiguration EMPTY = new FavorConfiguration(Maps.newHashMap(), Maps.newHashMap());
    public static final String FLYING_RANGE = "flying_enchantment";
    public static final String LORD_OF_THE_SEA_RANGE = "lord_of_the_sea_enchantment";
    public static final String FIREFLASH_RANGE = "fireflash_enchantment";
    public static final String DAYBREAK_RANGE = "daybreak_enchantment";
    public static final String RAISING_RANGE = "raising_enchantment";
    public static final String APOLLO_BOW_RANGE = "apollo_bow";
    public static final String ARTEMIS_BOW_RANGE = "artemis_bow";
    public static final Codec<FavorConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, ConfiguredFavorRange.CODEC).optionalFieldOf("entity_favor_configuration", (Object)Maps.newHashMap()).forGetter(FavorConfiguration::getEntityTargetMap), (App)Codec.unboundedMap((Codec)Codec.STRING, FavorRange.CODEC).optionalFieldOf("enchantment_favor_configuration", (Object)Maps.newHashMap()).forGetter(FavorConfiguration::getEnchantmentMap)).apply((Applicative)instance, FavorConfiguration::new));
    private final Map<ResourceLocation, ConfiguredFavorRange> entityTargetMap;
    private final Map<String, FavorRange> enchantmentMap;
    private final EnumMap<SpecialFavorEffect.Type, List<ConfiguredSpecialFavorEffect>> specialFavorEffectMap;

    public FavorConfiguration(Map<ResourceLocation, ConfiguredFavorRange> entityTargetMapIn, Map<String, FavorRange> enchantmentMapIn) {
        this.entityTargetMap = ImmutableMap.copyOf(entityTargetMapIn);
        this.enchantmentMap = ImmutableMap.copyOf(enchantmentMapIn);
        this.specialFavorEffectMap = Maps.newEnumMap(SpecialFavorEffect.Type.class);
    }

    public Map<ResourceLocation, ConfiguredFavorRange> getEntityTargetMap() {
        return this.entityTargetMap;
    }

    public Map<String, FavorRange> getEnchantmentMap() {
        return this.enchantmentMap;
    }

    public FavorRange getSpecialRange(String name) {
        return this.getEnchantmentMap().getOrDefault(name, FavorRange.EMPTY);
    }

    public ConfiguredFavorRange getEntity(EntityType<?> type) {
        return this.getEntityTargetMap().getOrDefault(type.getRegistryName(), ConfiguredFavorRange.EMPTY);
    }

    public List<ConfiguredSpecialFavorEffect> getSpecials(SpecialFavorEffect.Type type) {
        if (!this.specialFavorEffectMap.containsKey((Object)type)) {
            ArrayList list = new ArrayList();
            for (Optional<Deity> deity : GreekFantasy.PROXY.DEITY.getValues()) {
                deity.ifPresent(d -> list.addAll(d.getSpecialFavorEffects(type)));
            }
            this.specialFavorEffectMap.put(type, list);
        }
        return this.specialFavorEffectMap.get((Object)type);
    }

    public boolean hasEntity(EntityType<?> type) {
        return this.getEntityTargetMap().containsKey(type.getRegistryName());
    }

    public String toString() {
        return "FavorConfiguration:\n" + this.entityTargetMap.toString() + "\n" + this.enchantmentMap.toString() + "\n" + this.specialFavorEffectMap.toString();
    }
}

