/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class FavorEffect {
    public static final FavorEffect EMPTY = new FavorEffect(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 1000L);
    public static final Codec<FavorEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.optionalFieldOf("function").forGetter(FavorEffect::getFunction), (App)CompoundNBT.field_240597_a_.optionalFieldOf("potion").forGetter(FavorEffect::getPotion), (App)CompoundNBT.field_240597_a_.optionalFieldOf("summon").forGetter(FavorEffect::getSummon), (App)ItemStack.field_234691_a_.optionalFieldOf("item").forGetter(FavorEffect::getItem), (App)Codec.STRING.optionalFieldOf("biome").forGetter(FavorEffect::getBiome), (App)Codec.LONG.optionalFieldOf("favor").forGetter(FavorEffect::getFavor), (App)Codec.INT.fieldOf("minlevel").forGetter(FavorEffect::getMinLevel), (App)Codec.INT.fieldOf("maxlevel").forGetter(FavorEffect::getMaxLevel), (App)Codec.LONG.fieldOf("mincooldown").forGetter(FavorEffect::getMinCooldown)).apply((Applicative)instance, FavorEffect::new));
    private final Optional<ResourceLocation> function;
    private final Optional<CompoundNBT> potion;
    private final Optional<CompoundNBT> summon;
    private final Optional<ItemStack> item;
    private final Optional<String> biome;
    private final Optional<Long> favor;
    private final int minLevel;
    private final int maxLevel;
    private final long minCooldown;
    private final String translationKey;

    protected FavorEffect(Optional<ResourceLocation> functionIn, Optional<CompoundNBT> potionIn, Optional<CompoundNBT> summonIn, Optional<ItemStack> itemIn, Optional<String> dataIn, Optional<Long> favorIn, int minLevelIn, int maxLevelIn, long minCooldownIn) {
        this.function = functionIn;
        this.potion = potionIn;
        this.summon = summonIn;
        this.item = itemIn;
        this.biome = dataIn;
        this.favor = favorIn;
        this.minLevel = minLevelIn;
        this.maxLevel = maxLevelIn;
        this.minCooldown = Math.max(1L, minCooldownIn);
        this.translationKey = this.function.isPresent() ? "favor.effect.function" : (this.potion.isPresent() ? "favor.effect.potion" : (this.summon.isPresent() ? "favor.effect.summon" : (this.item.isPresent() ? "favor.effect.item" : (this.favor.isPresent() ? "favor.effect.favor" : "favor.effect.none"))));
    }

    public Optional<ResourceLocation> getFunction() {
        return this.function;
    }

    public Optional<CompoundNBT> getPotion() {
        return this.potion;
    }

    public Optional<CompoundNBT> getSummon() {
        return this.summon;
    }

    public Optional<ItemStack> getItem() {
        return this.item;
    }

    public Optional<String> getBiome() {
        return this.biome;
    }

    public Optional<Long> getFavor() {
        return this.favor;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public long getMinCooldown() {
        return this.minCooldown;
    }

    public long getRandomCooldown(Random rand) {
        return this.minCooldown + (long)rand.nextInt((int)this.minCooldown);
    }

    public boolean isPositive() {
        return this.minLevel >= 0 || this.maxLevel >= 0;
    }

    public boolean isInRange(int playerLevel) {
        if (this.maxLevel > this.minLevel) {
            return playerLevel <= this.maxLevel && playerLevel >= this.minLevel;
        }
        return playerLevel <= this.minLevel && playerLevel >= this.maxLevel;
    }

    public boolean isInBiome(World world, BlockPos pos) {
        if (this.biome.isPresent()) {
            Optional curBiome = world.func_242406_i(pos);
            if (this.biome.get().contains(":")) {
                if (curBiome.isPresent() && !((RegistryKey)curBiome.get()).getRegistryName().toString().equals(this.biome.get())) {
                    return false;
                }
            } else {
                BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)this.biome.get(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                if (curBiome.isPresent() && !BiomeDictionary.hasType((RegistryKey)((RegistryKey)curBiome.get()), (BiomeDictionary.Type)type)) {
                    return false;
                }
            }
        }
        return true;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FavorEffect:");
        this.function.ifPresent(r -> b.append(" function[").append(r.toString()).append("]"));
        this.potion.ifPresent(r -> b.append(" potion[").append(r.toString()).append("]"));
        this.summon.ifPresent(r -> b.append(" summon[").append(r.toString()).append("]"));
        this.item.ifPresent(r -> b.append(" item[").append(r.toString()).append("]"));
        this.favor.ifPresent(r -> b.append(" favor[").append(r.toString()).append("]"));
        b.append(" level[").append(this.minLevel).append(",").append(this.maxLevel).append("]");
        b.append(" cooldown[").append(this.minCooldown).append("]");
        return b.toString();
    }
}

