/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import greekfantasy.GreekFantasy;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.FavorLevel;
import greekfantasy.deity.favor.IFavor;
import greekfantasy.deity.favor_effect.FavorEffect;
import greekfantasy.deity.favor_effect.FavorEffectTrigger;
import greekfantasy.deity.favor_effect.TriggeredFavorEffect;
import greekfantasy.event.FavorChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.FunctionObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class FavorEffectManager {
    private static List<ResourceLocation> functions = new ArrayList<ResourceLocation>();

    private static void loadFunctions(FunctionManager manager) {
        manager.field_240944_i_.func_240931_a_().keySet().forEach(rl -> {
            if (rl.func_110624_b().equals("greekfantasy") && rl.func_110623_a().contains("favor_effect")) {
                functions.add((ResourceLocation)rl);
            }
        });
    }

    public static long onTriggeredFavorEffect(FavorEffectTrigger.Type type, ResourceLocation data, World worldIn, PlayerEntity playerIn, IDeity deity, IFavor favor, FavorLevel level) {
        MinecraftServer server = worldIn.func_73046_m();
        if (server != null) {
            TriggeredFavorEffect effect = deity.getTriggeredFavorEffect(playerIn.func_70681_au(), type, data, level.getLevel());
            return effect == TriggeredFavorEffect.EMPTY ? -1L : FavorEffectManager.performFavorEffect(server, worldIn, playerIn, deity, effect.getEffect());
        }
        return -1L;
    }

    public static long onFavorEffect(World worldIn, PlayerEntity playerIn, IDeity deity, IFavor favor, FavorLevel info) {
        MinecraftServer server = worldIn.func_73046_m();
        if (server != null) {
            FavorEffect effect = deity.getRandomEffect(playerIn.func_70681_au(), info.getLevel());
            return FavorEffectManager.performFavorEffect(server, worldIn, playerIn, deity, effect);
        }
        return -1L;
    }

    public static void sendStatusMessage(PlayerEntity playerIn, IDeity deity, boolean positive) {
        if (GreekFantasy.CONFIG.isFavorNotifyEnabled()) {
            String message = positive ? "positive" : "negative";
            TextFormatting color = positive ? TextFormatting.GREEN : TextFormatting.RED;
            SoundEvent sound = positive ? SoundEvents.field_187802_ec : SoundEvents.field_187635_cQ;
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("favor.effect." + message, new Object[]{deity.getText()}).func_240699_a_(color), !GreekFantasy.CONFIG.isFavorNotifyChat());
            playerIn.func_130014_f_().func_184134_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), sound, SoundCategory.PLAYERS, 0.4f, 0.9f + playerIn.func_70681_au().nextFloat() * 0.2f, false);
        }
    }

    private static long performFavorEffect(MinecraftServer server, World worldIn, PlayerEntity playerIn, IDeity deity, FavorEffect effect) {
        boolean flag = false;
        if (effect != FavorEffect.EMPTY && effect.isInBiome(worldIn, playerIn.func_233580_cy_())) {
            if (FavorEffectManager.functionFavorEffect(server, worldIn, playerIn, effect.getFunction())) {
                flag = true;
            } else if (FavorEffectManager.summonFavorEffect(worldIn, playerIn, effect.getSummon())) {
                flag = true;
            } else if (FavorEffectManager.itemFavorEffect(playerIn, effect.getItem())) {
                flag = true;
            } else if (FavorEffectManager.potionFavorEffect(playerIn, effect.getPotion())) {
                flag = true;
            } else if (FavorEffectManager.addFavorEffect(playerIn, deity, effect.getFavor())) {
                flag = true;
            } else {
                GreekFantasy.LOGGER.debug("Failed to run any part of a favor effect for " + deity.getName().toString() + "... " + effect.toString());
            }
            if (flag) {
                if (!effect.getFavor().isPresent()) {
                    FavorEffectManager.sendStatusMessage(playerIn, deity, effect.isPositive());
                }
                return Math.abs(effect.getMinCooldown()) + (long)playerIn.func_70681_au().nextInt((int)Math.max(1L, Math.abs(effect.getMinCooldown())));
            }
        }
        return -1L;
    }

    private static boolean potionFavorEffect(PlayerEntity playerIn, Optional<CompoundNBT> potionTag) {
        if (potionTag.isPresent()) {
            CompoundNBT nbt = potionTag.get().func_74737_b();
            nbt.func_74774_a("Id", (byte)Effect.func_188409_a((Effect)((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionTag.get().func_74779_i("Potion"))))));
            EffectInstance effect = EffectInstance.func_82722_b((CompoundNBT)nbt);
            if (effect != null) {
                return playerIn.func_195064_c(EffectInstance.func_82722_b((CompoundNBT)nbt));
            }
        }
        return false;
    }

    private static boolean itemFavorEffect(PlayerEntity playerIn, Optional<ItemStack> itemTag) {
        if (itemTag.isPresent()) {
            return playerIn.func_191521_c(itemTag.get());
        }
        return false;
    }

    private static boolean summonFavorEffect(World worldIn, PlayerEntity playerIn, Optional<CompoundNBT> entityTag) {
        Optional entityType;
        if (entityTag.isPresent() && worldIn instanceof IServerWorld && (entityType = EntityType.func_220347_a((CompoundNBT)entityTag.get())).isPresent()) {
            Entity entity = ((EntityType)entityType.get()).func_200721_a(worldIn);
            boolean waterMob = entity instanceof WaterMobEntity || entity instanceof DrownedEntity || entity instanceof GuardianEntity || entity instanceof MobEntity && ((MobEntity)entity).func_70661_as() instanceof SwimmerPathNavigator;
            Random rand = playerIn.func_70681_au();
            int range = 9;
            for (int attempts = 24; attempts > 0; --attempts) {
                boolean isValidSpawn;
                BlockPos spawnPos = playerIn.func_233580_cy_().func_177982_a(rand.nextInt(range) - rand.nextInt(range), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(range) - rand.nextInt(range));
                boolean bl = isValidSpawn = EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)entityType.get()), (IServerWorld)((IServerWorld)worldIn), (SpawnReason)SpawnReason.MOB_SUMMONED, (BlockPos)spawnPos, (Random)rand) || waterMob && worldIn.func_180495_p(spawnPos).func_203425_a(Blocks.field_150355_j) || !waterMob && worldIn.func_180495_p(spawnPos.func_177977_b()).func_200132_m() && worldIn.func_180495_p(spawnPos).func_185904_a() == Material.field_151579_a && worldIn.func_180495_p(spawnPos.func_177984_a()).func_185904_a() == Material.field_151579_a;
                if (!isValidSpawn) continue;
                entity.func_70020_e(entityTag.get());
                entity.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.01, (double)spawnPos.func_177952_p() + 0.5);
                worldIn.func_217376_c(entity);
                return true;
            }
            entity.func_70106_y();
        }
        return false;
    }

    private static boolean functionFavorEffect(MinecraftServer server, World worldIn, PlayerEntity playerIn, Optional<ResourceLocation> function) {
        if (function.isPresent() && server != null) {
            FunctionManager manager = server.func_193030_aL();
            if (functions.isEmpty()) {
                FavorEffectManager.loadFunctions(manager);
                if (functions.isEmpty()) {
                    GreekFantasy.LOGGER.error("Tried to load functions for favor_effect but none were found! What went wrong?");
                    return false;
                }
            }
            Optional mcfunction = manager.func_215361_a(function.get());
            Vector3d vec = playerIn.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
            if (mcfunction.isPresent()) {
                CommandSource commandSource = manager.func_195448_f().func_197024_a((Entity)playerIn).func_201009_a(vec).func_197033_a(4).func_197031_a();
                manager.func_195447_a((FunctionObject)mcfunction.get(), commandSource);
                return true;
            }
        }
        return false;
    }

    private static boolean addFavorEffect(PlayerEntity playerIn, IDeity deity, Optional<Long> favorAmount) {
        if (favorAmount.isPresent()) {
            playerIn.getCapability(GreekFantasy.FAVOR).ifPresent(favor -> favor.getFavor(deity).addFavor(playerIn, deity, (Long)favorAmount.get(), FavorChangedEvent.Source.OTHER));
            return true;
        }
        return false;
    }
}

