/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GreekFantasy;
import greekfantasy.deity.Deity;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.IFavor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class FavorRange {
    public static final FavorRange EMPTY = new FavorRange(new ResourceLocation("greekfantasy", "null"), 0, 0);
    public static final Codec<FavorRange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("deity").forGetter(FavorRange::getDeityName), (App)Codec.INT.fieldOf("minlevel").forGetter(FavorRange::getMinLevel), (App)Codec.INT.fieldOf("maxlevel").forGetter(FavorRange::getMaxLevel)).apply((Applicative)instance, FavorRange::new));
    private final ResourceLocation deity;
    private final int minLevel;
    private final int maxLevel;

    public FavorRange(ResourceLocation deityIn, int minLevelIn, int maxLevelIn) {
        this.deity = deityIn;
        this.minLevel = Math.min(minLevelIn, maxLevelIn);
        this.maxLevel = Math.max(minLevelIn, maxLevelIn);
    }

    public IDeity getDeity() {
        return GreekFantasy.PROXY.DEITY.get(this.getDeityName()).orElse(Deity.EMPTY);
    }

    public ResourceLocation getDeityName() {
        return this.deity;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isInFavorRange(PlayerEntity player) {
        if (player.func_70613_aW() && player.getCapability(GreekFantasy.FAVOR).isPresent() && this != EMPTY) {
            return this.isInFavorRange(player, (IFavor)player.getCapability(GreekFantasy.FAVOR).orElse(GreekFantasy.FAVOR.getDefaultInstance()));
        }
        return false;
    }

    public boolean isInFavorRange(PlayerEntity player, IFavor f) {
        if (this == EMPTY || !f.isEnabled()) {
            return false;
        }
        int playerLevel = f.getFavor(this.getDeity()).getLevel();
        if (this.maxLevel > this.minLevel) {
            return playerLevel <= this.maxLevel && playerLevel >= this.minLevel;
        }
        return playerLevel <= this.minLevel && playerLevel >= this.maxLevel;
    }

    public String toString() {
        return "Favor Range: " + this.deity.toString() + " [" + this.minLevel + "," + this.maxLevel + "]";
    }
}

