/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.deity.IDeity;
import greekfantasy.deity.favor.IFavor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SpecialFavorEffect {
    public static final SpecialFavorEffect EMPTY = new SpecialFavorEffect(Type.NONE.func_176610_l(), 0, 0, Optional.empty(), Optional.empty(), 0.0f, 0.0f, 100L);
    public static final Codec<SpecialFavorEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(SpecialFavorEffect::getTypeString), (App)Codec.INT.fieldOf("minlevel").forGetter(SpecialFavorEffect::getMinLevel), (App)Codec.INT.fieldOf("maxlevel").forGetter(SpecialFavorEffect::getMaxLevel), (App)CompoundNBT.field_240597_a_.optionalFieldOf("potion").forGetter(SpecialFavorEffect::getPotion), (App)Codec.FLOAT.optionalFieldOf("multiplier").forGetter(SpecialFavorEffect::getMultiplier), (App)Codec.FLOAT.fieldOf("chance").forGetter(SpecialFavorEffect::getChance), (App)Codec.FLOAT.fieldOf("level_multiplier").forGetter(SpecialFavorEffect::getLevelMultiplier), (App)Codec.LONG.fieldOf("mincooldown").forGetter(SpecialFavorEffect::getMinCooldown)).apply((Applicative)instance, SpecialFavorEffect::new));
    private final Type type;
    private final String typeString;
    private final int minLevel;
    private final int maxLevel;
    private final Optional<CompoundNBT> potion;
    private final Optional<Float> multiplier;
    private final float chance;
    private final float levelMultiplier;
    private final long minCooldown;

    public SpecialFavorEffect(String typeStringIn, int minLevelIn, int maxLevelIn, Optional<CompoundNBT> potionIn, Optional<Float> multiplierIn, float chanceIn, float levelMultiplierIn, long minCooldownIn) {
        this.typeString = typeStringIn;
        this.type = Type.getById(typeStringIn);
        this.minLevel = minLevelIn;
        this.maxLevel = maxLevelIn;
        this.potion = potionIn;
        this.multiplier = multiplierIn;
        this.chance = chanceIn;
        this.levelMultiplier = levelMultiplierIn;
        this.minCooldown = Math.max(1L, minCooldownIn);
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getChance() {
        return this.chance;
    }

    public float getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public float getAdjustedChance(int level) {
        return Math.min(this.chance + (float)Math.abs(level) * this.levelMultiplier, 1.0f);
    }

    public Optional<Float> getMultiplier() {
        return this.multiplier;
    }

    public Optional<CompoundNBT> getPotion() {
        return this.potion;
    }

    public Optional<EffectInstance> getPotionEffect() {
        if (this.getPotion().isPresent()) {
            CompoundNBT nbt = this.getPotion().get().func_74737_b();
            nbt.func_74774_a("Id", (byte)Effect.func_188409_a((Effect)((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(this.getPotion().get().func_74779_i("Potion"))))));
            return Optional.of(EffectInstance.func_82722_b((CompoundNBT)nbt));
        }
        return Optional.empty();
    }

    public long getMinCooldown() {
        return this.minCooldown;
    }

    public long getRandomCooldown(Random rand) {
        return this.minCooldown + (long)rand.nextInt((int)this.minCooldown);
    }

    public boolean canApply(PlayerEntity player, IDeity deity, IFavor favor) {
        return favor.isEnabled() && this != EMPTY && this.type != Type.NONE && deity.isEnabled() && this.isInFavorRange(player, deity, favor) && player.func_70681_au().nextFloat() < this.getAdjustedChance(favor.getFavor(deity).getLevel());
    }

    public boolean isInFavorRange(PlayerEntity player, IDeity deity, IFavor f) {
        if (this == EMPTY || !f.isEnabled()) {
            return false;
        }
        int playerLevel = f.getFavor(deity).getLevel();
        if (this.maxLevel > this.minLevel) {
            return playerLevel <= this.maxLevel && playerLevel >= this.minLevel;
        }
        return playerLevel <= this.minLevel && playerLevel >= this.maxLevel;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SpecialFavorEffect:");
        b.append(" type[").append(this.type.func_176610_l()).append(" ]");
        b.append(" range[").append(this.minLevel).append(" ~ ").append(this.maxLevel).append("]");
        this.potion.ifPresent(nbt -> b.append(" potion[").append(nbt.toString()).append("]"));
        this.multiplier.ifPresent(f -> b.append(" multiplier[").append(f.toString()).append("]"));
        b.append(" chance[").append(this.chance).append("]");
        b.append(" minCooldown[").append(this.minCooldown).append("]");
        return b.toString();
    }

    public static enum Type implements IStringSerializable
    {
        NONE("none"),
        ARROW_DAMAGE_MULTIPLIER("arrow_damage_multiplier"),
        BREEDING_OFFSPRING_MULTIPLIER("breeding_offspring_multiplier"),
        COMBAT_START_EFFECT("combat_start_effect"),
        CROP_GROWTH_MULTIPLIER("crop_growth_multiplier"),
        CROP_HARVEST_MULTIPLIER("crop_harvest_multiplier"),
        POTION_BONUS_LENGTH("potion_bonus_length"),
        POTION_BONUS_EFFECT("potion_bonus_effect"),
        MINING_AUTOSMELT("mining_autosmelt"),
        MINING_CANCEL_ORES("mining_cancel_ores"),
        TRADING_CANCEL("trading_cancel"),
        XP_MULTIPLIER("xp_multiplier"),
        COMBAT_SUMMON_MAKHAI("combat_summon_makhai");

        private static final Map<String, Type> valueMap;
        public static final Codec<Type> CODEC;
        private final String name;
        private final String translationKey;

        private Type(String id) {
            this.name = id;
            this.translationKey = "favor.effect.type." + id;
        }

        public static Type getById(String id) {
            return valueMap.getOrDefault(id, NONE);
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            valueMap = new HashMap<String, Type>();
            for (Type t : Type.values()) {
                valueMap.put(t.func_176610_l(), t);
            }
            CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)((Object)Type.getById(s))), Type::func_176610_l).stable();
        }
    }
}

