/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.deity.favor_effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.deity.favor_effect.FavorEffect;
import greekfantasy.deity.favor_effect.FavorEffectTrigger;

public class TriggeredFavorEffect {
    public static final TriggeredFavorEffect EMPTY = new TriggeredFavorEffect(FavorEffectTrigger.EMPTY, 0.0f, 0.0f, FavorEffect.EMPTY);
    public static final Codec<TriggeredFavorEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FavorEffectTrigger.CODEC.fieldOf("trigger").forGetter(TriggeredFavorEffect::getTrigger), (App)Codec.FLOAT.fieldOf("chance").forGetter(TriggeredFavorEffect::getChance), (App)Codec.FLOAT.fieldOf("level_multiplier").forGetter(TriggeredFavorEffect::getLevelMultiplier), (App)FavorEffect.CODEC.fieldOf("effect").forGetter(TriggeredFavorEffect::getEffect)).apply((Applicative)instance, TriggeredFavorEffect::new));
    private final FavorEffectTrigger trigger;
    private final float chance;
    private final float levelMultiplier;
    private final FavorEffect effect;

    public TriggeredFavorEffect(FavorEffectTrigger triggerIn, float chanceIn, float levelMultiplierIn, FavorEffect effectIn) {
        this.trigger = triggerIn;
        this.chance = chanceIn;
        this.levelMultiplier = levelMultiplierIn;
        this.effect = effectIn;
    }

    public FavorEffectTrigger getTrigger() {
        return this.trigger;
    }

    public float getChance() {
        return this.chance;
    }

    public float getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public float getAdjustedChance(int level) {
        return Math.min(this.chance + (float)Math.abs(level) * this.levelMultiplier, 1.0f);
    }

    public FavorEffect getEffect() {
        return this.effect;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("TriggeredFavorEffect:");
        b.append(" ").append(this.trigger.toString());
        b.append(" chance[").append(this.chance).append(" + level*").append(this.levelMultiplier).append("]");
        b.append(" ").append(this.effect.toString());
        return b.toString();
    }
}

