/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.enchantment;

import greekfantasy.GreekFantasy;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;

public class HuntingEnchantment
extends Enchantment {
    public HuntingEnchantment(Enchantment.Rarity rarity) {
        super(rarity, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    private boolean isApplicableItem(ItemStack item) {
        return item.func_77973_b() instanceof SwordItem || item.func_77973_b() instanceof AxeItem;
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        ItemStack item = user.func_184586_b(Hand.MAIN_HAND);
        if (!this.isApplicableItem(item)) {
            return;
        }
        if (target.func_184222_aU() && target instanceof AnimalEntity && (level >= 3 || user.func_70681_au().nextInt(4 - level) == 0)) {
            float amount = 1.0f;
            DamageSource source = DamageSource.func_76358_a((LivingEntity)user);
            if (GreekFantasy.CONFIG.doesSwordOfHuntBypassArmor()) {
                amount = Math.min(128.0f, ((AnimalEntity)target).func_110138_aP() * 1.25f);
                source.func_76348_h().func_151518_m();
            }
            target.func_70097_a(source, amount);
        }
    }

    public int func_77321_a(int level) {
        return 10 + super.func_77321_a(level);
    }

    public int func_223551_b(int level) {
        return 10 + super.func_223551_b(level);
    }

    public boolean func_185261_e() {
        return GreekFantasy.CONFIG.isHuntingEnabled();
    }

    public boolean func_230309_h_() {
        return GreekFantasy.CONFIG.isHuntingEnabled();
    }

    public boolean func_230310_i_() {
        return GreekFantasy.CONFIG.isHuntingEnabled();
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return GreekFantasy.CONFIG.isHuntingEnabled() && this.isApplicableItem(stack) && super.canApplyAtEnchantingTable(stack);
    }
}

