/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.enchantment;

import greekfantasy.GFRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PoisonEnchantment
extends Enchantment {
    public PoisonEnchantment(Enchantment.Rarity rarity) {
        super(rarity, EnchantmentType.ARMOR, new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET});
    }

    public boolean func_92089_a(ItemStack item) {
        if (item.func_77973_b() instanceof ArmorItem) {
            return true;
        }
        return super.func_92089_a(item);
    }

    public ITextComponent func_200305_d(int level) {
        return ((IFormattableTextComponent)super.func_200305_d(level)).func_240699_a_(TextFormatting.GREEN);
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        Random rand = user.func_70681_au();
        Map.Entry enchants = EnchantmentHelper.func_222189_b((Enchantment)GFRegistry.POISON_ENCHANTMENT, (LivingEntity)user);
        if (PoisonEnchantment.shouldHit(level, rand)) {
            if (attacker instanceof LivingEntity) {
                int duration = PoisonEnchantment.getDuration(level, rand);
                ((LivingEntity)attacker).func_195064_c(new EffectInstance(Effects.field_76436_u, duration, level));
            }
            if (enchants != null) {
                ((ItemStack)enchants.getValue()).func_222118_a(2, user, e -> e.func_213361_c((EquipmentSlotType)enchants.getKey()));
            }
        }
    }

    public static boolean shouldHit(int level, Random rand) {
        if (level <= 0) {
            return false;
        }
        return rand.nextFloat() < 0.15f * (float)level;
    }

    public static int getDuration(int level, Random rand) {
        if (level > 5) {
            return 200;
        }
        return (level * 2 + rand.nextInt(3)) * 20;
    }

    public int func_77321_a(int level) {
        return 10 + 20 * (level - 1);
    }

    public int func_223551_b(int level) {
        return 50 + super.func_223551_b(level);
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_230309_h_() {
        return false;
    }

    public boolean func_230310_i_() {
        return false;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }
}

