/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.enchantment;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.item.ClubItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;

public class SmashingEnchantment
extends Enchantment {
    private static final double BASE_RANGE = 2.0;

    public SmashingEnchantment(Enchantment.Rarity rarity) {
        super(rarity, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    private boolean isExemptFromSmashAttack(Entity entity) {
        return !entity.func_184222_aU() || entity.func_189652_ae() || entity.func_200600_R() == GFRegistry.GIGANTE_ENTITY || entity.func_175149_v() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
    }

    private void useSmashAttack(LivingEntity user, Entity target, int level) {
        if (target.func_233570_aj_() && !this.isExemptFromSmashAttack(target)) {
            target.func_70024_g(0.0, 0.35 + 0.05 * (double)level, 0.0);
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)user), 0.25f);
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                int STUN_DURATION = 40 + level * 20;
                if (GreekFantasy.CONFIG.isStunningNerf()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, STUN_DURATION, 0));
                    entity.func_195064_c(new EffectInstance(Effects.field_76437_t, STUN_DURATION, 0));
                } else {
                    entity.func_195064_c(new EffectInstance(GFRegistry.STUNNED_EFFECT, STUN_DURATION, 0));
                }
            }
        }
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        ItemStack item = user.func_184586_b(Hand.MAIN_HAND);
        if (!(item.func_77973_b() instanceof ClubItem)) {
            return;
        }
        double range = 2.0 + 1.5 * (double)level;
        Vector3d facing = Vector3d.func_189984_a((Vector2f)user.func_189653_aC()).func_72432_b();
        AxisAlignedBB aabb = new AxisAlignedBB(target.func_233580_cy_().func_177984_a()).func_72314_b(range, 2.0, range).func_191194_a(facing.func_186678_a(range));
        user.func_130014_f_().func_72839_b((Entity)user, aabb).forEach(e -> this.useSmashAttack(user, (Entity)e, level));
    }

    public int func_77321_a(int level) {
        return 999;
    }

    public int func_223551_b(int level) {
        return 999;
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_230309_h_() {
        return false;
    }

    public boolean func_230310_i_() {
        return false;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }
}

