/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.misc.WebBallEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class ArachneEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(ArachneEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

    public ArachneEntity(EntityType<? extends ArachneEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.285).func_233815_a_(Attributes.field_233823_f_, 4.5).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233819_b_, 20.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal(this, 1.0, 75, 15.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        WebBallEntity web = WebBallEntity.create(this.field_70170_p, (LivingEntity)this);
        web.setWebType(this.func_70681_au().nextBoolean() || !ArachneEntity.hasSilkstep(target), true, false);
        web.func_70107_b(this.func_226277_ct_() - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))), this.func_226280_cw_() - 0.1, this.func_226281_cx_() + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))));
        double dx = target.func_226277_ct_() - web.func_226277_ct_();
        double dy = target.func_226283_e_(0.67) - web.func_226278_cu_();
        double dz = target.func_226281_cx_() - web.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        web.func_70186_c(dx, dy + dis * (double)0.2f, dz, 1.14f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_191255_dF, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)web);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    private static boolean hasSilkstep(LivingEntity player) {
        return player != null && EnchantmentHelper.func_77506_a((Enchantment)GFRegistry.SILKSTEP_ENCHANTMENT, (ItemStack)player.func_184582_a(EquipmentSlotType.FEET)) > 0;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
        this.bossInfo.func_186739_a(this.func_145818_k_() ? this.func_200201_e() : this.func_145748_c_());
        this.bossInfo.func_186758_d(GreekFantasy.CONFIG.showArachneBossBar());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal(CreatureEntity entity, double moveSpeed, boolean useLongMemory) {
            super(entity, moveSpeed, useLongMemory);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && ArachneEntity.this.func_70068_e((Entity)ArachneEntity.this.func_70638_az()) < 9.0;
        }
    }

    class RangedAttackGoal
    extends net.minecraft.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(IRangedAttackMob entity, double moveSpeed, int attackInterval, float attackDistance) {
            super(entity, moveSpeed, attackInterval, attackDistance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && ArachneEntity.this.func_70068_e((Entity)ArachneEntity.this.func_70638_az()) > 9.0;
        }
    }
}

