/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.ai.ShootFireGoal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BronzeBullEntity
extends MonsterEntity {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(BronzeBullEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "BullState";
    private static final String KEY_SPAWN = "SpawnTime";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte FIRING = 2;
    private static final byte GORING = 3;
    private static final byte SPAWN_CLIENT = 8;
    private static final byte FIRING_CLIENT = 9;
    private static final byte GORING_CLIENT = 10;
    private static final double FIRE_RANGE = 8.0;
    private static final int MAX_SPAWN_TIME = 90;
    private static final int MAX_FIRING_TIME = 89;
    private static final int MAX_GORING_TIME = 130;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    private int firingTime;
    private int spawnTime;
    private int goringTime;

    public BronzeBullEntity(EntityType<? extends BronzeBullEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233823_f_, 9.0).func_233815_a_(Attributes.field_233824_g_, 1.35).func_233815_a_(Attributes.field_233826_i_, 8.0);
    }

    public static BronzeBullEntity spawnBronzeBull(World world, BlockPos pos, float yaw) {
        BronzeBullEntity entity = (BronzeBullEntity)GFRegistry.BRONZE_BULL_ENTITY.func_200721_a(world);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, yaw, 0.0f);
        entity.field_70761_aq = yaw;
        world.func_217376_c((Entity)entity);
        entity.setSpawning(true);
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(25.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new FireAttackGoal(89, 120));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.25, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if ((this.isSpawning() || this.spawnTime > 0) && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if ((this.isGoring() || this.goringTime > 0) && --this.goringTime <= 0) {
            this.setGoring(false);
        }
        if ((this.isFiring() || this.firingTime > 0) && --this.firingTime <= 0) {
            this.setFiring(false);
        }
        if (this.func_70613_aW() && (this.isFiring() || this.isGoring()) && this.func_70638_az() == null) {
            this.setFiring(false);
            this.setGoring(false);
        }
        if (this.field_70170_p.func_201670_d() && this.isFiring()) {
            this.spawnFireParticles();
        }
        if (this.field_70170_p.func_201670_d()) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_() + 0.25;
            double z = this.func_226281_cx_();
            double motion = 0.06;
            double radius = (double)this.func_213311_cf() * 1.15;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, x + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, y + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, z + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.06, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.07, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.06);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.isGoring()) {
            this.setGoring(true);
        }
        if (super.func_70652_k(entityIn)) {
            double knockbackFactor = 0.92;
            Vector3d myPos = this.func_213303_ch();
            Vector3d ePos = entityIn.func_213303_ch();
            double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * 0.92;
            double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * 0.92;
            entityIn.func_70024_g(dX, 0.46, dZ);
            entityIn.field_70133_I = true;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setSpawning(true);
        return data;
    }

    protected float func_175134_bD() {
        return 0.42f * this.func_226269_ah_();
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_85033_bc() {
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source.func_82725_o() || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || source.func_76364_f() instanceof AbstractArrowEntity || super.func_180431_b(source);
    }

    public int func_70627_aG() {
        return 280;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected float func_70599_aP() {
        return 1.8f;
    }

    protected float func_70647_i() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.25f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getState());
        compound.func_74768_a(KEY_SPAWN, this.spawnTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState(compound.func_74771_c(KEY_STATE));
        this.spawnTime = compound.func_74762_e(KEY_SPAWN);
    }

    public void spawnFireParticles() {
        if (!this.field_70170_p.func_201670_d()) {
            return;
        }
        Vector3d lookVec = this.func_70040_Z();
        Vector3d pos = this.func_174824_e(1.0f);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72448_b + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72449_c + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, lookVec.field_72450_a * 0.06 * 8.0, lookVec.field_72448_b * 0.06 * 0.5, lookVec.field_72449_c * 0.06 * 8.0);
        }
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public boolean isFiring() {
        return this.getState() == 2 || this.firingTime > 0;
    }

    public boolean isGoring() {
        return this.getState() == 3 || this.goringTime > 0;
    }

    public void setFiring(boolean firing) {
        this.firingTime = firing ? 89 : 0;
        this.setState(firing ? (byte)2 : 0);
        if (firing && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public void setGoring(boolean goring) {
        this.goringTime = goring ? 130 : 0;
        this.setState(goring ? (byte)3 : 0);
        if (goring && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
            this.destroyIntersectingBlocks(1.45f + 0.75f * this.field_70146_Z.nextFloat(), 2.0);
        }
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 90 : 0;
        this.setState(spawning ? (byte)1 : 0);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 8: {
                this.setSpawning(true);
                break;
            }
            case 9: {
                this.setFiring(true);
                break;
            }
            case 10: {
                this.setGoring(true);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public float getSpawnPercent(float partialTick) {
        return this.getPercent(this.spawnTime, 90, partialTick);
    }

    public float getFiringPercent(float partialTick) {
        return this.getPercent(this.firingTime, 89, partialTick);
    }

    public float getGoringPercent(float partialTick) {
        return this.getPercent(this.goringTime, 130, partialTick);
    }

    private float getPercent(int timer, int maxValue, float partialTick) {
        if (timer <= 0) {
            return 0.0f;
        }
        float prevSpawnPercent = Math.max((float)timer - partialTick, 0.0f) / (float)maxValue;
        float spawnPercent = (float)timer / (float)maxValue;
        return 1.0f - MathHelper.func_219799_g((float)(partialTick / 6.0f), (float)prevSpawnPercent, (float)spawnPercent);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void destroyIntersectingBlocks(float maxHardness, double offset) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            return;
        }
        Vector3d facing = Vector3d.func_189984_a((Vector2f)this.func_189653_aC());
        AxisAlignedBB box = this.func_174813_aQ().func_191194_a(facing.func_72432_b().func_186678_a(offset));
        for (double x = box.field_72340_a - 0.25; x < box.field_72336_d + 0.25; x += 1.0) {
            for (double y = box.field_72338_b + 1.1; y < box.field_72337_e + 0.5; y += 1.0) {
                for (double z = box.field_72339_c - 0.25; z < box.field_72334_f + 0.25; z += 1.0) {
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState s = this.func_130014_f_().func_180495_p(p);
                    if (!s.func_200132_m() && !s.func_185904_a().func_76230_c() || !(s.func_185887_b((IBlockReader)this.field_70170_p, p) < maxHardness) || s.func_235714_a_((ITag)BlockTags.field_219755_X)) continue;
                    this.func_130014_f_().func_175655_b(p, true);
                }
            }
        }
    }

    class FireAttackGoal
    extends ShootFireGoal {
        protected FireAttackGoal(int fireTimeIn, int maxCooldownIn) {
            super((MobEntity)BronzeBullEntity.this, fireTimeIn, maxCooldownIn, 8.0);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && BronzeBullEntity.this.isNoneState();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && BronzeBullEntity.this.isFiring();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            BronzeBullEntity.this.setFiring(true);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            BronzeBullEntity.this.setFiring(false);
        }
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return BronzeBullEntity.this.isSpawning();
        }

        public void func_75246_d() {
            BronzeBullEntity.this.func_70661_as().func_75499_g();
            BronzeBullEntity.this.func_70671_ap().func_220679_a(BronzeBullEntity.this.func_226277_ct_(), BronzeBullEntity.this.func_226278_cu_(), BronzeBullEntity.this.func_226281_cx_());
            BronzeBullEntity.this.func_70101_b(0.0f, 0.0f);
        }
    }
}

