/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CentaurEntity
extends CreatureEntity
implements IAngerable,
IRangedAttackMob {
    private static final DataParameter<Byte> DATA_COLOR = EntityDataManager.func_187226_a(CentaurEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String TAG_COLOR = "Color";
    private static final byte REARING_START = 6;
    private static final byte REARING_END = 7;
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;
    private boolean isRearing;
    public int tailCounter;
    private float rearingAmount;
    private float prevRearingAmount;
    private int rearingCounter;

    public CentaurEntity(EntityType<? extends CentaurEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 34.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal(this, 1.0, this.hasBullHead() ? 50 : 35, 15.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((CentaurEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_COLOR, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (!this.field_70170_p.func_201670_d()) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        if (this.func_70613_aW() && this.rearingCounter > 0 && ++this.rearingCounter > 20) {
            this.rearingCounter = 0;
            this.setRearing(false);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76346_g() != null && source.func_76346_g().func_200600_R() == GFRegistry.CENTAUR_ENTITY) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(arrow);
        }
        arrow.func_70107_b(this.func_226277_ct_() - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))), this.func_226280_cw_() - (double)0.1f, this.func_226281_cx_() + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))));
        double dx = target.func_226277_ct_() - arrow.func_226277_ct_();
        double dy = target.func_226283_e_(0.67) - arrow.func_226278_cu_();
        double dz = target.func_226281_cx_() - arrow.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        arrow.func_70186_c(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(TAG_COLOR, (byte)this.getCoatColor().func_234253_a_());
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCoatColor(CoatColors.func_234254_a_((int)compound.func_74771_c(TAG_COLOR)));
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        CoatColors color = (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z);
        this.setCoatColor(color);
        if (this.field_70146_Z.nextInt(3) > 0) {
            this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier));
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeRear();
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeRear();
        }
        return null;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 6: {
                this.isRearing = true;
                break;
            }
            case 7: {
                this.isRearing = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void makeRear() {
        if (this.func_70613_aW()) {
            this.rearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void setRearing(boolean rearing) {
        this.isRearing = rearing;
        this.field_70170_p.func_72960_a((Entity)this, rearing ? (byte)6 : 7);
    }

    public boolean isRearing() {
        return this.isRearing;
    }

    public void moveTail() {
        this.tailCounter = 1;
    }

    public float getRearingAmount(float partialTick) {
        return partialTick > 0.99f ? this.rearingAmount : MathHelper.func_219799_g((float)partialTick, (float)this.prevRearingAmount, (float)this.rearingAmount);
    }

    public void setCoatColor(CoatColors color) {
        this.func_184212_Q().func_187227_b(DATA_COLOR, (Object)((byte)color.func_234253_a_()));
    }

    public CoatColors getCoatColor() {
        return CoatColors.func_234254_a_((int)((Byte)this.func_184212_Q().func_187225_a(DATA_COLOR)).intValue());
    }

    public boolean hasBullHead() {
        return false;
    }

    class RangedAttackGoal
    extends net.minecraft.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(IRangedAttackMob entity, double moveSpeed, int attackInterval, float attackDistance) {
            super(entity, moveSpeed, attackInterval, attackDistance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && CentaurEntity.this.func_184614_ca().func_77973_b() instanceof BowItem;
        }

        public void func_75249_e() {
            super.func_75249_e();
            CentaurEntity.this.func_213395_q(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            CentaurEntity.this.func_213395_q(false);
        }
    }
}

