/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.entity.ai.HasOwnerBegGoal;
import greekfantasy.entity.ai.HasOwnerFollowGoal;
import greekfantasy.entity.ai.HasOwnerHurtByTargetGoal;
import greekfantasy.entity.ai.HasOwnerHurtTargetGoal;
import greekfantasy.entity.misc.IHasOwner;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class CerastesEntity
extends CreatureEntity
implements IHasOwner<CerastesEntity> {
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(CerastesEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final Tags.IOptionalNamedTag<Item> FOOD = ItemTags.createOptional((ResourceLocation)new ResourceLocation("greekfantasy", "cerastes_food"));
    private static final byte STANDING_START = 4;
    private static final byte STANDING_END = 5;
    private static final byte HIDING_START = 6;
    private static final byte HIDING_END = 7;
    private final EntitySize hiddenSize = EntitySize.func_220314_b((float)0.8f, (float)0.2f);
    private final int MAX_TONGUE_TIME = 10;
    private final float STANDING_SPEED = 0.18f;
    private int tongueTime;
    private float standingTime;
    private float hidingTime;
    private boolean isHiding;
    private boolean isStanding;
    private boolean isGoingToSand;

    public CerastesEntity(EntityType<? extends CerastesEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DAMAGE_CACTUS, -0.5f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, -0.5f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public static boolean canCerastesSpawnOn(EntityType<? extends MobEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || world.func_180495_p(blockpos).func_203425_a(Blocks.field_150354_m);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.31).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new BegGoal(6.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HideGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, new HasOwnerFollowGoal<CerastesEntity>(this, 1.0, 8.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new GoToSandGoal(10, 0.8f));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal(this, 0.8){

            public boolean func_75250_a() {
                return !CerastesEntity.this.isHiding() && !CerastesEntity.this.isGoingToSand && CerastesEntity.this.field_70146_Z.nextInt(600) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 4.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new HasOwnerHurtByTargetGoal<CerastesEntity>(this));
        this.field_70715_bh.func_75776_a(1, new HasOwnerHurtTargetGoal<CerastesEntity>(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, false, false, e -> !this.isOwner((LivingEntity)e) && (!(e instanceof PlayerEntity) || !this.hasTamingItemInHand((PlayerEntity)e))));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RabbitEntity.class, false, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.tongueTime == 0) {
            if (!this.isStanding() && this.field_70146_Z.nextInt(100) == 0) {
                this.tongueTime = 1;
            }
        } else if (++this.tongueTime > 10) {
            this.tongueTime = 0;
        }
        if (this.isStanding()) {
            this.standingTime = Math.min(1.0f, this.standingTime + 0.18f);
        } else if (this.standingTime > 0.0f) {
            this.standingTime = Math.max(0.0f, this.standingTime - 0.18f);
        }
        if (this.isHiding()) {
            this.hidingTime = Math.min(1.0f, this.hidingTime + 0.18f);
        } else if (this.hidingTime > 0.0f) {
            this.hidingTime = Math.max(0.0f, this.hidingTime - 0.18f);
        }
        if (this.func_70613_aW()) {
            if (this.func_70638_az() != null || this.field_70146_Z.nextInt(600) == 0) {
                this.setStanding(true);
            } else if (this.isStanding() && this.standingTime > 0.9f && this.field_70146_Z.nextInt(60) == 0) {
                this.setStanding(false);
            }
        }
        if (this.func_70638_az() != null) {
            this.isGoingToSand = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.isStanding = true;
                this.isHiding = false;
                break;
            }
            case 5: {
                this.isStanding = false;
                break;
            }
            case 6: {
                this.isHiding = true;
                this.isStanding = false;
                this.func_213323_x_();
                break;
            }
            case 7: {
                this.isHiding = false;
                this.func_213323_x_();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.setHiding(false);
        this.setStanding(true);
        return super.func_70097_a(source, amount);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !this.field_70170_p.func_201670_d()) {
            this.setHiding(false);
            this.setStanding(true);
        }
        super.func_82167_n(entityIn);
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        if (typeIn == this.func_200600_R() || typeIn == EntityType.field_200797_k) {
            return false;
        }
        return super.func_213358_a(typeIn);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 0));
            }
            return true;
        }
        return false;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isHiding() ? this.hiddenSize : super.func_213305_a(poseIn);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.isHiding() ? this.hiddenSize.field_220316_b * 0.85f : super.func_213348_b(pose, size);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.tryTameOrHeal((LivingEntity)this, player, hand)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public Optional<UUID> getOwnerID() {
        return (Optional)this.func_184212_Q().func_187225_a(OWNER);
    }

    @Override
    public void setOwner(@Nullable UUID uuid) {
        this.func_184212_Q().func_187227_b(OWNER, Optional.ofNullable(uuid));
    }

    @Override
    public LivingEntity getOwner() {
        if (this.hasOwner()) {
            return this.func_130014_f_().func_217371_b(this.getOwnerID().get());
        }
        return null;
    }

    public boolean func_213336_c(LivingEntity entity) {
        if (this.isOwner(entity)) {
            return false;
        }
        return super.func_213336_c(entity);
    }

    @Override
    public boolean isTamingItem(ItemStack item) {
        return !item.func_190926_b() && FOOD.func_230235_a_((Object)item.func_77973_b());
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.getOwner() instanceof ServerPlayerEntity) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b(), Util.field_240973_b_);
        }
        super.func_70645_a(cause);
    }

    public Team func_96124_cp() {
        return this.getOwnerTeam(super.func_96124_cp());
    }

    public boolean func_184191_r(Entity entity) {
        return this.isOnSameTeamAs(entity) || super.func_184191_r(entity);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeOwner(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readOwner(compound);
    }

    public void setStanding(boolean standing) {
        this.isStanding = standing;
        if (standing) {
            this.isHiding = false;
        }
        this.field_70170_p.func_72960_a((Entity)this, standing ? (byte)4 : 5);
    }

    public boolean isStanding() {
        return this.isStanding;
    }

    public float getTongueTime() {
        return (float)this.tongueTime / 10.0f;
    }

    public float getStandingTime(float partialTick) {
        return this.standingTime;
    }

    public void setHiding(boolean hiding) {
        this.isHiding = hiding;
        if (hiding) {
            this.isStanding = false;
        }
        this.field_70170_p.func_72960_a((Entity)this, hiding ? (byte)6 : 7);
        this.func_213323_x_();
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public float getHidingTime(float partialTick) {
        return this.hidingTime;
    }

    static class HideGoal
    extends Goal {
        final CerastesEntity entity;
        final int MAX_HIDE_TIME = 500;
        final int MAX_COOLDOWN = 500;
        int cooldown;

        public HideGoal(CerastesEntity entityIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entityIn;
            this.cooldown = entityIn.func_70681_au().nextInt(500);
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                if (this.entity.func_70638_az() != null || !this.entity.func_70661_as().func_75500_f() || this.entity.isHiding()) {
                    return false;
                }
                if (this.entity.func_70681_au().nextInt(10) == 0) {
                    BlockPos blockpos = new BlockPos(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() - 0.5, this.entity.func_226281_cx_());
                    BlockState blockstate = this.entity.field_70170_p.func_180495_p(blockpos);
                    return BlockTags.field_203436_u.func_230235_a_((Object)blockstate.func_177230_c());
                }
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.setHiding(true);
            this.entity.isGoingToSand = false;
            this.cooldown = 1000;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.entity.isHiding()) {
                if (this.entity.func_70638_az() != null || this.entity.func_70681_au().nextInt(500) == 0) {
                    this.func_75251_c();
                    return;
                }
                this.entity.func_70661_as().func_75499_g();
            }
        }

        public boolean func_75253_b() {
            return this.entity.isHiding();
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.entity.setHiding(false);
            this.cooldown = 500;
        }
    }

    class GoToSandGoal
    extends MoveToBlockGoal {
        public GoToSandGoal(int radiusIn, double speedIn) {
            super((CreatureEntity)CerastesEntity.this, speedIn, radiusIn);
        }

        public boolean func_75250_a() {
            return !CerastesEntity.this.isHiding() && CerastesEntity.this.func_70638_az() == null && super.func_75250_a();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.func_179487_f()) {
                CerastesEntity.this.isGoingToSand = false;
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_180495_p(pos.func_177981_b(1)).func_185904_a().func_76230_c() && worldIn.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_203436_u)) {
                CerastesEntity.this.isGoingToSand = true;
                return true;
            }
            return false;
        }
    }

    class BegGoal
    extends HasOwnerBegGoal<CerastesEntity> {
        public BegGoal(float minDistance) {
            super(CerastesEntity.this, minDistance);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            CerastesEntity.this.setStanding(false);
            CerastesEntity.this.setHiding(false);
        }
    }
}

