/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.OrthusEntity;
import greekfantasy.entity.ai.ShootFireGoal;
import greekfantasy.entity.ai.SummonMobGoal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CerberusEntity
extends CreatureEntity {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(CerberusEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "CerberusState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte FIRING = 2;
    private static final byte SUMMONING = 4;
    private static final double FIRE_RANGE = 6.0;
    private static final int MAX_SPAWN_TIME = 90;
    private static final int MAX_FIRING_TIME = 66;
    private static final int MAX_SUMMON_TIME = 35;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte SUMMON_CLIENT = 10;
    private int spawnTime;
    private int summonTime;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

    public CerberusEntity(EntityType<? extends CerberusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 190.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    public static CerberusEntity spawnCerberus(World world, Vector3d pos) {
        CerberusEntity entity = (CerberusEntity)GFRegistry.CERBERUS_ENTITY.func_200721_a(world);
        entity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 0.0f, 0.0f);
        entity.field_70761_aq = 0.0f;
        world.func_217376_c((Entity)entity);
        entity.setSpawning(true);
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(25.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SpawningGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FireAttackGoal(66, 120));
        this.field_70714_bg.func_75776_a(2, (Goal)new SummonOrthusGoal(35, 310, 300));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.6f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.isSpawning()) {
            if (--this.spawnTime <= 0) {
                this.setSpawning(false);
            }
            this.addSpawningParticles((IParticleData)ParticleTypes.field_197631_x, 4);
            this.addSpawningParticles((IParticleData)ParticleTypes.field_197601_L, 1);
            this.addSpawningParticles((IParticleData)ParticleTypes.field_197594_E, 1);
        }
        if (this.isSummoning()) {
            ++this.summonTime;
        } else if (this.summonTime > 0) {
            this.summonTime = 0;
        }
        if (this.func_70613_aW() && this.isFiring() && this.func_70638_az() == null) {
            this.setFiring(false);
        }
        if (this.field_70170_p.func_201670_d() && this.isFiring()) {
            this.spawnFireParticles();
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setSpawning(true);
        return data;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || super.func_180431_b(source);
    }

    public void func_70108_f(Entity entityIn) {
        if (this.func_70104_M() && !this.isSpawning()) {
            super.func_70108_f(entityIn);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 1.2f;
    }

    protected float func_70647_i() {
        return 0.4f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 0.6f);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getCerberusState());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCerberusState(compound.func_74771_c(KEY_STATE));
    }

    public byte getCerberusState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public void setCerberusState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getCerberusState() == 0;
    }

    public boolean isFiring() {
        return this.getCerberusState() == 2;
    }

    public void setFiring(boolean firing) {
        this.setCerberusState(firing ? (byte)2 : 0);
    }

    public boolean isSummoning() {
        return this.getCerberusState() == 4;
    }

    public void setSummoning(boolean summoning) {
        this.setCerberusState(summoning ? (byte)4 : 0);
        int n = this.summonTime = summoning ? 1 : 0;
        if (summoning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
        }
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getCerberusState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 90 : 0;
        this.setCerberusState(spawning ? (byte)1 : 0);
        if (spawning && !this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpawnTime(float ageInTicks) {
        return (float)this.spawnTime + (ageInTicks < 1.0f ? ageInTicks : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSpawnPercent(float ageInTicks) {
        return 1.0f - (float)this.spawnTime / 90.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSummonTime(float partialTick) {
        return (float)this.summonTime + (partialTick < 1.0f ? partialTick : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSummonPercent(float partialTick) {
        return this.summonTime > 0 ? this.getSummonTime(partialTick) / 35.0f : 0.0f;
    }

    public void spawnFireParticles() {
        if (!this.field_70170_p.func_201670_d()) {
            return;
        }
        Vector3d lookVec = this.func_70040_Z();
        Vector3d pos = this.func_174824_e(1.0f);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72448_b + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, pos.field_72449_c + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.75, lookVec.field_72450_a * 0.06 * 6.0, lookVec.field_72448_b * 0.06 * 0.5, lookVec.field_72449_c * 0.06 * 6.0);
        }
    }

    private void addSpawningParticles(IParticleData particle, int count) {
        if (!this.field_70170_p.func_201670_d()) {
            return;
        }
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_() + 0.1;
        double z = this.func_226281_cx_();
        double motion = 0.08;
        double radius = this.func_213311_cf();
        for (int i = 0; i < count; ++i) {
            this.field_70170_p.func_195594_a(particle, x + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, y + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, z + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, 0.15, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 9) {
            this.setSpawning(true);
        } else if (id == 10) {
            this.func_130014_f_().func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_189111_gN, this.func_184176_by(), 1.1f, 0.9f + this.func_70681_au().nextFloat() * 0.2f, false);
        } else {
            super.func_70103_a(id);
        }
    }

    class SummonOrthusGoal
    extends SummonMobGoal<OrthusEntity> {
        private final int lifespan;

        public SummonOrthusGoal(int summonProgressIn, int summonCooldownIn, int lifespanIn) {
            super((MobEntity)CerberusEntity.this, summonProgressIn, summonCooldownIn, GFRegistry.ORTHUS_ENTITY);
            this.lifespan = lifespanIn;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && CerberusEntity.this.isNoneState();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            CerberusEntity.this.setSummoning(true);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            CerberusEntity.this.setSummoning(false);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (this.progress == 8) {
                CerberusEntity.this.func_130014_f_().func_72960_a((Entity)CerberusEntity.this, (byte)10);
            }
        }

        @Override
        protected void summonMob(OrthusEntity mobEntity) {
            mobEntity.setLimitedLife(this.lifespan);
            super.summonMob(mobEntity);
        }
    }

    class FireAttackGoal
    extends ShootFireGoal {
        protected FireAttackGoal(int fireTimeIn, int maxCooldownIn) {
            super((MobEntity)CerberusEntity.this, fireTimeIn, maxCooldownIn, 6.0);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && CerberusEntity.this.isNoneState();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && CerberusEntity.this.isFiring();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            CerberusEntity.this.setFiring(true);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            CerberusEntity.this.setFiring(false);
        }
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            return CerberusEntity.this.isSpawning();
        }

        public void func_75246_d() {
            CerberusEntity.this.func_70661_as().func_75499_g();
        }
    }
}

