/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.WhirlEntity;
import greekfantasy.entity.misc.ISwimmingMob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CharybdisEntity
extends WaterMobEntity
implements ISwimmingMob {
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(CharybdisEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_STATE = "CharybdisState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SWIRLING = 2;
    private static final byte THROWING = 4;
    private static final byte NONE_CLIENT = 8;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte SWIRL_CLIENT = 10;
    private static final byte THROW_CLIENT = 11;
    private static final double RANGE = 10.0;
    private static final int SPAWN_TIME = 50;
    private static final int SWIRL_TIME = 240;
    private static final int THROW_TIME = 34;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private int spawnTime;
    private int swirlTime;
    private int throwTime;
    private boolean swimmingUp;

    public CharybdisEntity(EntityType<? extends CharybdisEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public static CharybdisEntity spawnCharybdis(ServerWorld world, WhirlEntity whirl) {
        CharybdisEntity entity = (CharybdisEntity)GFRegistry.CHARYBDIS_ENTITY.func_200721_a((World)world);
        entity.func_82149_j((Entity)whirl);
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(whirl.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        if (whirl.func_145818_k_()) {
            entity.func_200203_b(whirl.func_200201_e());
            entity.func_174805_g(whirl.func_174833_aM());
        }
        entity.func_110163_bv();
        entity.field_70761_aq = whirl.field_70761_aq;
        entity.func_242279_ag();
        world.func_217376_c((Entity)entity);
        entity.setState((byte)1);
        whirl.func_70106_y();
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(16.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
        world.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187855_gD, entity.func_184176_by(), 1.2f, 1.0f, false);
        return entity;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 160.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 4.5).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimToSurfaceGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SwirlGoal(this, 240, 114, 10.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrowGoal(34, 82, 7.5));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70170_p.func_201670_d() && this.field_70173_aa % 3 == 0 && this.func_203005_aq()) {
            this.getEntitiesInRange(10.0).forEach(e -> this.bubbles(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), e.func_213311_cf(), 5));
            float maxY = this.func_213302_cg() * this.getSpawnPercent() * 1.65f;
            float y = 0.0f;
            float nY = 120.0f * this.getSpawnPercent();
            float dY = maxY / nY;
            double posX = this.func_226277_ct_();
            double posY = this.func_226278_cu_();
            double posZ = this.func_226281_cx_();
            float a = 0.0f;
            float nA = 28 + this.field_70146_Z.nextInt(4);
            float dA = (float)Math.PI * 2 / nA;
            while (y < maxY) {
                float radius = y * 0.5f;
                float cosA = MathHelper.func_76134_b((float)a) * radius;
                float sinA = MathHelper.func_76126_a((float)a) * radius;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX + (double)cosA, posY + (double)y - (double)maxY * 0.4, posZ + (double)sinA, 0.0, 0.085, 0.0);
                y += dY;
                a += dA;
            }
        }
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setState((byte)0);
        }
        if (this.isSwirling()) {
            ++this.swirlTime;
            this.func_70101_b(this.field_70177_z + 1.0f, this.field_70125_A);
        } else if (this.swirlTime > 0) {
            this.swirlTime = 0;
        }
        if (this.isThrowing()) {
            ++this.throwTime;
        } else if (this.throwTime > 0) {
            this.throwTime = 0;
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setState((byte)1);
        return data;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213397_c(double disToPlayer) {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isSpawning() || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || source.func_76364_f() instanceof AbstractArrowEntity || super.func_180431_b(source);
    }

    protected void func_209207_l(int air) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187517_aG;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187515_aE;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_STATE, this.getState());
        compound.func_74768_a("SpawnTime", this.spawnTime);
        compound.func_74768_a("SwirlTime", this.swirlTime);
        compound.func_74768_a("ThrowTime", this.throwTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState(compound.func_74771_c(KEY_STATE));
        this.spawnTime = compound.func_74762_e("SpawnTime");
        this.swirlTime = compound.func_74762_e("SwirlTime");
        this.throwTime = compound.func_74762_e("ThrowTime");
    }

    @Override
    public void setSwimmingUp(boolean swimmingUp) {
        this.swimmingUp = swimmingUp;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUpCalculated()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean isSwimmingUpCalculated() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public void setState(byte state) {
        this.func_184212_Q().func_187227_b(STATE, (Object)state);
        int clientFlag = 8;
        switch (state) {
            case 0: {
                this.throwTime = 0;
                this.swirlTime = 0;
                this.spawnTime = 0;
                break;
            }
            case 1: {
                this.spawnTime = 50;
                this.swirlTime = 0;
                this.throwTime = 0;
                clientFlag = 9;
                break;
            }
            case 2: {
                this.spawnTime = 0;
                this.swirlTime = 1;
                this.throwTime = 0;
                clientFlag = 10;
                break;
            }
            case 4: {
                this.spawnTime = 0;
                this.swirlTime = 0;
                this.throwTime = 1;
                clientFlag = 11;
            }
        }
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)clientFlag);
        }
    }

    public byte getState() {
        return (Byte)this.func_184212_Q().func_187225_a(STATE);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public boolean isSwirling() {
        return this.swirlTime > 0 || this.getState() == 2;
    }

    public boolean isThrowing() {
        return this.throwTime > 0 || this.getState() == 4;
    }

    public float getSpawnPercent() {
        return 1.0f - (float)this.spawnTime / 50.0f;
    }

    public float getSwirlPercent() {
        return (float)this.swirlTime / 240.0f;
    }

    public float getThrowPercent() {
        return (float)this.throwTime / 34.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 0: {
                this.setState((byte)0);
                break;
            }
            case 9: {
                this.setState((byte)1);
                break;
            }
            case 10: {
                this.setState((byte)2);
                break;
            }
            case 11: {
                this.setState((byte)4);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public boolean isWithinDistance(Entity e, float dis) {
        return this.func_70068_e(e) < (double)(dis * dis);
    }

    public List<Entity> getEntitiesInRange(double range) {
        return this.func_130014_f_().func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(range, range / 2.0, range), EntityPredicates.field_188444_d.and(e -> e.func_203005_aq()));
    }

    public void bubbles(double posX, double posY, double posZ, double radius, int count) {
        double motion = 0.08;
        for (int i = 0; i < count; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, posY, posZ + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * radius, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08, 0.5, (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.08);
        }
    }

    class ThrowGoal
    extends Goal {
        protected final CharybdisEntity entity;
        protected final int duration;
        protected final int cooldown;
        protected final double range;
        protected List<Entity> trackedEntities = new ArrayList<Entity>();
        protected int progressTime;
        protected int cooldownTime;

        public ThrowGoal(int lDuration, int lCooldown, double lRange) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.entity = CharybdisEntity.this;
            this.duration = lDuration;
            this.cooldown = lCooldown;
            this.range = lRange;
            this.cooldownTime = 50;
        }

        public boolean func_75250_a() {
            if (this.cooldownTime > 0) {
                --this.cooldownTime;
            } else if (this.entity.isNoneState() || this.entity.isThrowing()) {
                this.trackedEntities = this.entity.getEntitiesInRange(this.range);
                return this.trackedEntities.size() > 0;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.setState((byte)4);
            this.entity.throwTime = 1;
            this.progressTime = 1;
        }

        public boolean func_75253_b() {
            return this.progressTime > 0 && this.entity.isThrowing();
        }

        public void func_75246_d() {
            if (this.progressTime++ >= this.duration) {
                double widthSq = this.entity.func_213311_cf() * this.entity.func_213311_cf();
                this.trackedEntities = this.entity.getEntitiesInRange(this.range);
                for (Entity target : this.trackedEntities) {
                    double dz;
                    double dx = this.entity.func_226277_ct_() - target.func_213303_ch().field_72450_a;
                    double horizDisSq = dx * dx + (dz = this.entity.func_226281_cx_() - target.func_213303_ch().field_72449_c) * dz;
                    if (!(horizDisSq > widthSq)) continue;
                    double motion = 1.08 + 0.31 * (1.0 - horizDisSq / (this.range * this.range));
                    target.func_70024_g(0.0, motion, 0.0);
                    target.field_70133_I = true;
                    if (!(target instanceof BoatEntity) && target.func_184188_bt().isEmpty()) continue;
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 6.0f);
                }
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.entity.setState((byte)0);
            this.entity.throwTime = 0;
            this.progressTime = 0;
            this.cooldownTime = this.cooldown;
            this.trackedEntities.clear();
        }
    }

    private static class SwirlGoal
    extends greekfantasy.entity.ai.SwirlGoal<CharybdisEntity> {
        public SwirlGoal(CharybdisEntity entityIn, int lDuration, int lCooldown, double lRange) {
            super(entityIn, lDuration, lCooldown, lRange, true);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && (((CharybdisEntity)this.entity).isNoneState() || ((CharybdisEntity)this.entity).isSwirling());
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((CharybdisEntity)this.entity).setState((byte)2);
            ((CharybdisEntity)this.entity).swirlTime = 1;
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && ((CharybdisEntity)this.entity).isSwirling();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((CharybdisEntity)this.entity).setState((byte)0);
            ((CharybdisEntity)this.entity).swirlTime = 0;
        }

        @Override
        protected void onCollideWith(Entity e) {
            float attack = (float)((CharybdisEntity)this.entity).func_110148_a(Attributes.field_233823_f_).func_111126_e();
            if (e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), attack)) {
                ((CharybdisEntity)this.entity).func_70691_i(Math.abs(attack * 0.25f));
            }
        }

        @Override
        protected boolean canSwirl(Entity e) {
            return target.test(e);
        }
    }

    class SwimToSurfaceGoal
    extends SwimGoal {
        public SwimToSurfaceGoal() {
            super((MobEntity)CharybdisEntity.this);
        }

        public boolean func_75250_a() {
            BlockPos pos = CharybdisEntity.this.func_233580_cy_().func_177981_b((int)Math.ceil(CharybdisEntity.this.func_213302_cg()));
            BlockState state = CharybdisEntity.this.field_70170_p.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150355_j && super.func_75250_a();
        }
    }
}

