/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.misc.SwineSpellEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class CirceEntity
extends MonsterEntity
implements IRangedAttackMob {
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);
    protected static final Predicate<LivingEntity> NOT_SWINE = e -> e != null && null == e.func_70660_b(GFRegistry.SWINE_EFFECT);

    public CirceEntity(EntityType<? extends CirceEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233826_i_, 1.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new IntervalRangedAttackGoal(this, 90, 1, GreekFantasy.CONFIG.getSwineWandCooldown() * 4));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, 6.0f, 1.4, 1.2, e -> NOT_SWINE.test((LivingEntity)e) && e == this.func_70638_az()));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8){

            public boolean func_75250_a() {
                return null == CirceEntity.this.func_70638_az() && CirceEntity.this.field_70146_Z.nextInt(90) == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{WitchEntity.class, CirceEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, NOT_SWINE.and(e -> GreekFantasy.CONFIG.canSwineApply(e.func_200600_R().getRegistryName().toString())).and(EntityPredicates.field_233583_f_)));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetTargetGoal());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)GFRegistry.SWINE_WAND));
        return data;
    }

    public void func_82196_d(LivingEntity arg0, float arg1) {
        if (!this.field_70170_p.func_201670_d()) {
            SwineSpellEntity spell = SwineSpellEntity.create(this.field_70170_p, (LivingEntity)this);
            this.field_70170_p.func_217376_c((Entity)spell);
        }
        this.func_184185_a(SoundEvents.field_193784_dd, 1.2f, 1.0f);
        this.func_184609_a(Hand.MAIN_HAND);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187923_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
        this.bossInfo.func_186739_a(this.func_145818_k_() ? this.func_200201_e() : this.func_145748_c_());
        this.bossInfo.func_186758_d(GreekFantasy.CONFIG.showCirceBossBar());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class ResetTargetGoal
    extends Goal {
        protected int interval;

        public ResetTargetGoal() {
            this(10);
        }

        public ResetTargetGoal(int intervalIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
            this.interval = Math.max(1, intervalIn);
        }

        public boolean func_75250_a() {
            return CirceEntity.this.field_70173_aa % this.interval == 0 && CirceEntity.this.func_70089_S() && CirceEntity.this.func_70638_az() instanceof LivingEntity && CirceEntity.this.func_70638_az().func_70660_b(GFRegistry.SWINE_EFFECT) != null;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            CirceEntity.this.func_70624_b(null);
        }
    }
}

