/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DrakainaEntity
extends MonsterEntity {
    private static final DataParameter<Byte> DATA_VARIANT = EntityDataManager.func_187226_a(DrakainaEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String KEY_VARIANT = "Variant";
    private static final String KEY_BVARIANT = "BVariant";

    public DrakainaEntity(EntityType<? extends DrakainaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
        this.func_184644_a(PathNodeType.WATER, -0.5f);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233823_f_, 2.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_VARIANT, (Object)Variant.GREEN.getId());
    }

    public void func_70636_d() {
        if (this.func_70089_S()) {
            boolean flag;
            boolean bl = flag = this.shouldBurnInDay() && this.func_204609_dp();
            if (flag) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_189106_R;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected float func_70599_aP() {
        return 0.68f;
    }

    public ResourceLocation func_184647_J() {
        return this.getVariant().getLootTable();
    }

    public boolean func_230279_az_() {
        return this.getVariant() == Variant.RED || super.func_230279_az_();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity && ((Boolean)GreekFantasy.CONFIG.DRAKAINA_ATTACK.get()).booleanValue()) {
                LivingEntity entity = (LivingEntity)entityIn;
                Variant variant = this.getVariant();
                switch (variant) {
                    case RED: {
                        entity.func_70015_d(2 + this.field_70146_Z.nextInt(4));
                        break;
                    }
                    case BROWN: {
                        entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 20 * (2 + this.field_70146_Z.nextInt(5))));
                        break;
                    }
                    case GREEN: {
                        entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 20 * (2 + this.field_70146_Z.nextInt(5))));
                    }
                }
            }
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
            return true;
        }
        return false;
    }

    protected boolean shouldBurnInDay() {
        return this.getVariant() != Variant.RED;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Variant variant = reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER ? Variant.getRandom(worldIn.func_201674_k()) : Variant.getForBiome(worldIn.func_242406_i(this.func_233580_cy_()));
        this.setVariant(variant);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a(KEY_BVARIANT, this.getVariant().getId());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(KEY_VARIANT)) {
            this.setVariant(Variant.getByName(compound.func_74779_i(KEY_VARIANT)));
        } else {
            this.setVariant(Variant.getById(compound.func_74771_c(KEY_BVARIANT)));
        }
    }

    public void setVariant(Variant variant) {
        this.func_184212_Q().func_187227_b(DATA_VARIANT, (Object)variant.getId());
    }

    public Variant getVariant() {
        return Variant.getById((Byte)this.func_184212_Q().func_187225_a(DATA_VARIANT));
    }

    public static enum Variant implements IStringSerializable
    {
        GREEN("green"),
        BROWN("brown"),
        RED("red");

        private final String name;
        private final ResourceLocation lootTable;

        private Variant(String nameIn) {
            this.name = nameIn;
            this.lootTable = new ResourceLocation("greekfantasy", "entities/drakaina/" + this.name);
        }

        public static Variant getForBiome(Optional<RegistryKey<Biome>> biome) {
            if (biome.isPresent()) {
                if (BiomeDictionary.hasType(biome.get(), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                    return RED;
                }
                if (BiomeDictionary.hasType(biome.get(), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType(biome.get(), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType(biome.get(), (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) || BiomeDictionary.hasType(biome.get(), (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                    return BROWN;
                }
            }
            return GREEN;
        }

        public static Variant getRandom(Random rand) {
            int len = Variant.values().length;
            return Variant.values()[rand.nextInt(len)];
        }

        public static Variant getByName(String n) {
            if (n != null && !n.isEmpty()) {
                for (Variant t : Variant.values()) {
                    if (!t.func_176610_l().equals(n)) continue;
                    return t;
                }
            }
            return GREEN;
        }

        public static Variant getById(byte id) {
            return Variant.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(Variant.values().length - 1))];
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

